
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: eventsubs.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.6.1  2000/09/06  19:34:21  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.4  2000/06/22  19:36:39  Todd_Moyer
# 	Changed getCallbackStat to return null if all is well.
#
# Revision 1.1.2.3  2000/06/22  15:53:31  Todd_Moyer
# 	Append the subscription obj name when invoking callback.  Save callback status and provide means for getting it.
#
# Revision 1.1.2.2  1999/12/15  21:43:02  Todd_Moyer
# 	Changed 'autogen' to the correct 'gensym'.
#
# Revision 1.1.2.1  1999/12/15  14:33:43  Todd_Moyer
# 	Created.
# 	[1999/12/15  14:30:50  Todd_Moyer]
#
# $EndLog$
# 
# @(#)$RCSfile: eventsubs.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class EventSubscript -superclass _UIT_Tree

#@ Class to manage an event subscription callback.  All events
#@   will not block.  The callback will be invoked when an event
#@   is available.
#@
#@ EventSubscript name -command command
#@                {-eventNamePrefix eventNamePrefix | -eventSpec eventSpec}
#@                [-clientData clientData]
#@     clientData - an optional string for initializing the clientData.
#@                  It can be used to convey any type of info to the callback.
#@                  The callback will need to be a method on this object or
#@                  will need to be given a pointer to this object to retrieve
#@                  this value.
#@     command - the command to invoke when an event matching the subscription
#@               has been posted. You can define methods on the EventSubscript 
#@               object once it has been created, and call them as 
#@               "-command {$self methName arg1 arg2 ...}".
#@               If the object is defined in Suit's GenUID file, the callback
#@               can be defined in the callback file. If the object isn't
#@               created until a callback, it cannot define methods until
#@               after it is created.
#@     eventNamePrefix - The beginning of an event name used for the simplest
#@                       and most common kind of filter.  Mutually exclusive
#@                       with the -eventSpec parameter.
#@     eventSpec - The event filter string.  May contain any legal event filter
#@                 specification (see the EvmFilter (5) man page).  More
#@                 powerful but more complicated than -eventNamePrefix
#@                 because it may include priority, time and/or any
#@                 valid filter pattern.  Mutually exclusive
#@                 with the -eventSpec parameter.

#@ Need this switch and proc to figure if system is ready to take
#@   EVM notification or if it's still initializing.  Once system ready,
#@   start all existing and subsequent instances.

EventSubscript set               _sysReady          0
Main           regForStartNotify "EventSubscript"

EventSubscript proc sysReadyCB {} {

    EventSubscript set _sysReady 1
    foreach subscript [EventSubscript info instances] {
	$subscript _start
    }
}



EventSubscript instproc init {args} {
    $self instvar _clientData _command _errorInfo _errorMsg _eventAPI _filter
    global _UIT_g_main

    # initialize with defaults
    set _clientData  ""
    set _command     ""
    set _errorInfo   ""
    set _errorMsg    ""
    set _filter      {[name *]}     ;# subscribe to any named event by default

    set _eventAPI    [Event gensym]

    eval $self next $args

    if {[EventSubscript set _sysReady]} {
	$self _start
    }
}


#@ Clean up event "tenticle" before quiting.

EventSubscript instproc destroy {} {
    $self instvar _eventAPI

    $_eventAPI destroy

    $self next
}



# ================ Creation parameter initialization ================
# These sevice arguments specified as part of creation, but can also
# be called afterwards.

#@ Creation parameter initialization.
#@   Set any kind of data for later retrieval from the callback.

EventSubscript instproc clientData {clientData} {
    $self set _clientData $clientData
}


#@ Creation parameter initialization.
#@   Set the callback procedure including parameters.

EventSubscript instproc command {cmd} {
    $self set _command $cmd
}


#@ Creation parameter initialization.
#@   Set the filter with a simple name prefix.
#@   For example, "sys.unix.sysman" would call the callback command
#@   anytime any system management event was logged.

EventSubscript instproc eventNamePrefix {eventNamePrefix} {
    $self set _filter "\[name $eventNamePrefix\]"
}



#@ Creation parameter initialization.
#@   Set the filter with any valid filter specification.
#@   For example, "[name foo.bar] & [pri >= 500]" would call the callback
#@   command anytime any foo.bar.* with priority 500 or greater was event
#@   was logged.  Unless you need time or priority filtering, you'd be
#@   better off with the -eventNamePrefix parameter.

EventSubscript instproc eventSpec {eventSpec} {
    $self set _filter $eventSpec
}



# ====================== Convenience Methods ======================


#@ Get the status of the last subscription callback attempt.  Returns ""
#@   if all is well, or a msg and the stack trace if not.
#@   Errors are quitely ignored unless asked for with this method because
#@   they are in asynchronous code and the appropriate reporting vehicle
#@   depends on the particular app.

EventSubscript instproc getCallbackStat {} {
    $self instvar _errorInfo _errorMsg

    if { ! [cequal $_errorInfo ""]} {
	return "Error: $_errorMsg\n$_errorInfo"
    }
    return ""
}


#@ Returns an EventInfo object for the current event.
#@   Must only be called when the callback has been notified that an event
#@   has been received.

EventSubscript instproc getEventInfo {} {
    $self instvar _clientData _eventAPI

    return [EventInfo gensym $_eventAPI -clientData $_clientData]
}


# ======================== Private Methods ========================

#@ The internal Event object calls here when an event arrives.
#@   This calls the user-specified callback with this object's name
#@   appended as the last argument.  This may be redundant in
#@   some cases, but is helpful for subscriptions with
#@   generated names.

EventSubscript instproc _eventArrivedCB {args} {
    $self instvar _command _errorInfo _errorMsg

    # Since this is run in async code, errors are generally not reported;
    #   it just looks like the subscription isn't working.
    #   Save any error info so it can be reported if requested.
    if {[catch "eval $_command $self" msg]} {
	global errorInfo
	set _errorInfo $errorInfo
	set _errorMsg  \
	    "There was a problem invoking the callback when an event arrived."
    } else {
	set _errorInfo ""
	set _errorMsg  ""
    }
}


#@ Activates the subscription once Suit is initialized.
#@   Sets up a callback back to this object when the event subscribed to
#@   arrives.  This extra level of indirection provides more flexibility
#@   to manipulate arguments and catch errors.

EventSubscript instproc _start {} {
    $self instvar _eventAPI _filter

    $_eventAPI setFilter $_filter
    $_eventAPI subscribe nowait "eval $self _eventArrivedCB"
}


# ======================== End ========================
