# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: geogui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:43  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.14  1999/10/13  20:12:45  Richard_Taft
# 	Don't use the name of a named geowidget in path name of contents.  In
# 	other words, a text box named t in an across a in a window w would be
# 	referred to as w.t, not w.t.a, in the callback file.
# 	[1999/10/13  15:50:02  Richard_Taft]
#
# 	mfile.txt
# 	[1999/10/11  20:14:40  Richard_Taft]
#
# Revision 1.1.2.13  1998/03/16  20:09:12  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:37  William_Athanasiou]
#
# Revision 1.1.2.12  1997/12/12  20:08:50  William_Athanasiou
# 	fix new UI for large Enums
# 	[1997/12/12  20:08:14  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/12/12  14:53:17  William_Athanasiou
# 	Partial fix causing problems on bos'd system
# 	[1997/12/11  17:00:30  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/11/12  15:34:38  William_Athanasiou
# 	expand kids across row
# 	[1997/11/12  15:33:37  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/18  17:11:10  William_Athanasiou
# 	use _displayedOnce to denote that window/widget has been displayed at least once
# 	[1997/08/18  16:49:43  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/04/11  15:26:30  William_Athanasiou
# 	Fixed geom expansion when across and down mixed.
# 	[1997/04/11  15:26:02  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/03/31  18:49:31  William_Athanasiou
# 	no changes made
# 	[1997/03/31  18:41:04  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/03/28  16:46:40  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:12  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/03/13  17:45:04  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:48  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/03/13  15:17:40  William_Athanasiou
# 	Added Curses Geometry management
# 	[1997/03/13  15:16:40  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/03/07  20:51:39  William_Athanasiou
# 	Added capability to align labels in chamwdgts
# 	[1997/03/07  20:50:29  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/03/07  19:08:06  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:36  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: geogui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

Class _UIT_AcrossGUI -superclass _UIT_GeometryMgmt

_UIT_AcrossGUI instproc init {contents args} {
   eval {$self next} $args

   $self fillContents $contents

}

_UIT_AcrossGUI instproc display {} {
   $self instvar _displayedOnce 
   if {!$_displayedOnce} {
      $self instvar padLeft padTop _parent containWdgt _frm

      incr _displayedOnce
      set root [$_parent set containWdgt]

      # get unique Id from end of instance name.  This Uid was generated
      # when the Across proc created an instance of _UIT_Across using
      # gensym as the name of the instance.

      regsub -all {\.} $self {} name
      set _frm [_UIT_PaddedFrame $root.a${name} $padLeft $padTop]
      set win [$_frm childsite]
   
      set containWdgt [frame $win.f]
      pack $win.f -expand 1 -fill both

      pack $_frm -side [$_parent packSide] -anchor nw -expand 1 -fill both

   } else {
       $self instvar _parent _frm

       pack $_frm -side [$_parent packSide] -anchor nw -expand 1 -fill both
   }

   $self next
}

_UIT_AcrossGUI instproc hide {} {
    $self instvar _displayedOnce containWdgt

    if {$_displayedOnce} {
       $self instvar _frm
       pack forget $_frm
    }
}

_UIT_AcrossGUI instproc configure {args} {
    $self instvar _frm
    eval {[$_frm set _Wdgt(hullcmd)] configure} $args
}

_UIT_AcrossGUI instproc packSide {} {
    return left
}

########################################################################


Class _UIT_DownGUI -superclass _UIT_GeometryMgmt

_UIT_DownGUI instproc init {contents args} {
   eval {$self next} $args

   $self fillContents $contents
}

_UIT_DownGUI instproc display {} {
   $self instvar _displayedOnce _parent _frm

   if {!$_displayedOnce} {
      $self instvar padLeft padTop _parent _displayedOnce containWdgt _frm

      incr _displayedOnce
      set root [$_parent set containWdgt]
      
      # get unique Id from end of instance name.  This Uid was generated
      # when the Across proc created an instance of _UIT_Across using
      # gensym as the name of the instance.
      
       regsub -all {\.} $self {} name
      set _frm [_UIT_PaddedFrame $root.d${name} $padLeft $padTop]
      set containWdgt [$_frm childsite]   

      if {[string match {_UIT_Across*} [$_parent info class]]} {
	 pack $_frm -side left -anchor nw -fill both -expand 1
      } else {
	 pack $_frm -anchor nw -fill both -expand 1
      }

      $self next

      #
      # Perform some post processing on the kids of this frame.

      set alist {}
      set tlist {}
      set expand 0
      set fill x
      foreach kid [$self set _kids] {

	 #
	 # create list of wdgts that can be aligned

	 set val [$kid _isAlignable]
	 if {$val != {}} {
	    lappend alist $val
	 }
	 
	 #
	 # Should this frame expand and fill?
	 switch -glob [$kid info class] {
	    _UIT_Text* {
	       if {[$kid set height] > 1} {
		  set expand 1; set fill both
	       }
	    }
	    
	    _UIT_List* -
	    _UIT_Across* -
	    _UIT_Down* {
	       set expand 1; set fill both
	    }

	    default {
	    }
	 }
      }

      #
      # update pack constraints.

      pack configure $_frm -expand $expand -fill $fill

      #
      # Align wdgts

      if {[llength $alist] > 1} {
	 eval [lindex $alist 0] alignlabels $alist
      }

   } else {
       $self instvar containWdgt
       pack $containWdgt -anchor nw
       $self next
   }
}

_UIT_DownGUI instproc hide {} {
    $self instvar _displayedOnce containWdgt
    if {$_displayedOnce} {
	pack forget $containWdgt
    }
}

_UIT_DownGUI instproc _realignWdgts {} {
   set alist {}
   foreach kid [$self set _kids] {
      set val [$kid _isAlignable] 
      if ![cequal $val ""] {
	 lappend alist $val
      }
   }
   if {[llength $alist] > 1} {
      foreach i $alist {
	 $i configure -labelmargin 1
      }
      eval [lindex $alist 0] alignlabels $alist
   }
}

_UIT_DownGUI instproc configure {args} {
    $self instvar _frm
    eval {[$_frm set _Wdgt(hullcmd)] configure} $args
}

_UIT_DownGUI instproc packSide {} {
    return top
}

