#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: geojava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.10.2  2000/05/05  14:15:06  Jie_Luo
# 	Added Widgets Name
# 	put the widget name to java side in the display method
#
# Revision 1.1.8.1  2000/04/25  21:57:07  Jie_Luo
# *** Initial Branch Revision ***
#
# Revision 1.1.7.1  1999/10/11  20:17:36  Richard_Taft
# 	mfile.txt
#
# Revision 1.1.2.11  1998/04/10  17:09:35  William_Athanasiou
# 	Reverse order of xmited padTop and padLeft
# 	[1998/04/10  17:06:06  William_Athanasiou]
#
# Revision 1.1.2.10  1997/08/22  18:46:10  William_Athanasiou
# 	Fix protocol: no trailing spaces are allowed
# 	[1997/08/22  18:34:11  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/20  13:00:47  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Took out unnecessary code from display
# 	[1997/07/24  19:55:22  Richard_Taft]
# 
# Revision 1.1.2.8  1997/08/18  17:11:11  William_Athanasiou
# 	use _displayedOnce to denote that window/widget has been displayed at least once
# 	[1997/08/18  16:49:48  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/21  18:19:00  Richard_Taft
# 	Catch exception if javaKnows me is not yet set
# 	[1997/07/21  18:18:13  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/18  19:54:49  Richard_Taft
# 	changed puts to putJava
# 	[1997/07/18  19:53:24  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/14  19:54:50  Todd_Moyer
# 	Changed "puts" to "putJava".
# 	[1997/07/14  19:45:02  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/07/02  19:01:15  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:56:20  Deepa_Bachu]
# 
# Revision 1.1.2.3  1997/06/23  12:58:23  Deepa_Bachu
# 	Made modifications to the Tcl->Java communication.
# 	[1997/06/23  12:57:30  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/19  15:26:48  Deepa_Bachu
# 	Initial JAVA geometry management class.
# 	[1997/06/19  15:25:28  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: geojava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 

#######################  Across Class  ################################

Class _UIT_AcrossJAVA -superclass _UIT_GeometryMgmt

_UIT_AcrossJAVA instproc init {contents args} {

   eval $self next $args ;# do parents init

   # Named geo widgets probably don't have a # in their names.
   # The contents of named geo widgets must use the name in their
   # paths, just like the contents of windows do.
   global _UIT_g_main
   set anonymous [string match "*\#*" $self]
   if { !$anonymous } {
       set savePath [$_UIT_g_main set currPath]
       $_UIT_g_main set currPath $self
   }

   $self fillContents $contents

   # Restore original path name.
   if { !$anonymous } {
       $_UIT_g_main set currPath $savePath
   }
}


_UIT_AcrossJAVA instproc display {} {
    $self instvar _displayedOnce

    if { ! $_displayedOnce } {
	# Note that the name ($self) comes last 
	# (see SuitContainer.java for the reason).
	putJava "_UIT_Across [$self set padTop] [$self set padLeft] $self"
   
	$self next ;# do kids' display

	putJava "\}"

	incr _displayedOnce 

    } else {
#	putJava "$self display"
    }	
}

_UIT_AcrossJAVA instproc hide {} {
    $self instvar _displayedOnce
    if { ! $_displayedOnce } {
#	putJava "$self hide"
    } 
}

#######################  Down Class  ################################

Class _UIT_DownJAVA -superclass _UIT_GeometryMgmt

_UIT_DownJAVA instproc init {contents args} {
   eval $self next $args ;# do parents init
   
   # Named geo widgets probably don't have a # in their names.
   # The contents of named geo widgets must use the name in their
   # paths, just like the contents of windows do.
   global _UIT_g_main
   set anonymous [string match "*\#*" $self]
   if { !$anonymous } {
       set savePath [$_UIT_g_main set currPath]
       $_UIT_g_main set currPath $self
   }

   $self fillContents $contents

   # Restore original path name.
   if { !$anonymous } {
       $_UIT_g_main set currPath $savePath
   }
}

_UIT_DownJAVA instproc display {} {
   $self instvar _displayedOnce

   if {!$_displayedOnce} {
      # Note that the name ($self) comes last 
      # (see SuitContainer.java for the reason).
      putJava "_UIT_Down [$self set padTop] [$self set padLeft] $self"
      
      $self next ; # do kids display
      
      putJava "\}"
      incr _displayedOnce
   } else {
#	putJava "$self display"
   }
}

_UIT_DownJAVA instproc hide {} {
    $self instvar _displayedOnce

    if { $_displayedOnce } {
#	putJava "$self hide"
    } 
}

