# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: group.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.2  1999/11/05  21:38:53  Omar_Ortiz
# 	{** Forced Submit **}
# "	Copied files from the sysman shared sandbox into Zulu
#
# Revision 1.1.2.13  1999/11/02  19:11:55  Omar_Ortiz
# 	Turned on the wait flag for the InfoMsg in case of errors
#
# Revision 1.1.2.12  1998/11/30  21:52:10  Todd_Moyer
# 	Allow for manual override on error reporting.
# 	[1998/11/30  21:51:08  Todd_Moyer]
#
# Revision 1.1.2.11  1997/08/19  18:33:15  Todd_Moyer
# 	Don't report modify errors as system errors.
# 	Added validate method.
# 	[1997/08/19  18:05:41  Todd_Moyer]
# 
# Revision 1.1.2.10  1997/04/03  13:22:23  Todd_Moyer
# 	Put out error msg as a string, not a list.
# 	[1997/04/03  13:18:53  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/03/26  19:56:01  Todd_Moyer
# 	Delete the setRec method and add a modify method (was in rsrc.tcl).
# 	[1997/03/26  16:25:14  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/01/31  16:42:28  Todd_Moyer
# 	Changed _UIT_Group to Group in init proc.
# 	[1997/01/31  16:41:28  Todd_Moyer]
# 
# Revision 1.1.2.7  1997/01/30  22:48:07  Todd_Moyer
# 	Return an error code from setRec.
# 	[1997/01/30  22:41:00  Todd_Moyer]
# 
# Revision 1.1.2.6  1997/01/30  21:17:59  Todd_Moyer
# 	Changed rec ID from 1 to "only".
# 	[1997/01/30  20:31:20  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/01/27  19:41:02  Todd_Moyer
# 	Added an instvar to hold the attribute names and now have the data
# 	  as a list in an order that corresponds to the attributes.  This
# 	  is like the way tables work.
# 	[1997/01/27  19:40:12  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/01/16  14:27:32  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.2 **
# 		** Merge revision:	1.1.2.3 **
# 	 	** End **
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:34  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/01/15  19:27:27  Todd_Moyer
# 	Fixed a small bug in getRec method.
# 	[1997/01/15  19:23:51  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/11/27  23:22:41  Todd_Moyer
# 	Created.
# 	[1996/11/27  23:02:59  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: group.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 



# A group holds exactly one record indexed by 1.


Class _UIT_Group -superclass _UIT_Rsrc

# ---------------------------------------------------

_UIT_Group instproc init {dataID} {
    eval $self next Group $dataID
    $self set _atts ""
    $self set _data ""
}


# ===================================================
# public methods.

# ---------------------------------------------------
# Set the record buffer to the data from the record.

_UIT_Group instproc buffer {} {
   [$self set _recBuf] read only
}


# ---------------------------------------------------
# Load the specified record into the specified array.
# Used by _UIT_Rec to read its values and lists to format
# display strings.
# This method needs an ID, even though it doesn't use it, so it's signature
# is like other resources.

_UIT_Group instproc getRec {id arrName} {
    upvar 1 $arrName arr

    set vals [$self set _data]
    set i 0
    foreach att [$self set _atts] {
	set arr($att) [lindex $vals $i]
	incr i
    }
}


# ---------------------------------------------------
# Modify the record.
#   Validate the recBuf values, and write them into this object.
#   If it fails, display an error msg.
# Return the status: "" if OK or a list of error codes if not.

_UIT_Group instproc modify {} {
    $self instvar _data _dispError _recBuf

    # get record data into list format
    array set data [$_recBuf getVals]
    $self _cvtArr2Lst data newRec

    # validate record in data layer
    set stat [$self _validateDL newRec]
    if {! [cequal $stat ""]} {    
	if {$_dispError} {
	    InfoMsg error $stat "" 1
	}
	return $stat
    }

    # modify record in data layer
    set stat [$self _modifyDL newRec]
    if {! [cequal $stat ""]} {    
	if {$_dispError} {
	    InfoMsg error $stat "" 1
	}
	return $stat
    }

    # if OK, overwrite resource record
    set _data $newRec
    
    return ""
}


# ---------------------------------------------------
# Validate the record, and if it fails, display an error msg.
# Return the status: "" if OK or a list of error codes if not.

_UIT_Group instproc validate {} {
    $self instvar _data _dispError _recBuf

    # get record data into list format
    array set data [$_recBuf getVals]
    $self _cvtArr2Lst data newRec

    # validate record in data layer
    set stat [$self _validateDL newRec]
    if {! [cequal $stat ""]} {    
	if {$_dispError} {
	    InfoMsg error $stat "" 1
	}
    }

    return $stat
}


# ====================== pure virtual methods =============================
# These methods are not defined in this abstract class, but must be in the
# subclasses that will actually be instantiated.

# ---------------------------------------------------
# Read the data from the data layer and expand the record into the buffer.
# Assumes there is exactly one record.

_UIT_Group instproc read {} {
    pureVirtual _UIT_Group read
}


# ---------------------------------------------------
# Does the data layer-specific work for modify.

_UIT_Group instproc _modifyDL {newRecRef} {
    pureVirtual _UIT_Group _modifyDL
}


# ---------------------------------------------------
# Does the data layer-specific work for validation.

_UIT_Group instproc _validateDL {newRecRef} {
    pureVirtual _UIT_Group _validateDL
}


# ===================================================
