# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: grpdmi.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.2  1999/12/16  20:56:21  William_Athanasiou
# 	sysman bulk submit for BL7
#
# Revision 1.1.2.12  1999/12/15  14:33:44  Todd_Moyer
# 	Moved 'initFetch' switch from 'read' to 'init'.
#
# Revision 1.1.2.11  1999/11/04  21:16:05  Omar_Ortiz
# 	Made changes to the "_UIT_GroupDMI instproc read"
# 	to take an optional argument "initFetch".
#
# Revision 1.1.2.10  1999/03/02  15:55:29  Todd_Moyer
# 	Fixed bug in yesterday's submit.
# 	[1999/03/02  15:54:56  Todd_Moyer]
#
# Revision 1.1.2.9  1999/03/01  21:21:58  Todd_Moyer
# 	Re-read the record after modifying it.  This is
# 	  important for mcls where values may change in the FLUSH.
# 	[1999/03/01  21:20:00  Todd_Moyer]
# 
# Revision 1.1.2.8  1998/03/19  17:53:48  Todd_Moyer
# 	Trim debug info off error msgs.
# 	[1998/03/19  17:51:19  Todd_Moyer]
# 
# Revision 1.1.2.7  1998/02/10  22:32:17  Todd_Moyer
# 	If miInit returns an error, display with infoMsg instead of error.
# 	[1998/02/10  22:22:43  Todd_Moyer]
# 
# Revision 1.1.2.6  1997/08/19  18:33:17  Todd_Moyer
# 	Don't report read or modify errors as system errors.
# 	[1997/08/19  18:09:04  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/04/03  13:22:24  Todd_Moyer
# 	Fixed call to miValidate.
# 	[1997/04/03  13:20:09  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/03/31  15:50:00  Todd_Moyer
# 	Added validation and error checking.
# 	[1997/03/28  15:14:52  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/01/27  19:41:03  Todd_Moyer
# 	Changed the data file format around to be like tables, that is, a list
# 	  of attributes in the first rec and the data in the second in the
# 	  same order.
# 	[1997/01/27  19:36:42  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/01/22  22:41:38  Todd_Moyer
# 	Created.
# 	[1997/01/22  22:40:52  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: grpdmi.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


#@ This class implements a group via DMI calls.
#@ It assumes there is exactly one record.
#@   Send the optional switch initFetch as zero if you don't want the
#@   values read initially.


Class _UIT_GroupDMI -superclass _UIT_Group


# ---------------------------------------------------

_UIT_GroupDMI instproc init {dataID {initFetch 1} } {

    eval $self next $dataID
    set lst [split $dataID /]
    $self set _comp       [lindex $lst 1]
    $self set _group      [lindex $lst 2]
    $self set _reallyRead $initFetch
    set stat [miInit [$self set _comp]]
    if {! [cequal $stat ""]} {
	InfoMsg error $stat "Initialization Error" 1
	exit
    }
}


# ---------------------------------------------------
#@ Read the data from the data layer and expand the record into the buffer.
#@ Assumes there is exactly one line.  The first time through the recored will
#@   not actually be read if the "initFetch" switch was set to off (zero).

_UIT_GroupDMI instproc read {} {
    $self instvar _atts _comp _data _group _reallyRead

    # reset to top of data
    set stat [miReadRow $_comp $_group reserved 0]
    if {! [cequal $stat ""]} {
	return $stat
    }

    set stat [miGetKids /$_comp/$_group _atts]
    if {! [cequal $stat ""]} {
	return $stat
    }

    # If first time and "initFetch" switch was set to off (zero), don't read.
    if {$_reallyRead} {
        set stat [miReadRow $_comp $_group _data]
        if {! [cequal $stat ""]} {
	    return $stat
        }
        if {[cequal $_data ""]} {
	    set    msg "_UIT_GroupDMI::read  Group /$_comp/$_group is empty.\n"
	    append msg "Groups should always have one record with "
	    append msg "at least one attribute."
	    error $msg
        }
    }
    # But do read after first time no matter what "initFetch" was.
    set _reallyRead 1

    $self buffer
    return ""
}


# ==================== Protected Methods ==============================

#@ Write the record to the data layer.
#@ Return the status: "" if OK or a msg if not.

_UIT_GroupDMI instproc _modifyDL {newRecRef} {
    $self instvar _comp _group _data
    upvar $newRecRef newRec

    MCL_ModRow $_comp $_group reserved $_data $newRec newRec
}


# ---------------------------------------------------
#@ Validate the values in the record buffer with the data layer and return
#@ the result.
#@ If everything is OK, "" is returned.
#@ Otherwise an error msg is returned.

_UIT_GroupDMI instproc _validateDL {newRecRef} {
    upvar $newRecRef newRec
    $self instvar _comp _group _data

    miValidate $_comp $_group reserved $_data $newRec
}


# ==================================================
