# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: grpfile.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:07:03  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:39:52  William_Athanasiou]
#
# Revision 1.1.2.3  1997/01/16  14:15:31  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:39  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/11/27  23:22:44  Todd_Moyer
# 	Created.
# 	[1996/11/27  23:20:42  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: grpfile.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


# This class implements a _UIT_Group as a file in array-get format.


Class _UIT_GroupFILE -superclass _UIT_Group


# ---------------------------------------------------

_UIT_GroupFILE instproc init {dataID} {
    eval $self next $dataID
}


# ---------------------------------------------------
# Read the data from the data layer and expand the record into the buffer.
# Assumes there is exactly one line.

_UIT_GroupFILE instproc read {} {
    $self instvar _data

    for_file line [$self set _dataID] {
	set     _data  $line
    }
    $self buffer
}


# ---------------------------------------------------
# Validate the values in the record buffer with the data layer and return
# the result.
# If everything is OK, OK is returned and the tag list is set to "".
# If one or more attributes are bad, BAD_ATTRS is returned and the tag list
# is set to the tags of the bad values.
# If the values are OK individually but two or more clash, ATTR_CLASH is
# returned and the tags of the clashing attributes are put in the
# tag list.

_UIT_GroupFILE instproc validate {badAttrsName} {
    upvar $badAttrsName badAttrs

    set badAttrs ""
    return OK
}


# ---------------------------------------------------
# Write the data to the data layer.

_UIT_GroupFILE instproc write {} {

    set f [open [$self set _dataID] w] 
    puts $f "[$self set _data]"
    close $f
}

# ==================================================
