# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: grptest.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.5  1997/08/26  16:28:25  Peter_Wolfe
# 	Code drop for bl12
# 	[1997/08/25  18:15:05  Peter_Wolfe]
#
# Revision 1.1.2.6  1997/08/19  18:33:18  Todd_Moyer
# 	Don't report read or modify errors as system errors.
# 	[1997/08/19  18:09:57  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/03/26  19:56:04  Todd_Moyer
# 	Added validation and updated modify to call it.
# 	[1997/03/26  16:30:16  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/01/27  19:41:06  Todd_Moyer
# 	Changed the data file format around to be like tables, that is, a list
# 	  of attributes in the first rec and the data in the second in the
# 	  same order.
# 	[1997/01/27  19:35:47  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/01/16  15:55:32  Todd_Moyer
# 	Prefixed names with _UIT_ to keep from polluting Tcl name space.
# 	[1997/01/16  15:49:09  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/01/15  19:27:29  Todd_Moyer
# 	Created.
# 	[1997/01/15  19:24:31  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: grptest.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


# This class implements a Group as a file in array-get format.
# Very similar to GroupFILE.


Class _UIT_GroupTEST -superclass _UIT_Group


# ---------------------------------------------------

_UIT_GroupTEST instproc init {dataID} {
    eval $self next $dataID

    # validation proc needs to be in the same directory as the data with
    #   the name resource-name.val.tcl
    # if file exists, load it.
    set valFile "[$self set _dataID].val.tcl"
    if {[file exists $valFile]} {
	source $valFile
    }
}


# ---------------------------------------------------
# Modify the record.
#   Validate the recBuf values, and if OK, write to data layer.
#   If any step fails, display an error msg.
# Return the status: "" if OK or a list of error codes if not.

_UIT_GroupTEST instproc _modifyDL {} {
    set stat [$self next]
    if {[cequal $stat ""]} {    

	# write to file
	set fileName [$self set _dataID]
	if {! [file writable $fileName]} {
	    set    msg "_UIT_GroupTEST::modify  Cann't open file $fileName for "
	    append msg "writing.  Check the pathname and permissions."
	     $msg
	}
	set   f  [open $fileName w]
	puts $f "[$self set _atts]"
	puts $f "[$self set _data]"
	close $f

    }
    return $stat
}



# ---------------------------------------------------
# Read the data from the data layer and expand the record into the buffer.
# Assumes there is exactly one line.

_UIT_GroupTEST instproc read {} {
    set fileName [$self set _dataID]
    if {! [file readable $fileName]} {
	set    msg "Cann't open file $fileName for reading."
	append msg "  Check the pathname and permissions."
	return [list $self read reset $msg]
    }
    set   f  [open $fileName r]
    set atts [gets $f]
    set data [gets $f]
    close $f
    if {[llength $atts] != [llength $data]} {
	set msg "There are [llength $atts] attributes "
	append msg "but [llength $data] pieces of data in group $self.\n"
	append msg "There must be the same number of each."
	return [list $self read getAtts $msg]
    }
    $self set _atts $atts
    $self set _data $data
    $self buffer
    return ""
}



# ===================== Protected Methods =============================

# Write the record to the data layer.
# Return the status: "" if OK or a msg if not.

_UIT_GroupDMI instproc _modifyDL {newRecRef} {
    upvar $newRecRef newRec

    # write to file
    set fileName [$self set _dataID]
    if {! [file writable $fileName]} {
	set    msg "_UIT_GroupTEST::modify  Cann't open file $fileName for "
	append msg "writing.  Check the pathname and permissions."
	return $msg
    }
    set    f  [open $fileName w]
    puts  $f "[$self set _atts]"
    puts  $f "[$self set _data]"
    close $f

    return ""
}



# ---------------------------------------------------
# Validate the values in the record buffer with the data layer and return
# the result.
# If everything is OK, "" is returned.
# Otherwise an error msg is returned.

_UIT_GroupTEST instproc _validateDL {newRecRef} {
    upvar $newRecRef newRec
    $self instvar _comp _group _data

    $self validateCB [$self set _data] $newRec
}



# ---------------------------------------------------
# Dummy validation in case no callback defined.

_UIT_GroupTEST instproc validateCB {oldRec newRec} {
    return  ""
}


# ==================================================
