#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: helpcur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.11  1999/02/03  18:45:52  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:31  Sandip_Savalia]
#
# Revision 1.1.2.13  1998/12/10  18:22:48  William_Athanasiou
# 	remove focus code since done by dialogshell
# 	[1998/12/10  18:22:29  William_Athanasiou]
# 
# Revision 1.1.2.12  1998/12/03  22:32:17  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:09  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/04/22  14:31:36  Richard_Taft
# 	Changed /usr/share/sysman to use global variable SysmanDir
# 	[1998/04/22  14:29:14  Richard_Taft]
# 
# Revision 1.1.2.10  1998/04/16  14:58:35  William_Athanasiou
# 	Set initial focus into help text
# 	[1998/04/16  14:34:51  William_Athanasiou]
# 
# Revision 1.1.2.9  1998/04/02  19:30:07  William_Athanasiou
# 	Fix keyboard traversal
# 	[1998/04/02  19:29:32  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/04/02  16:59:14  William_Athanasiou
# 	Fix problems with resetting help volume
# 	[1998/04/02  16:58:53  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/03/03  22:23:44  William_Athanasiou
# 	Fix help problems
# 	[1998/03/03  22:19:55  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/02/27  16:54:36  William_Athanasiou
# 	add ability to change title and helpvolume dynamically
# 	[1998/02/27  16:53:42  William_Athanasiou]
# 
# Revision 1.1.2.5  1998/01/27  15:14:00  William_Athanasiou
# 	Specify directory for help files
# 	[1998/01/27  15:13:24  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/07/31  15:22:40  William_Athanasiou
# 	Add ability to set help volume name
# 	[1997/07/28  13:43:02  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/05/01  19:34:08  William_Athanasiou
# 	Fixed function argument definition for helpView/helpOn
# 	[1997/05/01  19:28:35  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/04/24  20:39:53  William_Athanasiou
# 	Added helpOn functionality
# 	[1997/04/24  16:08:12  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: helpcur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_HelpCURSES -superclass _UIT_HelpGeneric

_UIT_HelpCURSES instproc init {args} {
   $self next
   $self set _displayedOnce 0
}

_UIT_HelpCURSES instproc viewHelp {{symbol {}}} {
   $self instvar _displayedOnce _uiRep _helpFileName _helpAppName
   
   if {!$_displayedOnce} {
      incr _displayedOnce
      global _UIT_g_main
      
      if [cequal $_helpAppName {}] {
	 set _helpAppName $_helpFileName
      }
      
      _UIT_Dialogshell .$self -separator off \
	  -title $_helpAppName
      set _uiRep [_UIT_Scrolledtext [.$self childsite].txt \
		      -visibleitems 70x16] 
      pack $_uiRep -side top -expand 1 -fill both
      $self _disable
      
      .$self addTkButton ok -text [$_UIT_g_main catget help.ok _lbl] \
	  -command "$self _closeHelp"
      .$self default ok
      bind .$self <Return> "$self _closeHelp"
      
      wm geometry .$self \
	  =[winfo screenwidth .$self]x[winfo screenheight .$self]
   }
   
   $self _readInFile $_helpFileName 
   
   .$self activate
   update idletasks
}

_UIT_HelpCURSES instproc _closeHelp {} {
   .$self deactivate
}

_UIT_HelpCURSES instproc setHelpName {appname} {
   # set name of help window dialog.
   $self next $appname
   $self instvar _displayedOnce
   if $_displayedOnce {
      .$self configure -title $appname
   }
}

_UIT_HelpCURSES instproc setHelpVolume {filename} {
   $self next $filename
}

_UIT_HelpCURSES instproc _readInFile {filename} {
   $self instvar _displayedOnce _uiRep

   global SysmanDir
   set FilePath ${SysmanDir}/web/suitlet_help/text/C

   if $_displayedOnce {
      $self _enable
      $_uiRep clear
      if [file readable ${FilePath}/${filename}.txt] {
	 $_uiRep import ${FilePath}/${filename}.txt
      } else {
	 $_uiRep insert end "Error:\n  The help volume\n\n\t${FilePath}/${filename}.txt\n\n  does not exist or is not reachable."
      }
      $_uiRep mark set insert 0.0
      $self _disable
   }
}
   
_UIT_HelpCURSES instproc _enable {} {
   $self instvar _displayedOnce _uiRep
   if {!$_displayedOnce} {return}

   $_uiRep configure -state normal
   [$_uiRep component text] configure -takefocus 1
   [$_uiRep component vertsb] configure -takefocus 1
   [$_uiRep component horizsb] configure -takefocus 1
}

_UIT_HelpCURSES instproc _disable {} {
   $self instvar _displayedOnce _uiRep
   if {!$_displayedOnce} {return}

   $_uiRep configure -state disabled
   [$_uiRep component text] configure -takefocus 1
   [$_uiRep component vertsb] configure -takefocus 1
   [$_uiRep component horizsb] configure -takefocus 1
}
