#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: helpgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.4  1998/03/26  20:00:05  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:01:20  Anthony_Hoffman]
#
# Revision 1.1.2.5  1998/03/03  22:23:44  William_Athanasiou
# 	Fix help problems
# 	[1998/03/03  22:20:00  William_Athanasiou]
# 
# Revision 1.1.2.4  1998/02/26  22:00:41  William_Athanasiou
# 	Add -catopen argument for sysman help
# 	[1998/02/17  21:15:23  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/07/31  15:22:41  William_Athanasiou
# 	locid's cannot have _ in them.  Split on _ as well as .
# 	[1997/07/31  15:21:21  William_Athanasiou]
# 
# 	Add ability to set help volume name
# 	[1997/07/28  13:43:05  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/07/16  21:25:26  William_Athanasiou
# 	Update help routines
# 	[1997/07/16  21:24:40  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: helpgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_HelpGeneric

_UIT_HelpGeneric instproc init {} {
   global _UIT_g_main
   $self set _helpAppName $_UIT_g_main
   $self set _helpFileName $_UIT_g_main
}

_UIT_HelpGeneric instproc convertLocId {symbol} {
   global _UIT_g_main

   if {$symbol == {}} {
      set symbol _hometopic     ;#default topic.
   } else {
      set catLocid [$_UIT_g_main catget $symbol locid]
      if {$catLocid != $symbol} {
	 set symbol $catLocid
      } else {
	 # translate symbol to a real looking bookmark.
	 set words [split $symbol ._]
	 set symbol {}
	 foreach i $words {
	    append symbol [string toupper [string index $i 0]] \
		  [string tolower [string range $i 1 end]]
	 }
      }
   }
   return $symbol
}

_UIT_HelpGeneric instproc setHelpName {appname} {
   $self set _helpAppName $appname
}

_UIT_HelpGeneric instproc setHelpVolume {filename} {
   $self set _helpFileName $filename
}


