#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: helpgui.tcl,v $
# Revision 1.3  2003/06/10 13:28:34  ajay
# Fixed a bug where clicking on help second time closes the first help window.
#
# Revision 1.2  2003/06/03 21:15:36  ajay
# Made changes to /usr/bin/netscape to display html help files.
#
# Revision 1.1.1.1  2003/01/23 18:34:35  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.8  1998/10/23  23:17:14  Peter_Wolfe
# 	Code drop for bl20
# 	[1998/10/23  22:26:32  Peter_Wolfe]
#
# Revision 1.1.2.15  1998/09/24  20:22:44  Richard_Taft
# 	Added helpAppName to instvar statement
# 	[1998/09/24  20:11:45  Richard_Taft]
# 
# Revision 1.1.2.14  1998/05/20  20:26:42  Sai_Akkapeddi
# 	Updated  sysmanhelp to ${SysmanDir}/bin/sysmanhelp
# 	so that sysmanhelp doesn't depend on PATH variable
# 	in _openViewer
# 	[1998/05/20  20:20:46  Sai_Akkapeddi]
# 
# Revision 1.1.2.13  1998/03/24  22:13:50  William_Athanasiou
# 	Fix problem with passing extra spaces to sysmanhelp
# 	[1998/03/24  22:13:27  William_Athanasiou]
# 
# Revision 1.1.2.12  1998/03/19  17:05:08  William_Athanasiou
# 	Fixed typo
# 	[1998/03/19  17:04:54  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/03/18  16:50:22  William_Athanasiou
# 	Add volume/name parameters as args to sysmanhelp
# 	[1998/03/18  16:49:56  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/03/09  19:22:38  William_Athanasiou
# 	Remove extra args to helpview
# 	[1998/03/09  19:04:19  William_Athanasiou]
# 
# Revision 1.1.2.9  1998/03/03  22:23:45  William_Athanasiou
# 	Fix help problems
# 	[1998/03/03  22:20:08  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/02/27  16:54:37  William_Athanasiou
# 	add ability to change title and helpvolume dynamically
# 	[1998/02/27  16:53:48  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/02/26  22:00:41  William_Athanasiou
# 	Add -catopen argument for sysman help
# 	[1998/02/17  21:15:26  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/08/27  19:23:50  William_Athanasiou
# 	remove change to helpgui.tcl
# 	[1997/08/27  19:23:11  William_Athanasiou]
# 
# 	fixed help system: added default arg and allow special locids
# 	[1997/08/27  19:07:48  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/07/31  15:22:42  William_Athanasiou
# 	Add ability to set help volume name
# 	[1997/07/28  13:43:07  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/07/16  21:25:27  William_Athanasiou
# 	Update help routines
# 	[1997/07/16  21:24:42  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/05/01  19:34:09  William_Athanasiou
# 	Fixed function argument definition for helpView/helpOn
# 	[1997/05/01  19:28:37  William_Athanasiou]
# 
# 	Updated for use with Fred's new catalog system
# 	[1997/05/01  16:45:10  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/04/24  20:39:54  William_Athanasiou
# 	Added helpOn functionality
# 	[1997/04/24  16:08:14  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: helpgui.tcl,v $ $Revision: 1.3 $ (DEC) $Date: 2003/06/10 13:28:34 $
# 


Class _UIT_HelpGUI -superclass _UIT_HelpGeneric

_UIT_HelpGUI instproc init {} {
   $self next
}

#
#@ Send the specified symbol to the viewer.  If no viewer is running, one is
#@ started.  If a new volume or application name has been specified then these
#@ are also sent.

_UIT_HelpGUI instproc viewHelp {{symbol {}}} {

   $self instvar _helpFileName _helpAppName

   global SysmanDir

   set FilePath ${SysmanDir}/web/suitlet_help/html/C

   set symbol [$self convertLocId $symbol]
   set symbol [ string tolower $symbol ]

   if [cequal $_helpAppName {}] {
       set _helpAppName $_helpFileName
   }

   if [file executable /usr/bin/netscape ] {
       exec /usr/bin/netscape ${FilePath}/${_helpFileName}.html#${symbol} &
   } else {
       set msg "/usr/bin/netscape not found.\n\nHelp requires netscape browser located at /usr/bin/netscape to display the help file. Please make sure that /usr/bin/netscape is available on the system.\n"
       InfoMsg error $msg "Help: Error" wait
   }
  
}
