#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: imagegui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/11/09  18:50:39  Susan_Ng
# 	Code drop for Zulu bl6
#
# Revision 1.1.2.3  1999/10/13  20:12:48  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
# 	[1999/10/12  14:36:14  Richard_Taft]
#
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
# 	[1999/10/11  20:03:34  Richard_Taft]
#
# Revision 1.1.2.2  1999/08/20  19:56:03  Joseph_Ruvel
# 	Deleted code that was not needed
# 	[1999/08/20  18:50:04  Joseph_Ruvel]
#
# 	Initial Image GUI file
# 	[1999/08/05  15:32:29  Joseph_Ruvel]
#
# $EndLog$
# 
# @(#)$RCSfile: imagegui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_ImageGUI -superclass _UIT_ImageGeneric

_UIT_ImageGUI instproc init {args} {
   eval $self next $args
}


_UIT_ImageGUI instproc display {}  {
  $self instvar _displayedOnce image img image_path text _UIrep _parent 
       
   
   if {!$_displayedOnce}   {
       set val [$self getVal]
       if {![cequal $val ""]} {
           set image $val 
       } 
      
      incr _displayedOnce
       
       global _UIT_g_wdgtVals
    
        set leaf      [lindex [split $self .] end]
        set container [$_parent set containWdgt]
        
   if {[file exists $image_path/$image]}  {

        set img [image create photo -file $image_path/$image]
        set _UIrep [labeledwidget $container.$leaf \
            -labelimage $img -labelmargin 1 \
            -labelpos w -labeljustify left] 
       } else {

         #If the image file specified does not exist - default text
         # will be presented        
         
         set _UIrep [labeledwidget $container.$leaf \
             -labeltext $text -labelmargin 1 \
             -labelpos w -labeljustify left]
       }   

       pack $_UIrep -anchor nw -padx 0 -side [$_parent packSide]
       
   }
   
   $self next

}

_UIT_ImageGUI instproc setVal {newImage} {
   $self instvar _displayedOnce image _UIrep image_path img

          $self next $newImage 
           set image $newImage 
      
       if $_displayedOnce {
             if {[file exists $image_path/$image]}  { 
            
            set img [image create photo -file $image_path/$image] 
            $_UIrep configure -labelimage $img 
	}
    }
  }
            
_UIT_ImageGUI instproc setText {newText} {
    $self instvar _displayedOnce text _UIrep image_path image
       
         $self next $newText
         set text $newText

       if $_displayedOnce {
           
            if {![file exists $image_path/$image]}  {       
                 
                 $_UIrep configure -labeltext $text
	      }
	 }
     }

