#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: imagejava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/11/09  18:50:40  Susan_Ng
# 	Code drop for Zulu bl6
#
# Revision 1.1.2.4  1999/09/29  19:38:07  Richard_Taft
# 	Must send a label, enable state and PFH text
#
# Revision 1.1.2.3  1999/08/27  19:12:53  Richard_Taft
# 	fixed syntax error
# 	[1999/08/27  19:08:32  Richard_Taft]
#
# Revision 1.1.2.2  1999/08/20  19:56:05  Joseph_Ruvel
# 	Fixed minor syntax errors
# 	[1999/08/20  18:50:37  Joseph_Ruvel]
# 
# 	Added _enabledState variable for default text
# 	[1999/08/19  15:40:32  Joseph_Ruvel]
# 
# 	Fixed setVal and display methods
# 	[1999/08/18  20:58:43  Joseph_Ruvel]
# 
# 	Changed method of setting image_path
# 	[1999/08/06  14:16:07  Joseph_Ruvel]
# 
# 	Deleted an extra semicolin
# 	[1999/08/05  20:52:26  Joseph_Ruvel]
# 
# 	Initial Image java file
# 	[1999/08/05  18:14:49  Joseph_Ruvel]
# 
# $EndLog$
# 
# @(#)$RCSfile: imagejava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 
Class _UIT_ImageJAVA -superclass _UIT_ImageGeneric

_UIT_ImageJAVA instproc init {args} {
     eval $self next $args      ;#do parents init
     $self instvar hostN endPath image_location
     set hostN [sm_GetID]
     set endPath ":2301/SYSMAN/images"
     
     #This is the location the image is kept when using as URL
     set image_location "http://$hostN$endPath"
}

_UIT_ImageJAVA instproc display {} {
    $self instvar _displayedOnce image image_path text image_location \
	_enabledState _helpTag _lbl
    
    
  
     if { ! $_displayedOnce } {
          incr _displayedOnce
           
       
       if {[file exists $image_path/$image]} { 

	   set helpTag [safeXferString $_helpTag]
	   set label [safeXferString $_lbl]

           putJava "_UIT_Image $self $label enabled $helpTag \
	       [safeXferString $image_location/$image]"
         
        } else {
	    putJava "_UIT_Label $self [safeXferString $text] $_enabledState"  
        }
    }
}


   
_UIT_ImageJAVA instproc setVal {newImage} {
    $self instvar _displayedOnce image image_path image_location 

        $self next $newImage
        set image $newImage

     if $_displayedOnce {
          
     if {[file exists $image_path/$image]} { 
               
     putJava "$self setVal [safeXferString $image_location/$image]" 
          }
      }
  }
     
_UIT_ImageJAVA instproc setText {newText} {
     $self instvar _displayedOnce text image image_path _enabledState 
            

        $self next $newText
        set text $newText

     if $_displayedOnce {        
        
      
          if {![file exists $image_path/$image]} {      
            
             putJava "_UIT_Label $self [safeXferString $text] $_enabledState" 
          }
      }
  }
    


