#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: infocur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.9  1999/04/23  15:21:50  William_Athanasiou
# 	Fixed problem of missing error messages when task fails to start
# 	[1999/04/22  18:53:43  William_Athanasiou]
#
# Revision 1.1.4.8  1999/02/03  18:45:53  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:33  Sandip_Savalia]
# 
# Revision 1.1.2.8  1998/12/03  22:32:17  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:12  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/04/07  13:34:40  William_Athanasiou
# 	fix display of info msgs
# 	[1998/04/07  13:34:13  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/04/02  19:17:42  William_Athanasiou
# 	Make info msg look like gui
# 	[1998/04/02  19:17:29  William_Athanasiou]
# 
# Revision 1.1.2.5  1998/02/26  20:20:25  William_Athanasiou
# 	Add borders to curses infomsg's
# 	[1998/02/26  20:19:51  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/12/30  19:19:34  Richard_Taft
# 	Added wait arugument to InfoMsg. Suspends execution until user closes InfoMsg window
# 	[1997/12/30  19:15:04  Richard_Taft]
# 
# Revision 1.1.2.3  1997/04/24  20:39:57  William_Athanasiou
# 	Use scrolledtext widget to display msg
# 	[1997/04/24  16:01:37  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/02/24  19:17:28  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:50  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: infocur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_InfoMsgCURSES -superclass _UIT_InfoMsgGUI

_UIT_InfoMsgCURSES instproc _fillChildsite {w} {
   $self instvar _str _severity

   .$self configure -showborder yes

   # Create window rep.
   #
   set max 40
   set nlines 0
   set lines [split $_str \n]
   foreach i $lines {
      incr nlines
      set len [clength $i]
      if {$len > $max} {
	 set max $len
      }
   }

   if {($nlines > 10) || ($len > 600)} {
      set lw [scrolledtext $w.lw -labelpos w -labelmargin 3 \
		  -visibleitems 40x10 -wrap none -vscrollmode dynamic ] 
      set wrap none
      if {$max > 40} {
	 if {$max > 70} {
	    set max 70
	    set wrap word
	 }
	 $lw configure -hscrollmode static \
	     -visibleitems ${max}x10 -wrap $wrap
      }
      $lw insert 0.0 $_str
      $lw configure -state disabled 
   } else {
      set lw [_UIT_Labeledwidget $w.lw -labelpos w -labelmargin 3]
      set cs [label [$lw childsite].text -text $_str -wraplength 6i \
		  -justify l]
      pack $cs
      pack $lw -pady 1
   }
   pack $lw -expand 1 -fill both

   switch -exact -- $_severity {
      error {
	 $lw configure -labeltext E
      }
      warning {
	 $lw configure -labeltext W
      }
      info -
      default {
	 $lw configure -labeltext !
      }
   }
}

