#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: infogen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.11.1  2001/09/24  17:33:21  Richard_Taft
# 	Fix for QAR 85112
#
# Revision 1.1.7.1  2000/09/06  19:34:23  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.9  2000/04/18  14:12:48  Todd_Moyer
# 	Added getActCmd, getState, getWin for scripting.
#
# Revision 1.1.2.8  1998/10/08  18:40:37  Paul_Henderson
# 	changed the ok button's label to OK, and the dialog's title to
# 	Information:.
# 	[1998/10/08  18:40:14  Paul_Henderson]
#
# Revision 1.1.2.7  1998/09/04  12:36:19  Fred_Cassirer
# 	Added code in info message display to force an acknowledge parent so
# 	if the info message is the first window that suitlet displays the
# 	parent process isn't left hanging waiting for the window to complete.
# 	[1998/09/04  12:35:54  Fred_Cassirer]
# 
# Revision 1.1.2.6  1998/04/20  14:51:17  Richard_Taft
# 	Can use the tokens "wait" and "nowait" in addition to the digits
# 	zero and one for the wait argument.
# 	[1998/04/20  14:50:37  Richard_Taft]
# 
# Revision 1.1.2.5  1998/03/02  16:49:54  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  16:46:40  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/12/30  19:19:36  Richard_Taft
# 	Added wait arugument to InfoMsg. Suspends execution until user closes InfoMsg window
# 	[1997/12/30  19:15:08  Richard_Taft]
# 
# Revision 1.1.2.3  1997/02/24  19:17:29  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:52  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/02/18  14:23:07  William_Athanasiou
# 	appended _UIT_ to name of class
# 	[1997/02/18  14:22:18  William_Athanasiou]
# 
# 	Initial version
# 	[1997/02/18  14:19:36  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: infogen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 


#@ Display a msg for the user.  It will just have one button to dismiss the
#@ msg once the user reads it.  For anything more complicated, create a window.
#@ The constructor takes these parameters, all of which can be defaulted:
#@   serverity    determines icon    - one of 'error' (default) 'warning' 'info'
#@   msg str      i18n message to display  - defaults to infoMsg_str in msg cat
#@   title        window title             - defaults to infoMsg_lbl in msg cat
#@   wait         block until user clicks OK?  - 0 (default) or 1

Class _UIT_InfoMsgGeneric


# Need this switch and proc to shutoff "wait" feature for when
#   running app on auto pilot (as a pre-recorded script).

_UIT_InfoMsgGeneric  set   _waitAllowed  1

_UIT_InfoMsgGeneric proc isWaitAllowed {yesNo} {
    _UIT_InfoMsgGeneric  set   _waitAllowed  $yesNo
}


_UIT_InfoMsgGeneric instproc init {{severity {}} {str {}} \
				       {winTitle {}} {wait 0}} {

   global _UIT_g_main
   $self instvar _winTitle _str _severity _okLabel _wait

   switch $severity {
      error -
      info -
      warning {
	 set _severity $severity
      }
      default {
	 set _severity error
      }
   }

   set _okLabel [$_UIT_g_main catget infoMsg ok]
   if {$_okLabel == "infoMsg"} {
      set _okLabel OK
   }

   set _str $str
   if {$_str == {}} {
      set _str [$_UIT_g_main catget infoMsg str]
      if {[cequal $_str "infoMsg"]} {
	 set _str "Error"
      }
   }
   
   set _winTitle $winTitle
   if {$_winTitle == {}} {
      set _winTitle [$_UIT_g_main catget infoMsg lbl]
      if {[cequal $_winTitle "infoMsg"]} {
	 set _winTitle "Information: $_UIT_g_main"
      }
   }

   # If switch turned off, disallow waiting.  This is
   #   an override for when apps are being replayed
   #   from a recorded script.
   if { ! [_UIT_InfoMsgGeneric set _waitAllowed]} {
       set wait 0
   }


   switch $wait {
       wait -
       1	{ set _wait 1 }

       nowait -
       0 -
       default	{ set _wait 0 }
   }

   $_UIT_g_main acknowledgeParent
   $self display
}


# --------------------------------------------------------
#@ Display the msg on the screen.

_UIT_InfoMsgGeneric instproc display {} {
   global _UIT_g_main
   $_UIT_g_main pushDisplayStack $self

   # For scripting API: during playback, will hide the
   #  InfoMsg (after a pause, perhaps)
   $_UIT_g_main scriptInfoMsgHandler $self
}


# --------------------------------------------------------
#@ Return the command that will simulate the OK button's being pushed.
#@   Needed to support the scripting API.

_UIT_InfoMsgGeneric instproc getActCmd {} {
   return "$self _okCommand"
}


# --------------------------------------------------------
#@ This window doesn't have any state, so this is a no-op.
#@   Needed to support the scripting API.

_UIT_InfoMsgGeneric instproc getState {} {
   return ""
}


# --------------------------------------------------------
#@ This object is the window, so just returns itself.
#@   Needed to support the scripting API.

_UIT_InfoMsgGeneric instproc getWin {} {
   return "$self"
}


# --------------------------------------------------------
#@ Return the severity of this InfoMsg
#@   Needed to support the scripting API.

_UIT_InfoMsgGeneric instproc severity {} {
    return [$self set _severity]
}

# --------------------------------------------------------
#@ Return the message string
#@   Needed to support the scripting API.

_UIT_InfoMsgGeneric instproc messageText {} {
    return [$self set _str]
}

# ================ private methods ======================

#@ The user has read the msg and clicked OK.  Delete it.

_UIT_InfoMsgGeneric instproc _okCommand {} {
   global _UIT_g_main

   $_UIT_g_main popDisplayStack $self
   after idle "$self destroy"
}

# ===================================================

