#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: infogui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/09/06  19:34:23  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.18  2000/04/18  14:12:50  Todd_Moyer
# 	Added destroy method.
#
# Revision 1.1.2.17  1999/02/23  18:02:43  William_Athanasiou
# 	set minimum size of infogui window
# 	[1999/02/23  17:46:04  William_Athanasiou]
#
# Revision 1.1.2.16  1999/01/22  19:37:12  William_Athanasiou
# 	Add still waiting window if suitlet takes a long time to start
# 	[1999/01/22  19:36:42  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/12/04  19:19:27  William_Athanasiou
# 	add missing methods
# 	[1998/12/04  19:19:10  William_Athanasiou]
# 
# Revision 1.1.2.14  1998/12/03  22:32:18  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:14  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/08/17  18:38:15  William_Athanasiou
# 	Add update idletasks after activate to allow focus to work correctly
# 	[1998/08/17  18:37:17  William_Athanasiou]
# 
# Revision 1.1.2.12  1998/08/11  16:41:31  William_Athanasiou
# 	Set focus to OK button
# 	[1998/08/11  16:34:58  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/04/02  17:11:01  William_Athanasiou
# 	Preserve format as much as possible in message in infogui
# 	[1998/04/02  17:10:28  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/03/02  16:49:55  Todd_Moyer
# 	Cleaned up _winStack API.
# 	[1998/03/02  16:46:03  Todd_Moyer]
# 
# Revision 1.1.2.9  1998/02/26  20:20:26  William_Athanasiou
# 	Add borders to curses infomsg's
# 	[1998/02/26  20:19:53  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/12/30  19:19:38  Richard_Taft
# 	Added wait arugument to InfoMsg. Suspends execution until user closes InfoMsg window
# 	[1997/12/30  19:15:14  Richard_Taft]
# 
# Revision 1.1.2.7  1997/08/21  14:19:05  William_Athanasiou
# 	Allow info msgs to come up from initCBs
# 	[1997/08/21  14:17:49  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/04/24  20:39:58  William_Athanasiou
# 	Use message widget to display infomessage
# 	[1997/04/24  16:01:59  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/03/21  15:55:27  William_Athanasiou
# 	Remove help widget from infoMsg windows
# 	[1997/03/21  15:47:31  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/02/24  20:18:20  William_Athanasiou
# 	Don't create images for window if not doing GUI
# 	[1997/02/24  20:17:40  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/02/24  19:53:21  William_Athanasiou
# 	Put bitmap images in file.
# 	[1997/02/24  19:52:56  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/02/24  19:17:30  William_Athanasiou
# 	Added infomsg class; and used dialogshell for suit windows
# 	[1997/02/24  19:10:54  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: infogui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_InfoMsgGUI -superclass _UIT_InfoMsgGeneric


# ----------------------------------------

proc _UIT_needbitmaps {} {}
uplevel #0 { 
   if {[$_UIT_g_main set ui] == "GUI"} {
      image create bitmap _UIT_ErrorImage -data {#define error_width 20
      #define error_height 20
      static char error_bits[] = {
	 0x00, 0x00, 0x00, 0xc0, 0x0f, 0x00, 0xf0, 0x3a, 0x00, 0x58, 
	 0x55, 0x00, 0x2c, 0xa0, 0x00, 0x56, 0x40, 0x01, 0xaa, 0x80, 
	 0x02, 0x46, 0x81, 0x01, 0x8a, 0x82, 0x02, 0x06, 0x85, 0x01, 
	 0x0a, 0x8a, 0x02, 0x06, 0x94, 0x01, 0x0a, 0xe8, 0x02, 0x14, 
	 0x50, 0x01, 0x28, 0xb0, 0x00, 0xd0, 0x5f, 0x00, 0xa0, 0x2a, 
	 0x00, 0x40, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; 
      }
      
      image create bitmap _UIT_WarningImage -data {#define warn_width 9
      #define warn_height 22
      static char warn_bits[] = {
	 0x00, 0x00, 0x18, 0x00, 0x2c, 0x00, 0x56, 0x00, 0x2a, 0x00, 
	 0x56, 0x00, 0x2a, 0x00, 0x56, 0x00, 0x2c, 0x00, 0x14, 0x00, 
         0x2c, 0x00, 0x14, 0x00, 0x2c, 0x00, 0x14, 0x00, 0x00, 0x00, 
	 0x00, 0x00, 0x3c, 0x00, 0x14, 0x00, 0x2c, 0x00, 0x14, 0x00, 
	 0x00, 0x00, 0x00, 0x00};
      }
      
      image create bitmap _UIT_InformationImage -data {#define info_width 11
      #define info_height 24
      static char info_bits[] = {
	 0x00, 0x00, 0x78, 0x00, 0x54, 0x00, 0x2c, 0x00, 0x54, 0x00, 
	 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x2a, 0x00, 
	 0x5c, 0x00, 0x28, 0x00, 0x58, 0x00, 0x28, 0x00, 0x58, 0x00, 
	 0x28, 0x00, 0x58, 0x00, 0x28, 0x00, 0x58, 0x00, 0xae, 0x01, 
	 0x56, 0x01, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00};
      }
   }
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc destroy {} {

    # Destroy the widget if it exists.
    # Only created when displayed, so it may not exist.
   catch "destroy .$self"
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc display {} {
   if [winfo exists .$self] {return}

   $self instvar _okLabel _winTitle
   _UIT_Dialogshell .$self -separator off
   .$self configure -title $_winTitle
   .$self addTkButton ok -text $_okLabel -command "$self _okCommand"
   .$self default ok

   $self _fillChildsite [.$self childsite]

   global _UIT_g_main
   $self _showWindow [$_UIT_g_main getTopWin]

   $self next

   $self instvar _wait
   if {$_wait} {
       $self _waitForUser
   }
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc _showWindow {parent} {
   if { ! [cequal $parent $self] && ! [cequal $parent {}]} {
      wm group .$self .$parent
      wm transient .$self .$parent
      .$self center .$parent
   } else {
      wm group .$self .
      wm transient .$self
      .$self center
   }
   
   .$self activate 
   update idletasks
   #
   # Set the minimum size for the window.  At this point, the window's
   # contents have been established, and the req{width,height} are accurate
   #
   wm minsize .$self [winfo reqwidth .$self] [winfo reqheight .$self]
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc _waitForUser {} {
   tkwait window .$self
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc _fillChildsite {w} {
   $self instvar _str _severity 

   # Create window rep.
   #
   set nlines 0
   set max 40
   set lines [split $_str \n]
   foreach i $lines {
      incr nlines
      set len [clength $i]
      if {$len > $max} {
	 set max $len
      }
   }

    if {$nlines > 10} {
	set lw [scrolledtext $w.lw -labelpos w -labelmargin 3 \
		    -visibleitems 40x10 -wrap none \
		    -vscrollmode dynamic -relief ridge] 
	if {$max > 40} {
	    if {$max > 70} {
		set max 70
	    }
	    $lw configure -hscrollmode static -visibleitems ${max}x10
	}
	$lw insert 0.0 $_str
	$lw configure -state disabled 
    } else {
	set lw [_UIT_Labeledwidget $w.lw -labelpos w -labelmargin 3]
	set cs [label [$lw childsite].text -text $_str -wraplength 6i \
		    -justify l]
	pack $cs
	pack $lw -pady 5
    }

   pack $lw -expand 1 -fill both
   switch -exact -- $_severity {
      error {
	 $lw config -labelimage _UIT_ErrorImage
      }
      warning {
	 $lw config -labelimage _UIT_WarningImage
      }
      info -
      default {
	 $lw config -labelimage _UIT_InformationImage
      }
   }

}


# ----------------------------------------
#@ respond to OK button invocation by closing window and commiting suicide.

_UIT_InfoMsgGUI instproc _okCommand {} {

   .$self deactivate
   $self next
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc _makeBusy {} {
   .$self configure -busy 1
}


# ----------------------------------------

_UIT_InfoMsgGUI instproc _makeNotBusy {} {
   .$self configure -busy 0
}

# ========================================
