# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: labelgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:49  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.19  1999/10/13  20:12:50  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
# 	[1999/10/12  14:36:15  Richard_Taft]
#
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
# 	[1999/10/11  20:03:35  Richard_Taft]
#
# Revision 1.1.2.18  1998/10/09  13:08:07  Richard_Taft
# 	State must be disabled or normal
# 	[1998/10/09  13:07:36  Richard_Taft]
#
# Revision 1.1.2.17  1998/03/16  20:09:14  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:42  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/02/26  21:35:38  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:29:25  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/02/11  18:44:02  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:37  William_Athanasiou]
# 
# Revision 1.1.2.14  1998/01/05  19:30:26  William_Athanasiou
# 	Left justify multi-line labels
# 	[1998/01/05  19:28:35  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/12/22  18:44:05  William_Athanasiou
# 	Fixed use of _lbl before instvar
# 	[1997/12/22  18:43:44  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/12/08  18:52:56  William_Athanasiou
# 	fix runtime update of label
# 	[1997/12/08  18:51:24  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/08/18  17:11:12  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:32  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/05/12  19:30:39  Deepa_Bachu
# 	Made changes to allow setting of run-time label.
# 	[1997/05/12  19:24:14  Deepa_Bachu]
# 
# Revision 1.1.2.9  1997/03/31  18:49:32  William_Athanasiou
# 	add, but comment out, ability to setVal label
# 	[1997/03/31  18:42:53  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/03/28  16:46:42  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:14  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/03/13  17:45:05  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:50  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/03/07  19:08:07  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:38  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/01/16  20:37:39  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:13  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/01/16  14:15:33  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:45  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/10/01  13:31:38  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:29:02  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  19:57:58  William_Athanasiou
# 	initial version of implementation
# 	[1996/09/24  19:55:36  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: labelgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 
Class _UIT_LabelGUI -superclass _UIT_LabelGeneric

_UIT_LabelGUI instproc init {args} {
   eval $self next $args
}

_UIT_LabelGUI instproc display {} {
   $self instvar _displayedOnce _lbl
   
   if {!$_displayedOnce} {
      set val [$self getVal]
      if {![cequal $val ""]} {
	 set _lbl $val
      }
      incr _displayedOnce
      
      global _UIT_g_wdgtVals
      $self instvar _UIrep _parent _isAlignable _enabledState
      
      set leaf      [lindex [split $self .] end]
      set container [$_parent set containWdgt]
      
      set _UIrep [labeledwidget $container.$leaf \
		      -labeltext $_lbl -labelmargin 1 \
		      -labelpos w -labeljustify left]
      #      set _isAlignable $_UIrep
      #      pack [label [$_UIrep childsite].lbl -textvariable 
      #                     _UIT_g_wdgtVals($self)] -padx 0 -pady 0
      
      pack $_UIrep -anchor nw -padx 0 -side [$_parent packSide]
      $self _setState $_enabledState
   }
   
   $self next
}

_UIT_LabelGUI instproc _setState {val} {
    # label state is "disabled" or "normal"
    if { ![cequal $val disabled] } {
	set val normal
    }
    [$self set _UIrep] configure -labelstate $val
}

