# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listcur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.11.2  2001/01/11  15:53:41  William_Athanasiou
# 	Fix multicolumn listbox issues for qar 78664
#
# Revision 1.1.2.21  2001/01/08  16:51:49  William_Athanasiou
# 	Update curses mclist implementation
#
# Revision 1.1.2.20  2000/05/16  19:07:29  Richard_Taft
# 	Moved initial column sort from _makeLstBox to display (see
# 	listgui.tcl).
# 	Removed _setSelectMode since it was misnamed as a _UIT_ListGUI
# 	instproc and since it duplicated the code for that same function in
# 	listgui.tcl.
#
# Revision 1.1.2.19  2000/01/21  19:22:16  Richard_Taft
# 	Multi-column lists in curses mode!"	Sort ascending the first time a column is clicked
# 	[2000/01/21  19:19:33  Richard_Taft]
#
# 	Fix multicolumn list in curses mode
# 	[2000/01/21  18:57:36  Richard_Taft]
#
# Revision 1.1.2.18  1998/10/05  14:16:55  Richard_Taft
# 	Multiple selection should use selectMode "extended" for GUI
# 	but "multiple" for CUI.  Extended is more Windows-like, but
# 	it doesn't work under curses.
# 	[1998/10/05  14:10:43  Richard_Taft]
#
# Revision 1.1.2.17  1998/10/01  21:29:37  William_Athanasiou
# 	Fix mode of selection for listboxes
# 	[1998/10/01  21:29:08  William_Athanasiou]
# 
# Revision 1.1.2.16  1998/06/23  19:22:36  William_Athanasiou
# 	Use single instead of browse mode
# 	[1998/06/23  19:22:00  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/04/21  20:03:16  William_Athanasiou
# 	Add vertical scrollbar
# 	[1998/04/21  20:01:00  William_Athanasiou]
# 
# Revision 1.1.2.14  1998/04/16  14:58:36  William_Athanasiou
# 	Fix inital set of active index
# 	[1998/04/16  14:35:57  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/04/08  20:47:10  William_Athanasiou
# 	Set selectmode to browse instead of single
# 	[1998/04/08  20:45:55  William_Athanasiou]
# 
# Revision 1.1.2.12  1998/02/26  21:35:39  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:29:35  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/04/24  20:39:59  William_Athanasiou
# 	No changes
# 	[1997/04/24  16:02:34  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/31  18:49:32  William_Athanasiou
# 	no changes made
# 	[1997/03/31  18:33:16  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/28  19:03:12  William_Athanasiou
# 	Renamed setselection to setSelection
# 	[1997/03/28  19:02:47  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/01/16  20:37:46  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:16  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/16  14:15:36  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:53  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/11/05  16:48:57  William_Athanasiou
# 	set cursor to first list element on initial display
# 	[1996/11/05  16:47:34  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/11/04  17:26:17  William_Athanasiou
# 	added comments
# 	[1996/11/04  17:22:14  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/10/29  15:01:44  William_Athanasiou
# 	Completed List widget functionality
# 	[1996/10/29  14:56:05  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/10/24  18:42:59  William_Athanasiou
# 	added trace of widget global
# 	[1996/10/24  18:36:13  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/10/16  14:35:05  William_Athanasiou
# 	first pass at listbox
# 	[1996/10/16  14:25:26  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: listcur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 


Class _UIT_ListCURSES -superclass _UIT_ListGUI

_UIT_ListCURSES instproc _makeLstBox {wdgt lbl} {
   global _UIT_DisplayAttr _UIT_g_main
   $self instvar headings cHeadings

   # If headings are specified in genUID, then this is
   # a multi-column listbox
   if {[info exists headings] == 0} {
       # Create a regular listbox
       return [scrolledlistbox $wdgt -labeltext $lbl \
		   -selectmode browse -vscrollmode dynamic]
   } else {
       # Create a multi-column listbox

       # Get the headings from the catalog and compute length if necessary
       set cHeadings {}
       set i 0
       foreach h $headings {
	   if { [llength $h] != 1 } {
	       # Heading and length are given
	       set hcat [lindex $h 0]
	       set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
	       set hlen [lindex $h 1]
	   } else {
	       # Only a heading given => length is label length + 2
	       set hcat $h
	       set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
	       set hlen [expr [string length $hlabel] + 2]
	   }
	   lappend cHeadings [list $hcat $hlabel $hlen]

	   # create a compare routine for each column if the user
	   # hasn't created one already
	   if {[$self info procs ${hcat}CompareCB] == {}} {
	       eval [subst  -nocommand {
		   $self proc ${hcat}CompareCB {a b} {
		       set aList [lindex \$a 0]
		       set bList [lindex \$b 0]

		       string compare [lindex \$aList $i] \
			   [lindex \$bList $i]
		   }
	       } ]
	   }

           incr i
       }

       set lst [_UIT_Mclistbox $wdgt \
		    -labeltext $lbl \
		    -selectmode single \
		    -vscrollmode dynamic \
		    -hscrollmode dynamic \
		    -headings $cHeadings \
		   ]

       # Set up column sort
       $lst configure -sortcommand "$self _columnSort"

       return $lst
   }
}

# ----------------------------------------------------
#@ This method is called to set the select mode to
#@ either single or multiple.
#@ We use TCL's extended mode for multiple selections
#@ and browse mode for single selections so the key
#@ bindings are like MS-Windows

_UIT_ListCURSES instproc _setSelectMode {mode} {
# ----------------------------------------------------

    $self instvar _lstbox

    switch $mode {
       browse -
       single { $_lstbox configure -selectmode browse }
       extended -
       multiple { $_lstbox configure -selectmode multiple }
    }
}

_UIT_ListCURSES instproc resize {columnname val} {
   #
   # Not implemented yet.
}
