# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.11.2  2000/10/30  20:51:08  Peter_Wolfe
# 	Code drop for yankee bl3
#
# Revision 1.1.2.50  2000/10/19  18:08:22  Todd_Moyer
# 	Fixed undefed var ('keys') in error code.
#
# Revision 1.1.2.49  2000/06/13  19:42:52  Ramnath_Ravindran
# 	Fixed multiple selection loss after refresh
# 	[2000/06/13  19:42:00  Ramnath_Ravindran]
#
# 	Fixed problem with selections being lost after refresh
# 	[2000/06/08  19:13:52  Ramnath_Ravindran]
#
# Revision 1.1.2.48  2000/05/08  15:22:39  Richard_Taft
# 	Synching shared sandbox and zuludx
#
# Revision 1.1.2.47  2000/05/04  19:34:53  Jie_Luo
# 	Fix a problem in _columnSort, restore the selections after sorting
# 	Fix a problem in _columnSort, restore the selections after sorting
# 	[2000/03/17  20:53:33;  Jie_Luo;]
#
# Revision 1.1.8.5  2000/05/02  17:59:34  Jie_Luo
# 	Changes for multicolumn list and for tabbed widget
#
# Revision 1.1.9.2  2000/03/17  20:53:33  Jie_Luo
# 	Fix a problem in _columnSort, restore the selections after sorting
#
# Revision 1.1.9.1  2000/03/17  20:05:27  Jie_Luo
# *** Initial Branch Revision ***
#
# Revision 1.1.2.46  2000/02/29  19:51:24  Todd_Moyer
# 	Replaced \t in default formatDisplayStrCB.
#
# Revision 1.1.2.45  2000/01/21  19:21:53  Richard_Taft
# 	Fix sorting"	Sort ascending the first time a column is clicked
#
# Revision 1.1.2.44  2000/01/14  15:59:21  Richard_Taft
# 	Added code supporting multicolumn listboxes
#
# Revision 1.1.2.43  1999/07/13  17:17:44  William_Athanasiou
# 	Fix problem of doubleClkCB causing coredump in java
# 	[1999/07/13  13:00:44  William_Athanasiou]
#
# Revision 1.1.2.42  1998/06/17  16:30:47  William_Athanasiou
# 	fixed problem with passing selected items as a list rather than individual args
# 	[1998/06/17  16:26:59  William_Athanasiou]
# 
# Revision 1.1.2.41  1998/04/30  21:44:05  Todd_Moyer
# 	Restore selection after adding or modifying.
# 	[1998/04/30  21:42:28  Todd_Moyer]
# 
# Revision 1.1.2.40  1998/03/12  19:37:07  Todd_Moyer
# 	Fixed problems in add.
# 	[1998/03/12  19:35:57  Todd_Moyer]
# 
# Revision 1.1.2.39  1998/01/29  21:49:52  Todd_Moyer
# 	Commented out diagnostic statements.
# 	[1998/01/29  21:47:40  Todd_Moyer]
# 
# Revision 1.1.2.38  1998/01/29  20:02:48  Todd_Moyer
# 	Replaced keyed lists with regular lists for huge
# 	  performance improvement.  Added optimize flag to
# 	  reads to avoid unnecessary re-reading.
# 	[1998/01/29  19:49:36  Todd_Moyer]
# 
# Revision 1.1.2.37  1997/09/30  12:56:57  William_Athanasiou
# 	Fixed typo getDspStrs ==> getDspStr
# 	[1997/09/30  12:54:47  William_Athanasiou]
# 
# Revision 1.1.2.36  1997/08/19  18:33:20  Todd_Moyer
# 	Fixed bug in status when deleting multiple records.
# 	[1997/08/19  18:01:00  Todd_Moyer]
# 
# Revision 1.1.2.35  1997/06/09  17:45:30  Richard_Taft
# 	Just added a space to formatDisplayCB
# 	[1997/06/09  14:52:56  Richard_Taft]
# 
# Revision 1.1.2.34  1997/05/20  19:24:20  Todd_Moyer
# 	Fixed bug in workOn when a numeric index given.
# 	[1997/05/20  19:21:10  Todd_Moyer]
# 
# Revision 1.1.2.33  1997/05/15  18:59:08  Todd_Moyer
# 	Use setListItem method to deal with dots (.) in display strings.
# 	[1997/05/15  18:58:19  Todd_Moyer]
# 
# Revision 1.1.2.32  1997/05/09  20:40:39  Todd_Moyer
# 	Split off the functionaly for manually manipulating lists into listsmp
# 	  from which this class now inherits.  This class now handles the stuff
# 	  for automating teh connection between data and the list.
# 	[1997/05/09  19:08:43  Todd_Moyer]
# 
# Revision 1.1.2.31  1997/04/25  18:25:45  Todd_Moyer
# 	Bug fix in the parseDisplayStrCB method.
# 	[1997/04/25  18:19:54  Todd_Moyer]
# 
# Revision 1.1.2.30  1997/04/24  20:40:01  William_Athanasiou
# 	Added singleClk and doubleClk options for listboxes
# 	[1997/04/24  16:03:14  William_Athanasiou]
# 
# Revision 1.1.2.29  1997/04/09  21:37:39  William_Athanasiou
# 	Fixed expression problem in insertDspStr
# 	[1997/04/09  21:34:08  William_Athanasiou]
# 
# Revision 1.1.2.28  1997/03/28  16:46:43  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:16  William_Athanasiou]
# 
# Revision 1.1.2.27  1997/03/26  19:56:05  Todd_Moyer
# 	Changed setVal and setValSorted to take one list instead of a set of values.
# 	Changed add, addAt, modify and delete to return a status.
# 	Add and addAt now take an ID ptr to receive the ID of the new record.
# 	[1997/03/26  16:53:16  Todd_Moyer]
# 
# Revision 1.1.2.26  1997/03/03  16:48:08  William_Athanasiou
# 	set default value of needSelection to {modify delete}
# 	[1997/03/03  16:47:53  William_Athanasiou]
# 
# Revision 1.1.2.25  1997/03/03  16:39:43  William_Athanasiou
# 	buttons in needSelection now checked against valid listbox buttons
# 	[1997/03/03  16:39:22  William_Athanasiou]
# 
# Revision 1.1.2.24  1997/02/17  21:38:56  William_Athanasiou
# 	Fixed problem in setVal and setValSorted when an empty list
# 	is passed to these routines.  The argument list was initially
# 	args which turned {} into {{}} which is not a null list but a list
# 	of one element which is null.  The Null list is now checked for
# 	specifically.
# 	[1997/02/17  21:37:34  William_Athanasiou]
# 
# Revision 1.1.2.23  1997/01/27  16:52:32  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.21 **
# 		** Merge revision:	1.1.2.22 **
# 	 	** End **
# 	Always check return value from findRec calls and give more
# 	informative msg when not found.
# 	[1997/01/23  16:28:56  Todd_Moyer]
# 
# Revision 1.1.2.22  1997/01/23  19:28:22  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:11  William_Athanasiou]
# 
# Revision 1.1.2.21  1997/01/22  22:41:40  Todd_Moyer
# 	Minor bug fix.
# 	[1997/01/22  22:29:16  Todd_Moyer]
# 
# Revision 1.1.2.20  1997/01/21  13:51:51  William_Athanasiou
# 	Changed names of curselection, getcurselection and selecteditemcount
# 	[1997/01/21  13:43:04  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/01/16  14:15:38  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:56  William_Athanasiou]
# 
# Revision 1.1.2.18  1996/12/23  16:45:51  William_Athanasiou
# 	Fixed problem with delete for multi-select
# 	[1996/12/23  16:44:49  William_Athanasiou]
# 
# Revision 1.1.2.17  1996/12/20  19:36:26  William_Athanasiou
# 	workOn: added ability to workon a specific display line.
# 	[1996/12/20  19:35:25  William_Athanasiou]
# 
# Revision 1.1.2.16  1996/12/12  16:48:44  William_Athanasiou
# 	added read method, and removed 'self next' from display to prevent 'read' method call
# 	[1996/12/12  16:36:32  William_Athanasiou]
# 
# Revision 1.1.2.15  1996/12/04  21:24:18  William_Athanasiou
# 	workOn method needed to set currentDspId
# 	[1996/12/04  21:23:54  William_Athanasiou]
# 
# Revision 1.1.2.14  1996/12/02  23:00:51  Todd_Moyer
# 	Cleaned up several bugs in add and modify.
# 	[1996/12/02  22:57:07  Todd_Moyer]
# 
# Revision 1.1.2.13  1996/12/02  14:31:37  William_Athanasiou
# 	Sped up getDspStr function
# 	[1996/12/02  14:30:44  William_Athanasiou]
# 
# Revision 1.1.2.12  1996/11/27  23:22:45  Todd_Moyer
# 	Use _dataNode instead of _assoRsrc.
# 	Created a deleteSpecified to do what delete did and changed
# 	  delete to delete the selected items.
# 	Changed getDspStr to return a nonlist if last not specified.
# 	  A list of one element was being returned.
# 	[1996/11/27  23:12:36  Todd_Moyer]
# 
# Revision 1.1.2.11  1996/11/22  21:59:09  William_Athanasiou
# 	Added resource link functionality
# 	[1996/11/22  21:58:31  William_Athanasiou]
# 
# Revision 1.1.2.10  1996/11/14  19:54:59  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.8 **
# 		** Merge revision:	1.1.2.9 **
# 	 	** End **
# 	Added setselection method to allow listbox selections
# 	   to be set programatticaly.
# 	Started fleshing out routines to connect resources and
# 	   records to the listboxes.
# 	[1996/11/14  19:31:32  William_Athanasiou]
# 
# Revision 1.1.2.9  1996/11/12  16:31:15  Todd_Moyer
# 	Added an assoRec method.
# 	[1996/11/12  14:40:40  Todd_Moyer]
# 
# Revision 1.1.2.8  1996/11/11  15:31:02  Todd_Moyer
# 	Added methods (but not their implementations) needed to tie a list
# 	to data.
# 	The goal is to add enough functionality to the super widgets so
# 	that developers need only associate them with data and the changes
# 	to the widget data will automatically be reflected in the actual data.
# 	[1996/11/11  14:40:13  Todd_Moyer]
# 
# Revision 1.1.2.7  1996/11/05  16:48:56  William_Athanasiou
# 	sped up insert instproc
# 	[1996/11/05  16:46:22  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/11/04  17:26:14  William_Athanasiou
# 	added comments
# 	[1996/11/04  17:22:17  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/10/29  17:45:51  William_Athanasiou
# 	setup autoSort to use sortCB instance proc
# 	[1996/10/29  17:45:13  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/10/29  15:01:45  William_Athanasiou
# 	Completed List widget functionality
# 	[1996/10/29  14:56:07  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/10/24  18:43:07  William_Athanasiou
# 	Added new functions to perform listbox actions;
# 	such as sorting, getting indexes, and manipulating
# 	the items in the 'listbox'
# 	[1996/10/24  18:38:08  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/10/16  14:35:07  William_Athanasiou
# 	first pass at listbox
# 	[1996/10/16  14:25:29  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: listgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

#@ This class builds an association with table records on top of
#@   a simple list.  It can optionally filter and format display strings.

Class _UIT_ListGeneric -superclass _UIT_ListSimple

_UIT_ListGeneric instproc init {args} {
   $self instvar assoWidgets _filtered

   #set defaults
   set assoWidgets ""
   # set filtered to uninit state because cann't yet check for callback
   set _filtered  -1

   eval {$self next} $args

   $self instvar headings autoSort
   if {[info exists headings]} {
       # we have a multi-column list widget
       set autoSort 0			;# turn off autoSort
   }
}



#################################################################
# The following section of methods are for lists with an
# associated data resource (table or group).
#################################################################

#@ Write the data from any associated widgets to the resource record.
#@ Add the record to the resource, and then format the new display 
#@ string and add it to the listbox.
#@ If recIdx specified, the new rec will be added just before the record at that
#@ position (first rec if zero).  If not specified, add at end.

_UIT_ListGeneric instproc add { {recIdx end} } {
   $self instvar assoWidgets _dataNode _dspStrUdPairs _filtered

   if {[cequal _dataNode ""]} {
      set msg    "_UIT_ListGeneric::add  List $self has no associated "
      append msg "resource."
      error $msg
   }

   # write data to record
   foreach w $assoWidgets {
       $w write
   }

   # write record to table
   if {$recIdx == "end"} {
       set stat [$_dataNode add newId]
   } else {
       if {$recIdx == "first"} {
	   set recIdx 0
       }
       set stat [$_dataNode addAt newId $recIdx]
   }

   # quit if there was a problem
   if {! [cequal $stat ""]} {
       return $stat
   }
      
   # Update the display and restore the selection.
   # If filtered, check that values passes (return non-zero).
   # It may seem odd to worry about selection for an add, but one
   # might be adding relative to a certain position.
   $_dataNode getRec $newId data
   set items ""
   if {! $_filtered || [$self filterCB data]} {
       $self setListItem items [$self formatDisplayStrCB data] $newId
       $self _rememberState
       $self insertDspStr $recIdx $items
       $self _restoreState
   }

   return ""
}


#################################################################
#@ Associate these widgets with the list so they can provide access to
#@ the individual record attributes.

_UIT_ListGeneric instproc assoWidgets {wdgtList} {
   $self instvar _dataNode assoWidgets
   
   set assoWidgets $wdgtList
   if {! [cequal $_dataNode ""]} {
      set buf [$_dataNode getRecBuf]
      foreach w $assoWidgets {
	 $w assoRec $buf
      }
   }
}


#################################################################
#@ Delete selected record(s) from the listbox and the associated
#@ resource.
#@ Return the status: "" if OK or a list of error codes if not.

_UIT_ListGeneric instproc delete {} {
   $self instvar _dataNode
   
   if {[cequal _dataNode ""]} {
      error "_UIT_ListGeneric::delete  List $self has no associated resource."
   }

   # delete data
   # user data is table record ID
   foreach id [$self getSelUserData] {
       set stat [$_dataNode delete $id]
       # quit if there was a problem
       if {! [cequal $stat ""]} {
	   return $stat
       }
   }

   # delete display strings
   $self deleteCurSelection
   return ""
}


#################################################################
#@ Delete record(s) from the listbox and the associated
#@ resource.

_UIT_ListGeneric instproc deleteSpecified {first {last {}} } {
   $self instvar _dataNode

   if {[cequal _dataNode ""]} {
       set    msg "_UIT_ListGeneric::deleteSpecified  List $self has no "
       append msg "associated resource."
       error $msg
   }

   foreach item [$self getDspStr $first $last] {
       set id [$self getItemUserData $item]
       set stat [$_dataNode delete $id]
       # quit if there was a problem
       if {! [cequal $stat ""]} {
	   return $stat
       }
   }
   $self deleteDspStr $first $last
   return ""
}


#################################################################
#@ Default display string format.
#@ Can be overridden by a user to produce a specific display

_UIT_ListGeneric instproc formatDisplayStrCB {arr} {
   upvar 1 $arr data

   $self instvar headings
   if {[info exists headings] == 0} {
       # A regular list box requires a single string.
       #   Avoid tabs because they display as "\t".
       set str ""
       foreach i [array names data] {
	   append str [format "%-16s" $data($i)]
       }
   } else {

       foreach i $headings {
	   # {heading} or {heading width} ?
	   if {[llength $i] > 1} {
	       set i [lindex $i 0]
	   }

	   # A multicolumn list requires a list of column data
	   lappend str $data($i)
       }
   }

   return $str
}


#################################################################
#@ Write the data from any associated widgets to the select record,
#@ and then modify the record in the associated resource.
#@ Update the display strings for the modified record using the user-supplied
#@ format callback.  Re-sort the display strings if approriate.

_UIT_ListGeneric instproc modify {} {
   $self instvar assoWidgets _dataNode _currentDspId _filtered

   if {[cequal _dataNode ""]} {
      set msg    "_UIT_ListGeneric::modify  List $self has no associated "
      append msg "resource."
      error $msg
   }
   
   # write data to record
   foreach w $assoWidgets { $w write }

   # write record to table.  Quit if there was a problem
   set stat [$_dataNode modify]
   if {! [cequal $stat ""]} {
       return $stat
   }

   # find current record display index
   set dspIdx [$self curSelection]
   if {[llength $dspIdx] != 1} {
      set msg    "_UIT_ListGeneric::modify  Must have exactly one record "
      append msg "selected to modify.  There are [llength $dspIdx] selected."
      error $msg
   }

   # get new data
   set recID [$_dataNode getRecID]
   $_dataNode getRec $recID data

   # If filtered, check that new values still pass (return non-zero).
   if {$_filtered && ! [$self filterCB data]} {
       # no longer passes, delete
       $self deleteDspStr $dspIdx
   } else {
       set   items ""
       $self setListItem items [$self formatDisplayStrCB data] $recID
       $self _rememberState
       $self modifyDspStr $dspIdx $items
       $self _restoreState
   }

   return ""
}


#################################################################
#@ Override the read method for a listbox.  This method fills in the
#@   listbox by calling formatDisplayStrCB for each record in the
#@   table resource.
#@   Args:  {optimize 0}
#@   Since this operation can be very expensive when there are thousands of
#@   elements in the list, it is NOT done every time the window is displayed.
#@   The list should already be updated so this shouldn't hurt, but if for
#@   reason it does get out of sync, an explicit read will fix it.

_UIT_ListGeneric instproc read {{optimize 0}} {
    
    $self _rememberState
    $self instvar _dataNode _filtered
   
    if {[cequal $_dataNode ""] || $optimize} {
	return
    }

    # if filtered flag uninit, see if there is a filter callback
    if {$_filtered < 0} {
	set _filtered 1
	if {[cequal [$self info commands filterCB] ""]} {
	    set _filtered 0
	}
    }

    # If there is a filter callback, use it to filter the display list.
    #   Create a display string for each unfiltered record.  Use the
    #   Table record ID as the user data.
    $_dataNode getIDs ids
    set   items ""
    foreach id $ids {
	$_dataNode getRec $id data
	# Include all records if no filter, or if there is one, 
	#   only those that pass (return non-zero).
	if {! $_filtered || [$self filterCB data]} {
	    $self setListItem items [$self formatDisplayStrCB data] $id
	}
    }
    $self setVal $items
    $self _restoreState
}



#################################################################
#@ Buffer the specified resource record so it can be worked on.
#@ "Target" can be "default" or "current" of an index into the display list.

_UIT_ListGeneric instproc workOn {target} {
   $self instvar _dataNode
   
   if {[cequal _dataNode ""]} {
      error "List $self has no associated resource in workOn method."
   }
   
   switch -regexp -- $target {

      [Dd]efault { 
	 $_dataNode buffer
      }

      [Cc]urrent {
	  set id [$self getSelUserData]
	  if {[llength $id] == 1} {
		$_dataNode buffer $id
	  } else {
	      set    msg "Can only use 'workOn current' when there is "
	      append msg "exactly one record selected."
	      error $msg
	  }
      }

      end -
      ^[0-9]+$ {
	  set ndx [$self indexDspStr $target]
	  $self set _currentDspId $ndx
	  set items [$self getDspStr $ndx]
	  if {[llength $items] == 1} {
	      $_dataNode buffer [$self getItemUserData [lindex $items 0]]
	  } else {
	      set    msg "'workOn $target' matched [llength $items] records."
	      append msg "It needs to match exactly one."
	      error $msg
	  }
      }

      default {
	 error "_UIT_ListGeneric::workOn  Invalid workon index $target"
      }
  }
}


##################################################
# private methods

# ------------------------------------------------
#@ Remember selection for restoration after a change.

_UIT_ListGeneric instproc _rememberState {} {
    $self instvar _selectedItems _selUD

    set _selectedItems [$self curSelection]
    set _selUD         [$self getSelUserData]
}

# ----------------------------------------------------   
#@ The default double click call back.  The user can
#@ override this.

_UIT_ListGeneric instproc doubleClkCB {} {
    return
}

# ----------------------------------------------------   
#@ The default single click call back.  The user can
#@ override this.

_UIT_ListGeneric instproc singleClkCB {} {
    return
}

# ------------------------------------------------
#@ Restore the last remembered selection.
#@ It's based on user data so it will work even if display strings and
#@ order changes.  Scroll to the first selected item.

_UIT_ListGeneric instproc _restoreState {} {
    $self instvar _selectedItems _selUD

    # turn on each previous selection if it can be found
    set newSel ""
    set selIdx    0
    foreach ud $_selUD {
	set oldIdx [lindex $_selectedItems $selIdx]
	set newIdx [$self _findUD $ud $oldIdx]
	if { ! [cequal $newIdx ""]} {
	    lappend newSel $newIdx
	}
	incr selIdx
    }
    # order items so scrolling is to first item
    eval {$self setSelection} [lsort -integer $newSel]

    # set scroll to first 
    $self setViewable "selected"
}

#@ Resort the userData and redisplay the display strings.
#@ Parameter column is the column to sort on.
_UIT_ListGeneric instproc _columnSort {column} {

    $self _rememberState
    
    $self instvar _sortDirection _column _selectedItems

    cequal $_selectedItems { debug__0 } 
    if { ![cequal $_column $column] } {
	# Save the column to be used in the compare routine
	set _column $column
	# Always start out sorting ascending
	set _sortDirection 1
    }

    set dspStr [$self getDspStr 0 end]

    # Perform sort, either ascending or decending
    if {$_sortDirection == 1} {
	set dspStr [lsort -command "$self _sortAscending" $dspStr]

	# Change direction for next time
	set _sortDirection -1
    } else {
	set dspStr [lsort -command "$self _sortDecending" $dspStr]

	# Change direction for next time
	set _sortDirection 1
    }

    $self setVal $dspStr
    $self _restoreState
}

_UIT_ListGeneric instproc _sortAscending {a b} {
    $self instvar _column
    $self ${_column}CompareCB $a $b
}
_UIT_ListGeneric instproc _sortDecending {a b} {
    $self instvar _column
    return [expr -1 * [$self ${_column}CompareCB $a $b]]
}

##################################################
