# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.11.2  2000/10/30  20:51:09  Peter_Wolfe
# 	Code drop for yankee bl3
#
# Revision 1.1.2.65  2000/10/18  20:52:38  Richard_Taft
# 	That instvar needs to have a larger scope than I thought!
#
# Revision 1.1.2.64  2000/10/18  15:43:53  Richard_Taft
# 	Second time through display, couldn't find _lstbox. Needed an instvar.
#
# Revision 1.1.2.63  2000/08/30  19:05:05  Richard_Taft
# 	Make sure to unset selection initially.
# 	Moved initial sort of mclist to outside the main if.  When placed
# 	within, it was screwing up the relationship between the listbox and
# 	the internal list, with the result that the user selected item was not
# 	the item that SUIT thought was selected.
#
# Revision 1.1.2.62  2000/08/28  20:41:02  Richard_Taft
# 	Sort both the listbox and internal list initially
#
# Revision 1.1.2.61  2000/08/24  18:20:16  Richard_Taft
# 	Make sure index for see command is not negative.
#
# Revision 1.1.2.60  2000/07/18  19:47:12  Richard_Taft
# 	Moved increment of _displayedOnce to the end of init where it
# 	should properly be.  When at the top of the proc, it was
# 	causing problems for multi-column list widget.
#
# Revision 1.1.2.59  2000/06/19  15:07:46  Ramnath_Ravindran
# 	Added resize proc for column width adjustment in multi-column lists
#
# Revision 1.1.2.58  2000/05/16  19:07:31  Richard_Taft
# 	Make check for mclist before sorting 1st time
#
# Revision 1.1.2.57  2000/01/21  19:21:51  Richard_Taft
# 	Fix sorting"	Sort ascending the first time a column is clicked
# 	[2000/01/21  19:19:32  Richard_Taft]
#
# 	Sort by first column on startup
# 	[2000/01/21  18:56:14  Richard_Taft]
#
# Revision 1.1.2.56  2000/01/14  16:22:49  Richard_Taft
# 	removed diagnostic message
#
# Revision 1.1.2.55  2000/01/14  15:59:46  Richard_Taft
# 	Added code supporting multicolumn listboxes
#
# Revision 1.1.2.54  1999/10/13  20:12:52  Richard_Taft
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
#
# Revision 1.1.2.53  1999/07/13  17:17:42  William_Athanasiou
# 	Fix problem of doubleClkCB causing coredump in java
# 	[1999/07/13  13:00:47  William_Athanasiou]
#
# Revision 1.1.2.52  1999/01/21  21:31:04  Richard_Taft
# 	Defined doubleClkCB.
# 	[1999/01/21  21:30:18  Richard_Taft]
# 
# Revision 1.1.2.51  1998/10/19  19:12:38  William_Athanasiou
# 	Use constant width font for listbox labels
# 	[1998/10/19  19:09:47  William_Athanasiou]
# 
# Revision 1.1.2.50  1998/10/05  14:16:57  Richard_Taft
# 	Multiple selection should use selectMode "extended" for GUI
# 	but "multiple" for CUI.  Extended is more Windows-like, but
# 	it doesn't work under curses.
# 	[1998/10/05  14:10:57  Richard_Taft]
# 
# Revision 1.1.2.49  1998/10/01  21:29:39  William_Athanasiou
# 	Fix mode of selection for listboxes
# 	[1998/10/01  21:29:10  William_Athanasiou]
# 
# Revision 1.1.2.48  1998/09/24  18:26:39  Richard_Taft
# 	Initialize _lbstate
# 	[1998/09/24  18:26:07  Richard_Taft]
# 
# Revision 1.1.2.47  1998/09/24  16:55:45  Richard_Taft
# 	Fixed QAR 61338. The needSelection buttons no longer
# 	get enabled if the entire listbox is disabled.  The
# 	user can still select items, but can't use any of the
# 	listbox buttons.
# 	[1998/09/24  16:54:49  Richard_Taft]
# 
# Revision 1.1.2.46  1998/06/17  16:30:48  William_Athanasiou
# 	fixed problem with passing selected items as a list rather than individual args
# 	[1998/06/17  16:27:04  William_Athanasiou]
# 
# Revision 1.1.2.45  1998/05/04  18:03:33  Richard_Taft
# 	Fixed bug on insert when no items were in list.
# 	[1998/05/04  18:00:39  Richard_Taft]
# 
# Revision 1.1.2.44  1998/04/30  21:44:07  Todd_Moyer
# 	Fixed setViewable method.
# 	[1998/04/30  21:40:29  Todd_Moyer]
# 
# Revision 1.1.2.43  1998/04/20  12:50:18  William_Athanasiou
# 	selection should an instvar
# 	[1998/04/20  12:48:22  William_Athanasiou]
# 
# Revision 1.1.2.42  1998/04/16  14:58:37  William_Athanasiou
# 	Fix inital set of active index
# 	[1998/04/16  14:36:00  William_Athanasiou]
# 
# Revision 1.1.2.41  1998/04/10  02:33:48  William_Athanasiou
# 	correct _setstate method
# 	[1998/04/10  02:23:35  William_Athanasiou]
# 
# Revision 1.1.2.40  1998/04/01  20:00:17  William_Athanasiou
# 	Disable list buttons using enable/disable methods
# 	[1998/04/01  19:59:10  William_Athanasiou]
# 
# Revision 1.1.2.39  1998/03/25  18:19:42  William_Athanasiou
# 	fix problem with setting selecion in initCB
# 	[1998/03/25  18:19:06  William_Athanasiou]
# 
# Revision 1.1.2.38  1998/03/16  20:09:16  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:50  William_Athanasiou]
# 
# Revision 1.1.2.37  1998/02/26  21:35:41  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:29:38  William_Athanasiou]
# 
# Revision 1.1.2.36  1998/02/20  15:56:54  Todd_Moyer
# 	Fixed problem where buttons needing selection were not grayed.
# 	[1998/02/20  15:54:51  Todd_Moyer]
# 
# Revision 1.1.2.35  1998/02/12  22:47:08  Todd_Moyer
# 	For double click, turn off any other selections.
# 	This makes double click work nicely in multi-select
# 	listboxes.
# 	[1998/02/12  22:46:25  Todd_Moyer]
# 
# Revision 1.1.2.34  1998/02/11  18:44:09  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:39  William_Athanasiou]
# 
# Revision 1.1.2.33  1998/02/05  16:32:51  William_Athanasiou
# 	Update size of scollbar
# 	[1998/02/05  16:32:19  William_Athanasiou]
# 
# Revision 1.1.2.32  1998/01/26  15:41:25  William_Athanasiou
# 	Make sure viewableItem is visible on initial display
# 	[1998/01/26  15:29:50  William_Athanasiou]
# 
# Revision 1.1.2.31  1997/11/06  15:23:41  William_Athanasiou
# 	Add setViewable command
# 	[1997/11/06  15:20:17  William_Athanasiou]
# 
# Revision 1.1.2.30  1997/08/28  18:37:16  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.27 **
# 		** Merge revision:	1.1.2.29 **
# 	 	** End **
# 	SingleClk and doubleClk now call invokeWrapper instead of
# 	invokeCB so that a busy cursor can be displayed while the
# 	callback is running.
# 	[1997/08/28  18:06:30  Richard_Taft]
# 
# Revision 1.1.2.29  1997/08/22  18:46:18  William_Athanasiou
# 	get catalog strings for listbox
# 	[1997/08/22  18:32:26  William_Athanasiou]
# 
# Revision 1.1.2.28  1997/08/18  17:11:13  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:36  William_Athanasiou]
# 
# Revision 1.1.2.27  1997/05/09  20:40:41  Todd_Moyer
# 	Comment out getCurSelection so we use the one in listgen.
# 	[1997/05/09  19:02:55  Todd_Moyer]
# 
# Revision 1.1.2.26  1997/04/29  13:16:03  William_Athanasiou
# 	Correct getCurSelection handling of selected strings with multiple elements.
# 	[1997/04/29  13:07:37  William_Athanasiou]
# 
# Revision 1.1.2.25  1997/04/24  20:40:04  William_Athanasiou
# 	Added singleClk and doubleClk options for listboxes
# 	[1997/04/24  16:03:19  William_Athanasiou]
# 
# Revision 1.1.2.24  1997/04/22  14:50:21  William_Athanasiou
# 	Fixed problem with listbox update and setting of selection
# 	[1997/04/22  14:49:34  William_Athanasiou]
# 
# Revision 1.1.2.23  1997/04/09  21:37:41  William_Athanasiou
# 	restore view of listbox after content update
# 	[1997/04/09  21:36:12  William_Athanasiou]
# 
# 	Fixed dynamic addition of scrollbars
# 	[1997/04/09  18:17:14  William_Athanasiou]
# 
# Revision 1.1.2.22  1997/04/09  16:30:38  William_Athanasiou
# 	Changed font of listbox to fixed width, and same as entry widget
# 	[1997/04/09  16:19:32  William_Athanasiou]
# 
# Revision 1.1.2.21  1997/04/07  18:33:45  William_Athanasiou
# 	removed puts left in by accident
# 	[1997/04/07  18:33:23  William_Athanasiou]
# 
# Revision 1.1.2.20  1997/04/07  14:44:44  William_Athanasiou
# 	Listbox focus problem: If a change in the listbox forces the UI to be
# 	  updated, then record the active record, and reset it once the update
# 	  has been done.  This prevents cursor tracking problems in CUI and
# 	  is cleaner in appearance.
# 	[1997/04/07  14:44:09  William_Athanasiou]
# 
# Revision 1.1.2.19  1997/03/28  21:13:20  William_Athanasiou
# 	Fixed problem of value set/inspection before UIrep available
# 	[1997/03/28  21:10:39  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/03/28  16:46:44  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:18  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/03/21  15:55:27  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:40  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/03/13  17:45:06  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:53  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/03/07  19:08:08  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:40  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/03/07  15:40:44  William_Athanasiou
# 	Expand listbox correctly when window resized
# 	[1997/03/07  15:37:06  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/02/17  21:38:58  William_Athanasiou
# 	Fixed problem with null list
# 	[1997/02/17  21:38:06  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/01/21  13:51:48  William_Athanasiou
# 	Changed names of curselection, getcurselection and selecteditemcount
# 	[1997/01/21  13:43:08  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/01/16  20:37:40  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:20  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/01/16  14:15:40  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:13:59  William_Athanasiou]
# 
# Revision 1.1.2.9  1996/12/12  16:48:45  William_Athanasiou
# 	added read method, and removed 'self next' from display to prevent 'read' method call
# 	[1996/12/12  16:36:35  William_Athanasiou]
# 
# Revision 1.1.2.8  1996/11/27  23:22:47  Todd_Moyer
# 	Call listgen's display from display to get data read in.
# 	[1996/11/27  22:53:44  Todd_Moyer]
# 
# Revision 1.1.2.7  1996/11/14  19:54:58  William_Athanasiou
# 	Added setselection method
# 	[1996/11/14  19:39:29  William_Athanasiou]
# 
# Revision 1.1.2.6  1996/11/05  13:54:03  William_Athanasiou
# 	Update button status whenever selection is made
# 	[1996/11/05  13:45:50  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/11/04  17:26:15  William_Athanasiou
# 	Added comments
# 	The listbox widget is now only updated once all changes have been
# 	  made and the system is idle.  This prevents the widget from being
# 	  updated too frequently.
# 	[1996/11/04  17:24:54  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/10/29  15:01:46  William_Athanasiou
# 	Completed List widget functionality
# 	[1996/10/29  14:56:10  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/10/24  18:43:08  William_Athanasiou
# 	added trace of widget global
# 	[1996/10/24  18:36:24  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/10/16  14:35:10  William_Athanasiou
# 	first pass at listbox
# 	[1996/10/16  14:25:32  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: listgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_ListGUI -superclass _UIT_ListGeneric

_UIT_ListGUI instproc init {args} {   
   eval {$self next} $args

   global _UIT_g_main
   $self instvar buttons _parent _efont _update _oldbindings _lbstate
   
   set _efont {}
   set _update {}
   set _oldbindings {}
   set _lbstate enabled

   set leaf [lindex [split $self .] end]
   $_UIT_g_main set currParent $self
   foreach i $buttons {
      Button $leaf.$i
   }
   $_UIT_g_main set currParent $_parent


}

############################
_UIT_ListGUI instproc display {} {
   $self instvar _displayedOnce _lstbox

   if {!$_displayedOnce} {

      #
      # Build UIrep.
      
      global _UIT_g_main _UIT_g_wdgtVals
      $self instvar needSelection buttons selection autoSort width height \
	    _valuePtr _lbl _UIrep _btnbox _window _parent \
	    _selectedItems _viewableItem _enabledState
      
      set leaf [lindex [split $self .] end]
      set container [$_parent set containWdgt]
   
      set _UIrep [frame $container.$leaf]
      set _lstbox [$self _makeLstBox $_UIrep.lst $_lbl]
      $_lstbox configure -visibleitems ${width}x${height} \
	    -items $_UIT_g_wdgtVals($self) 
      bind $_lstbox <Configure> "$_lstbox constrainSize"
      $_window _registerUImap $_UIrep.lst $self

      # Create the buttonbox.

      set _btnbox [buttonbox $_UIrep.btn]
      $_UIT_g_main set currParent $self
      foreach i $buttons {
	 $_btnbox add $self.$i
      }
      $_UIT_g_main set currParent $_parent

      # Set up single and double click
      $_lstbox configure -selectioncommand "$self _singleClick"
      $_lstbox configure -dblclickcommand  "$self _doubleClick"

      #
      # Set listbox selection mode: multiple or single
      $self _setSelectMode $selection

      # Clear selection
      if {[cequal $selection "single"] &&
	  [lempty $_selectedItems] && ![lempty $_UIT_g_wdgtVals($self)]} {
	    set _selectedItems 0
	    $self setSelection {}
      }

      #
      # Check to see if items in listbox were selected in the initCB
      # routines.
      
      if {![cequal $_selectedItems {}]} {
	 foreach i $_selectedItems { $_lstbox selection set $i }
	 $_lstbox activate [lindex $_selectedItems 0]
	 $self _activateBtns
      } else {
	 $_lstbox activate 0
      }

      #
      # Check to see if there is a viewable item set and make it viewable
      if {![cequal $_viewableItem {}] && $_viewableItem >= 0} {
	 $_lstbox see $_viewableItem
      }

      # Pack the listbox and its buttons
      pack $_lstbox -side top -fill both -expand 1
      pack $_btnbox -side bottom -fill x      
      pack $_UIrep -fill both  -expand 1 -side [$_parent packSide] -anchor nw
      $self _setState $_enabledState
      
      # trace the widgt's values and update the listbox when it changes.
      $self set _update {}
      trace variable _UIT_g_wdgtVals($self) w "$self _updateListBox"

      incr _displayedOnce
   }

    $self instvar headings
    if { [info exists headings] && ($headings != "") } {
	# Initially, sort by first column, ascending
	$self instvar _column _sortDirection
	set _column [lindex [lindex $headings 0] 0 ]  ;# first column
	set _sortDirection 1                          ;# ascending
	$_lstbox _sort $_column

    }

   $self next
}

_UIT_ListGUI instproc _setState {val} {
   $self instvar _lstbox _oldbindings buttons _btnbox _lbstate
   $_lstbox configure -labelstate $val

   set _lbstate $val

#   set listbox [$_lstbox component listbox]
   if [cequal $val "disabled"] {
#      bind foo
#      set _oldbindings [bindtags $listbox]
#      bindtags $listbox foo
      foreach i $buttons {
	 $self.$i disable
	 #$_btnbox buttonconfigure $self.$i -state disabled
      }
   } else {
#     if ![cequal $_oldbindings {}] {
#	 bindtags $listbox $_oldbindings
#      }
#      set _oldbindings {}
      foreach i $buttons {
	 $self.$i enable
	 $_btnbox buttonconfigure $self.$i -state normal
      }
      $self _checkSelection
   }
}

_UIT_ListGUI instproc syncListboxUpdate {} {
   $self instvar _update
   if {$_update != {}} {
      after cancel $_update
      uplevel #0 "$self _updateListBox var {} op now" 
   }
}

_UIT_ListGUI instproc setLabel {s} {
   $self instvar _lbl _lstbox _displayedOnce 
   set _lbl $s
   if $_displayedOnce {
      $_lstbox configure -labeltext $s
   }
}

_UIT_ListGUI instproc setViewable {n} {
   $self next $n
   if ![$self set _displayedOnce] {
      return
   }
   $self syncListboxUpdate
   $self instvar _lstbox _viewableItem
   # dont know why we need update, but we do
   update idletasks
   if {![cequal $_viewableItem {}] && $_viewableItem >= 0} {
      $_lstbox see $_viewableItem
   }
}

############################
# Supply the UI specific methods needed to manage selection

#@ First update _selectedItems from generic setSelection call, then
#@   visually update the new selected items in the listbox.  Finally,
#@   check to see if buttons need to be disabled.

_UIT_ListGUI instproc setSelection {args} {
   eval $self next $args

   if {[$self set _displayedOnce]} {
      $self instvar _selectedItems _lstbox _update selection
      #
      # Make sure listbox has been updated before setting selections
      #   otherwise selections will disappear when list is updated 
      #   during an idle time.
      #
      set selectionHold $_selectedItems
      $self syncListboxUpdate
      foreach i [$_lstbox curselection] { $_lstbox selection clear $i }
      foreach i $selectionHold          { 
	 $_lstbox selection set $i 
	 if [cequal $selection "single"] {
	    $_lstbox activate $i
	 }
      }
      
      $self _checkSelection
   }
}

_UIT_ListGUI instproc curSelection {} {
   $self instvar _displayedOnce _selectedItems _lstbox

   if {!$_displayedOnce} {
      return $_selectedItems
   } else {
      return [$_lstbox curselection]
   }
}

_UIT_ListGUI instproc selectedItemCount {} {
   $self instvar _displayedOnce _selectedItems _lstbox

   if {!$_displayedOnce} {
      return [llength $_selectedItems]
   } else {
      return [$_lstbox selecteditemcount]
   }
}

# _UIT_ListGUI instproc getCurSelection {} {
#    $self instvar _displayedOnce _selectedItems _lstbox
#    if {!$_displayedOnce} {
#       set v {}
#       foreach i $_selectedItems {
# 	 lappend v [$self getDspStr $i]
#       }
#       return $v
#    } else {      
#       return [$_lstbox getcurselection]
#    }
# }

############################
# Internal methods.


# ----------------------------------------------------   
#@ Enable buttons that require a selected item.

_UIT_ListGUI instproc _activateBtns {} {
   $self instvar _btnbox needSelection _lbstate

    if { [cequal $_lbstate "disabled"] } return

   foreach i $needSelection {
      $self.$i enable
      #      $_btnbox buttonconfigure $self.$i -state normal
   }
}


# ----------------------------------------------------   
#@ Check if any items selected.  If so, turn on buttons that
#@ require an operand; otherwise, turn them off.

_UIT_ListGUI instproc _checkSelection {} {
   $self instvar _selectedItems 

   if {[set _selectedItems [$self curSelection]] != {}} {
      $self _activateBtns
   } else {
      $self _deactivateBtns
   }
}


# ----------------------------------------------------   
#@ Disable buttons that require a selected item.

_UIT_ListGUI instproc _deactivateBtns {} {
   $self instvar _btnbox needSelection
   foreach i $needSelection {
      $self.$i disable
#      $_btnbox buttonconfigure $self.$i -state disabled
   }
}


# ----------------------------------------------------   
#@ Turn on buttons that require a selected item.
#@ Invoke the button associated with double click if any.
#@ If no button, invoke the default doubleClkCB.
#@ Sets the selection to just the item double clicked on in case
#@ multiselect turned on.

_UIT_ListGUI instproc _doubleClick {} {
    $self instvar doubleClk _lstbox

    $self _checkSelection
    eval {$self setSelection} [$_lstbox index active]

    if {$doubleClk != {}} {
	$self.$doubleClk invokeWrapper
    } else {
	global _UIT_g_main
	$self instvar _busy _window

	$_window _makeBusy       ;# make window busy.

 	$self doubleClkCB
   
	$_window _makeNotBusy
    }
}

# ----------------------------------------------------

_UIT_ListGUI instproc _makeLstBox {wdgt lbl} {
   global _UIT_DisplayAttr _UIT_g_main
   $self instvar headings cHeadings lst

   # If headings are specified in genUID, then this is
   # a multi-column listbox
   if {[info exists headings] == 0} {
       # Create a regular listbox
       set lst [scrolledlistbox $wdgt -labelfont $_UIT_DisplayAttr(EntryFont)\
		-labeltext $lbl -exportselection 0\
		-labelpos nw -labelmargin 0 -vscrollmode dynamic \
		-hscrollmode dynamic -textfont $_UIT_DisplayAttr(EntryFont)]

       return $lst
   } else {
       # Create a multi-column listbox

       # Get the headings from the catalog and compute length if necessary
       set cHeadings {}
       set i 0
       foreach h $headings {
	   if { [llength $h] != 1 } {
	       # Heading and length are given
	       set hcat [lindex $h 0]
	       set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
	       set hlen [lindex $h 1]
	   } else {
	       # Only a heading given => length is label length + 2
	       set hcat $h
	       set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
	       set hlen [expr [string length $hlabel] + 2]
	   }
	   lappend cHeadings [list $hcat $hlabel $hlen]

	   # create a compare routine for each column if the user
	   # hasn't created one already
	   if {[$self info procs ${hcat}CompareCB] == {}} {
	       eval [subst  -nocommand {
		   $self proc ${hcat}CompareCB {a b} {
		       set aList [lindex \$a 0]
		       set bList [lindex \$b 0]

		       string compare [lindex \$aList $i] \
			   [lindex \$bList $i]
		   }
	       } ]
	   }

           incr i
       }

       set lst [mcscrolledlistbox $wdgt \
		    -labelfont $_UIT_DisplayAttr(EntryFont)\
		    -labeltext $lbl -exportselection 0\
		    -labelpos nw -labelmargin 0 -vscrollmode dynamic \
		    -hscrollmode dynamic \
		    -textfont $_UIT_DisplayAttr(EntryFont)\
		    -headings $cHeadings \
		   ]

       # Set up column sort
       $lst configure -sortcommand "$self _columnSort"

       return $lst
   }
}

# ----------------------------------------------------
#@ Turn on buttons that require a selected item.
#@ Invoke the button associated with single click if any.

_UIT_ListGUI instproc _singleClick {} {
    $self instvar singleClk _lstbox

    $self _checkSelection
    if {$singleClk != {}} {
	$self.$singleClk invokeWrapper
    }
}


# ----------------------------------------------------
#@ This method is called whenever the global listbox variable is updated to
#@   set the new listbox contents to the new value of the global variable.
#@ The actual update is postponed until all pending changes have been made.

_UIT_ListGUI instproc _updateListBox {var dummy op {when {later}}} {
   $self instvar _update _lstbox _valuePtr

   if {$when == "later"} {
      if {$_update == ""} {
	 set _update [after idle "$self _updateListBox $var {} $op now"]
      }
      return
   } elseif {$when != "now"} {
      error "bad option \"$when\": should be now or later"
   }

   upvar #0 $_valuePtr lst

   set _update {}
   if {$lst == {}} {
      $self _deactivateBtns
   } else {
      after idle "$_lstbox activate [$_lstbox index active]; \
	    $_lstbox selection anchor [$_lstbox index anchor];\
	    $_lstbox xview moveto [lindex [$_lstbox xview] 0];\
	    $_lstbox yview moveto [lindex [$_lstbox yview] 0]"
   }

   $_lstbox config -items $lst
   $self _checkSelection
}

# ----------------------------------------------------
#@ This method is called to set the select mode to
#@ either single or multiple.
#@ We use TCL's extended mode for multiple selections
#@ and browse mode for single selections so the key
#@ bindings are like MS-Windows

_UIT_ListGUI instproc _setSelectMode {mode} {
# ----------------------------------------------------

    $self instvar _lstbox

    switch $mode {
	single { $_lstbox configure -selectmode browse }
	multiple { $_lstbox configure -selectmode extended }
    }
}

# ----------------------------------------------------
#@ This method is called when the user wants  to
#@ change the width of a particular column in the
#@ list.  It takes in the column name and the new
#@ width (val) as the arguments.
_UIT_ListGUI instproc resize {columnname val} {
# ----------------------------------------------------
    $self instvar lst cHeadings
    
    set i 0
    foreach h $cHeadings {
	if {[cequal [lindex $h 0] $columnname]} {
	    set h [lreplace $h 2 2 $val]
	    set cHeadings [lreplace $cHeadings $i $i $h]
	}
	incr i 1 
    }
    $lst configure -headings $cHeadings

}
