#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.13.2  2000/11/07  21:39:49  Peter_Wolfe
# 	SysMan code drop for BL3 code freeze
#
# Revision 1.1.2.30  2000/11/06  15:56:05  Richard_Taft
# 	Dummy resize method so that suitlets don't blow up.
#
# Revision 1.1.2.29  2000/07/24  20:10:25  Richard_Taft
# 	Make sure to quote (w/ safeXferString) column labels
#
# Revision 1.1.2.28  2000/05/08  15:22:42  Richard_Taft
# 	Synching shared sandbox and zuludx
#
# Revision 1.1.2.27  2000/05/04  19:39:45  Jie_Luo
# 	Added Multi-column list
# 	Added Multi-Column list
#
# Revision 1.1.11.1  2000/05/02  17:59:37  Jie_Luo
# 	Changes for multicolumn list and for tabbed widget
#
# Revision 1.1.9.2  2000/03/17  20:55:34  Jie_Luo
# 	Add code to support multi-column-list
#
# Revision 1.1.9.1  2000/03/17  20:05:46  Jie_Luo
# *** Initial Branch Revision ***
#
# Revision 1.1.2.26  1998/12/14  20:13:36  William_Athanasiou
# 	Fix setView if _viewableItem is null
# 	[1998/12/14  20:11:56  William_Athanasiou]
#
# Revision 1.1.2.25  1998/11/22  16:08:19  William_Athanasiou
# 	Fix problem with list going to client for contents
# 	[1998/11/22  16:05:36  William_Athanasiou]
# 
# Revision 1.1.2.24  1998/06/17  16:30:48  William_Athanasiou
# 	fixed problem with passing selected items as a list rather than individual args
# 	[1998/06/17  16:27:06  William_Athanasiou]
# 
# Revision 1.1.2.23  1998/03/16  20:09:17  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:53  William_Athanasiou]
# 
# Revision 1.1.2.22  1998/03/05  20:47:20  William_Athanasiou
# 	Remove code that was causing java list to be updated twice
# 	[1998/03/05  20:46:54  William_Athanasiou]
# 
# Revision 1.1.2.21  1998/02/13  22:27:57  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:23:13  William_Athanasiou]
# 
# Revision 1.1.2.20  1998/01/23  17:01:12  William_Athanasiou
# 	Correct handling of multi mod/delete
# 	[1998/01/22  22:29:17  William_Athanasiou]
# 
# Revision 1.1.2.19  1998/01/06  21:51:27  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.17 **
# 		** Merge revision:	1.1.2.18 **
# 	 	** End **
# 	If deleting multiple items, then you must be able to delete
# 	all of them at once, since any delete operation changes the
# 	configuration of the list.
# 	[1998/01/06  18:38:18  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/12/30  17:00:58  Todd_Moyer
# 	Fixed deactivateBtn problem (Qar 57728).
# 	[1997/12/30  16:59:59  Todd_Moyer]
# 
# Revision 1.1.2.17  1997/11/07  20:08:17  Richard_Taft
# 	Some words needed to be quoted
# 	[1997/11/07  20:07:41  Richard_Taft]
# 
# Revision 1.1.2.16  1997/11/06  19:58:28  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:43  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/11/06  15:23:41  William_Athanasiou
# 	Add setViewable command
# 	[1997/11/06  15:20:19  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/09/23  18:58:20  Richard_Taft
# 	Added check for DisplayedOnce to many procs
# 	[1997/09/23  18:54:58  Richard_Taft]
# 
# 	Missing space caused bug in insertDspStr
# 	[1997/08/26  17:01:30  Richard_Taft]
# 
# Revision 1.1.2.13  1997/08/22  18:46:18  William_Athanasiou
# 	Remove resetval call and correct display logic
# 	[1997/08/22  18:28:43  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/08/20  13:00:54  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.10 **
# 		** Merge revision:	1.1.2.11 **
# 	 	** End **
# 	Changed setSelection so it quotes list elements
# 	[1997/08/20  12:32:06  Richard_Taft]
# 
# 	Call resetVal from display to set _javaKnowsMe and sync
# 	up values between java & suit.
# 	Took out workOn, which wasn't necessary after all.
# 	Send modItem, delItem and addItem to java instead of
# 	modify, delete, add.
# 	[1997/07/24  19:46:21  Richard_Taft]
# 
# Revision 1.1.2.11  1997/08/18  17:11:14  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.8 **
# 		** Merge revision:	1.1.2.10 **
# 	 	** End **
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:38  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/07/23  22:04:43  Richard_Taft
# 	setSel => setSelectgetSel => curSelectChanged curSelectionFromJava to handle the case where nothing is selectedsetVal now quotes itemsimplemented workOn
# 	[1997/07/23  21:57:35  Richard_Taft]
# 
# Revision 1.1.2.9  1997/07/22  21:42:26  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Various fixes to match expected Java Protocol
# 	[1997/07/22  21:37:32  Richard_Taft]
# 
# Revision 1.1.2.8  1997/07/22  17:03:15  William_Athanasiou
# 	Fixed setVal problem; missing {}
# 	[1997/07/22  17:02:48  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/21  21:48:06  Richard_Taft
# 	Implemented various instprocs for add, modify, delete and
# 	getting & setting the selection.
# 	[1997/07/21  21:17:47  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/18  19:54:45  Richard_Taft
# 	Changed puts to putJava
# 	[1997/07/18  19:49:05  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/11  19:28:08  Deepa_Bachu
# 	Fixed the problem where listbox button names were incorrect.
# 	width of the listbox was set to number.
# 	[1997/07/11  19:27:41  Deepa_Bachu]
# 
# Revision 1.1.2.4  1997/07/09  20:12:21  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:10:20  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/07/02  19:01:17  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:56:39  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/23  15:44:25  Deepa_Bachu
# 	Initial _UIT_ListJAVA class file.
# 	[1997/06/23  15:43:01  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: listjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_ListJAVA -superclass _UIT_ListGeneric


_UIT_ListJAVA instproc init {args} {
   global _UIT_g_main
   $self instvar _update
   
   eval $self next $args             ;# do parents init
   
   # forcing the buttons to be kids of the listbox instead of the window.
   $_UIT_g_main set currParent $self
   
   set _leaf     [lindex [split $self .] 1]
   
   foreach button [$self set buttons] {
      lappend buffer [Button $_leaf.$button]
   }
   $_UIT_g_main set currParent [$self set _parent]
   

   # variables required to hold list properties for the WEB implementation.
   
   $self set _curselection ""
   $self set _getcurselection ""
}


_UIT_ListJAVA instproc display {} {
   $self instvar _displayedOnce _selectedItems
   global _UIT_g_main
   
   if  {! $_displayedOnce } {
      $self instvar _lbl _helpTag width height _selectedItems \
	  singleClk doubleClk selection needSelection _valuePtr \
	  _viewableItem _enabledState
      upvar #0 $_valuePtr lst

     #handle single list and mutil-column-list by the diffrence of their heading

      $self instvar headings
      #single list
      if { [info exists headings] == 0 } {
         putJava_noNL "_UIT_List $self [safeXferString $_lbl]  $_enabledState \
            [safeXferString $_helpTag] $width $height"
      } else {
        #multi-column-list
        putJava_noNL "_UIT_Mclist $self [safeXferString $_lbl]  $_enabledState \
            [safeXferString $_helpTag] $width $height \{"

        set cHeading {}
        set i 0

        foreach h $headings {

          if { [llength $h] != 1 } {
            #Headind and length are given
            set hcat [lindex $h 0]
            set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
            set hlen [lindex $h 1]
          } else {
            #only a heading given==>length=labellength +2
            set hcat $h
            set hlabel [$_UIT_g_main catget ${self}_$hcat lbl]
            set hlen [expr [string length $hcat] + 2 ]
          }
          lappend cHeadings [list $hcat $hlabel $hlen]
          putJava_noNL "  $hcat [safeXferString $hlabel] $hlen  "

          # create a compare routine for each column if the user
          # hasn't created one already
          if {[$self info procs ${hcat}CompareCB] == {}} {
              eval [subst  -nocommand {
                  $self proc ${hcat}CompareCB {a b} {
                      set aList [lindex \$a 0]
                      set bList [lindex \$b 0]
  
                      string compare [lindex \$aList $i] \
                          [lindex \$bList $i]
                  }
              } ]
          }
          incr i
        }

        putJava_noNL " \} "
      }
     
      if {  [ info exists headings ] != 0 } {
         #   initially, sort by first column, ascending
         $self instvar _column _sortDirection
         set _column [lindex [lindex $cHeadings 0] 0 ]
         set _sortDirection 1
         $self _columnSort $_column
      }

 
      putJava_noNL " \{"
      
      foreach button [$self set _kids] {
	 putJava_noNL " \{"
	 $button display putJava_noNL
	 putJava_noNL " \}"
      }
      putJava_noNL " \}"
      putJava_noNL " \{ $needSelection \}"
      putJava_noNL " [safeXferString $selection] [safeXferString $singleClk]"
      putJava_noNL " [safeXferString $doubleClk] \{"

      foreach l $lst {
        if { [info exists headings ]==0 } {
           putJava_noNL " [safeXferString $l]"
        } else {
            #for multi-column-list,we need to seperate the lists further
            putJava_noNL " \{ "
            foreach li $l {
               putJava_noNL " [ safeXferString $li ] "
            }
            putJava_noNL " \} "
         }
      }
      putJava_noNL "\}"
      
      # list currently selected items
      putJava_noNL " \{"
      foreach itmNumber $_selectedItems {
	 putJava_noNL "$itmNumber "
      }
      putJava_noNL "\}"
      
      # list first viewable item '0' by default
      if { ! [ctype digit $_viewableItem] } {
        putJava " 0"
      } else {
        putJava " $_viewableItem"
      }
     
      incr _displayedOnce
      return
   }
   
   #
   # Check to see if items in listbox were selected in the initCB
   # routines.
   if {![cequal $_selectedItems {}]} {
      eval {$self setSelection} $_selectedItems
   }
}
 
_UIT_ListJAVA instproc setViewable {n} {
   $self next $n
   $self instvar _displayedOnce _viewableItem
   if $_displayedOnce {
      if [lempty $_viewableItem] {
	 putJava "$self setView 0"
      } else {
	 putJava "$self setView $_viewableItem"
      }
   }
}

_UIT_ListJAVA instproc setSelection {args} {

    # calling "next" will set _selectedItems
    eval $self next $args
    
    if {[$self set _displayedOnce]} {
       $self instvar _selectedItems _lstbox 
       if {[llength $_selectedItems] > 1} {
          set str " $self setSelect { "
          foreach itm $_selectedItems {
             append str " $itm "
          }
          append str " } "
          putJava $str

       } else {
	  putJava "$self setSelect \{ $_selectedItems \}"
       }
    }
}

_UIT_ListJAVA instproc curSelectionFromJava {} {
    $self instvar _selectedItems

    putJava "$self curSelect"
    if { [ getJava sel ] < 0 } {
	logMsg "Java Applet closed?"
	error "Java Applet closed?"
	return ""
    } else {
	# remove annoying braces. This will 
	# work even if sel is an integer
	set sel [lindex $sel 0]

	if { ([llength $sel] == 1) && $sel < 0 } {
	    set _selectedItems {}
	} else {
	    set _selectedItems $sel
	}
	return $sel
    }
}

_UIT_ListJAVA instproc curSelection {} {
    $self instvar _displayedOnce _selectedItems

    if {$_displayedOnce} {
	$self curSelectionFromJava
    }

    return $_selectedItems
}


_UIT_ListJAVA instproc selectedItemCount {} {
    $self instvar _displayedOnce _selectedItems

    if {$_displayedOnce} {
	$self curSelectionFromJava
    }

    return [llength $_selectedItems]
}


#_UIT_ListJAVA instproc insertDspStr {index recs} {
#    $self instvar _displayedOnce
#    $self instvar autoSort _userData _valuePtr
#
#    $self next $index $recs
#
#    if {$_displayedOnce} {
#	if {$autoSort} {
#	    upvar #0 $_valuePtr lst
#	    putJava_noNL "$self setVal {"
#	    foreach item $lst {
#		putJava_noNL " [safeXferString $item]"
#	    }
#	    putJava " }"
#	} else {
#	    foreach rec recs { 
#	       putJava "$self addItem $index [safeXferString $rec]"
#	       if { ! [cequal $index != "end"] } {
#		  incr index
#	       }
#	    }
#	}
#    }
#}


#_UIT_ListJAVA instproc modifyDspStr {index rec} {
#    $self instvar _displayedOnce
#    $self next $index $rec
#   $self instvar autoSort _valuePtr
#
#    if {$_displayedOnce} {
#	if {$autoSort} {
#	    upvar #0 $_valuePtr lst
#	    putJava_noNL "$self setVal {"
#	    foreach item $lst {
#		putJava_noNL " [safeXferString $item]"
#	    }
#	    putJava " }"
#	    
#	} else {
#	   putJava "$self modItem $index [safeXferString $rec]"
#	}
#    }
#}

    
#_UIT_ListJAVA instproc deleteDspStr {first {last {}}} {
#   $self instvar _displayedOnce
#   $self next $first $last
#   
#   if { [llength $last] == 0 } {
#      set last $first
#   }
#   
#   if {$_displayedOnce} {
#      set delList {}
#      for {set i $first} {$i <= $last} {incr i} {
#	 lappend delList $i
#      }
#      
#      putJava "$self delItem \{ $delList \}"
#   }
#}

#_UIT_ListJAVA instproc deleteCurSelection {} {
#   $self instvar _displayedOnce
#   set sel [$self curSelection]
#   
#   $self next
#   
#   if {$_displayedOnce} {
#      putJava "$self delItem \{ $sel \}"
#   }
#}

_UIT_ListJAVA instproc getVal {} {
   # Since an updated list is always kept on the server,
   # just return it.

   return [$self next]
}


_UIT_ListJAVA instproc setVal {val} {
   $self next $val
   $self instvar _valuePtr _displayedOnce

   upvar #0 $_valuePtr lst


## The following code is not needed.  Currently, all of the methods
## in _UIT_ListSimple call _resetDspStrs which does an explicit setval.
## Doing it here, just caused it to be done twice.  It would be nice if 
## a better way of updating the display strings could be found rather than
## by 'brute-forcing' through the entire list each time something is changed.
##
#   if { $_displayedOnce } {
#      putJava_noNL "$self setVal {"
#      foreach item $lst {
#	 putJava_noNL " [safeXferString $item] "
#      }
#      putJava " }"
#   }

   return $lst
}

_UIT_ListJAVA instproc _resetDspStrs {} {
   $self next
   $self instvar _displayedOnce _valuePtr
   $self instvar headings

   upvar \#0 $_valuePtr lst

   if {$_displayedOnce} {

      putJava_noNL " $self setVal \{ "

      foreach l $lst {
        if { [info exists headings ]==0 } {
           putJava_noNL " [safeXferString $l]"
        } else {
            #for multi-column-list,we need to seperate the lists further
            putJava_noNL " \{ "
            foreach li $l {
               putJava_noNL " [ safeXferString $li ] "
            }
            putJava_noNL " \} "
         }
      }
      putJava " \} "
   
   }
   return $lst
}

_UIT_ListJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}

# ----------------------------------------------------
#@ This method is called when the user wants  to
#@ change the width of a particular column in the
#@ list.  It takes in the column name and the new
#@ width (val) as the arguments.
#
#@@  It's a no-op right now.
# ----------------------------------------------------
_UIT_ListJAVA instproc resize {columnname val} {
    ;
}

