# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listsmp.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.9.1  2000/09/06  19:34:33  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.19  2000/08/25  15:31:09  Richard_Taft
# 	Reset selection after deleteCurSelection
#
# Revision 1.1.2.18  2000/04/12  18:41:43  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
#
# Revision 1.1.2.17  2000/02/09  16:46:22  Todd_Moyer
# 	Added some comments.
#
# Revision 1.1.2.16  1998/05/08  15:45:04  Todd_Moyer
# 	Added isChanged method.
# 	[1998/05/08  15:43:50  Todd_Moyer]
#
# Revision 1.1.2.15  1998/05/04  18:03:35  Richard_Taft
# 	Fixed bug on insert when no items are in list.
# 	[1998/05/04  18:02:58  Richard_Taft]
# 
# Revision 1.1.2.14  1998/04/30  21:44:09  Todd_Moyer
# 	Added _findUD method to search for an item by user data.
# 	[1998/04/30  21:43:16  Todd_Moyer]
# 
# Revision 1.1.2.13  1998/03/11  15:47:10  Richard_Taft
# 	Fixed typo: argument index was referred to as ndx in insertDspString.
# 	[1998/03/11  15:46:37  Richard_Taft]
# 
# Revision 1.1.2.12  1998/03/04  14:27:12  Richard_Taft
# 	Rather than issue an error when needSelection has non-existent
# 	buttons, we just remove the invalid ones from the list.
# 	[1998/03/04  14:26:33  Richard_Taft]
# 
# Revision 1.1.2.11  1998/01/29  21:49:53  Todd_Moyer
# 	Got rid of code to keep display strings unique.
# 	  Don't need it now that we got rid of keyed lists.
# 	[1998/01/29  21:49:19  Todd_Moyer]
# 
# Revision 1.1.2.10  1998/01/29  20:02:50  Todd_Moyer
# 	Replaced keyed list with regular list for huge
# 	  performance improvement.  Using arrays to check
# 	  for duplicate display strings.
# 	[1998/01/29  20:01:19  Todd_Moyer]
# 
# Revision 1.1.2.9  1998/01/21  22:15:13  Todd_Moyer
# 	Added deleteRange and deleteSet methods.
# 	Added design comments.
# 	[1998/01/21  22:14:51  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/11/06  15:23:42  William_Athanasiou
# 	Add setViewable command
# 	[1997/11/06  15:20:21  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/06/10  19:48:18  Richard_Taft
# 	Added code to handle redundant display strings
# 	[1997/06/10  19:43:36  Richard_Taft]
# 
# Revision 1.1.2.6  1997/05/20  19:24:22  Todd_Moyer
# 	Fixed bug in getDspStr when optional argument 'last' not specified.
# 	[1997/05/20  19:23:10  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/05/16  20:24:39  Todd_Moyer
# 	Fixed loop bug in getDspStr.
# 	[1997/05/16  20:23:48  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/05/15  18:59:09  Todd_Moyer
# 	Delt with display strings that contain dots (.) which keyed lists give
# 	  special significance to (use to nest keyed lists).
# 	  Added getCurDspStrs, getItemDspStr, getItemUserData and setListItem to
# 	  make it easier to interface to keyed lists.
# 	[1997/05/15  18:54:47  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/05/14  19:51:05  Todd_Moyer
# 	Put a no-op write method on lists so if the window containing
# 	  a list does a write, it doesn't break.
# 	[1997/05/14  19:50:23  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/05/09  20:40:52  Todd_Moyer
# 	  Created by spliting out some of the functionality formerly in the
# 	  ListGeneric class because that one got too complex.
# 	[1997/05/09  19:05:40  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: listsmp.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

#@ This class deals with simple lists.  It has a set of strings, and optionally,
#@  an associated set of IDs.  It can do sorting, but formating and
#@  filtering, if desired, must be done outside of this object.

Class _UIT_ListSimple -superclass _UIT_SuperWdgt

_UIT_ListSimple instproc init {args} {
   #set defaults
   $self instvar buttons needSelection width height autoSort selection \
	 singleClk doubleClk _currentRecId _currentDspId _selectedItems \
	 _dspStrUdPairs _viewableItem

   set buttons {add modify delete}
   set needSelection {modify delete}
   set width 20
   set height 5
   set autoSort 1
   set selection single
   set singleClk {}
   set doubleClk {}
   
   global _UIT_g_wdgtVals
   set _viewableItem {}
   set _selectedItems {}
   set _UIT_g_wdgtVals(${self}_selectedItems) {}

   set _currentRecId {} ;# List of record Id's
   set _currentDspId {} ;# List of related Display strings.

   # this list is the heart of the data.
   # it contains pairs of display strings and user-defined data
   set _dspStrUdPairs  ""

   eval {$self next} $args


   if {$singleClk != {}} {
      if {([llength $singleClk] > 1) || \
	    ([lsearch $buttons $singleClk] == -1)} {
	 error "List option -singleClk takes one argument, the name of\
	       a button specified in -buttons"
      }
   }

   if {$doubleClk != {}} {
      if {([llength $doubleClk] > 1) || \
	    ([lsearch $buttons $doubleClk] == -1)} {
	 error "List option -doubleClk takes one argument, the name of\
	       a button specified in -buttons"
      }
   }

   set i3 [intersect3 $needSelection $buttons]
   set remainder [lindex $i3 0];	# invalid buttons	
   if {$remainder != {}} {
       # There are buttons in needSelection that do not exist;
       # therefore, set needSelection to only valid buttons
       set needSelection [lindex $i3 1]
   }
}


#################################################################
#@ Clear all lines from the listbox.

_UIT_ListSimple instproc clear {} {
    $self setVal {}
}


#################################################################
#@ Default compare for sorting display strings.

_UIT_ListSimple instproc compareCB {a b} {
    string compare [lindex $a 0] [lindex $b 0]
}


#################################################################
#@ Delete selected entries from the listbox.

_UIT_ListSimple instproc deleteCurSelection {} {
    $self deleteSet [$self curSelection]
    $self setSelection {}
}


#################################################################
#@ Just here for backward compatibility.
#@  Replaced by deleteRange.

_UIT_ListSimple instproc deleteDspStr {first {last {}}} {
   $self deleteRange $first $last
}


#################################################################
#@ Delete range of entries from the listbox.  
#@   If last is not specified, only the element 
#@   specified by first is deleted.

_UIT_ListSimple instproc deleteRange {first {last {}}} {
   upvar #0 [$self set _valuePtr] lst
   $self instvar _dspStrUdPairs
   
   set first [$self indexDspStr $first]
   if {$last != {}} {
      set last [$self indexDspStr $last]
   } else {
      set last $first
   }
    
   if {[llength $lst] > 0} {
      if {$first > $last} {
	 error "first index must not be greater than second"
      }
      set _dspStrUdPairs [lreplace $_dspStrUdPairs $first $last]
      $self _resetDspStrs
   }
}


#################################################################
#@ Delete entries from the listbox specified as indexes.
#@   Deletes from end of list backward so deleting
#@   doesn't change the indicies.

_UIT_ListSimple instproc deleteSet {indicies} {
    $self instvar _dspStrUdPairs
   
    set idxes [lsort -decreasing -integer $indicies]
    foreach idx $idxes {
	set _dspStrUdPairs [lreplace $_dspStrUdPairs $idx $idx]
    }
    $self _resetDspStrs

}


#################################################################
#@ return a list of display strings associated with
#@  each selected list item.

_UIT_ListSimple instproc getCurDspStrs {} {
    $self instvar _dspStrUdPairs

    set recs ""
    foreach idx [$self curSelection] {
	lappend recs [$self getItemDspStr [lindex $_dspStrUdPairs $idx]]
    }
    set recs
}


#-------------------------------------------------
#@ Return a command that can executed later to set the widget's value to its
#@   current value.  Intended for recording execution for scripting.
#@   Since user doesn't directly set this widget's value, it just needs
#@   to record which records were selected.  These are recorded by index,
#@   so if the values are not the same (for example if the system data
#@   has changed), the indexes will be off.

_UIT_ListSimple instproc getState {} {
    return "\{$self setSelection [$self curSelection]\}"
}


#################################################################
#@ Don't do anything, and do not branch up the display path.

_UIT_ListSimple instproc display {} {;}


#################################################################
#@ return the records (display strings/user data pairs) associated with
#@  each selected list item.

_UIT_ListSimple instproc getCurSelection {} {
    $self instvar _dspStrUdPairs

    set recs ""
    foreach idx [$self curSelection] {
	lappend recs [lindex $_dspStrUdPairs $idx]
    }
    set recs
}


#################################################################
#@ return the records (display strings/user data pairs) associated with
#@  each requested item.

_UIT_ListSimple instproc getDspStr {first {last {}}} {
    $self instvar _dspStrUdPairs

    if {[cequal $last ""]} {
	set last $first
    }
   
    lrange $_dspStrUdPairs [$self indexDspStr $first] [$self indexDspStr $last]
}


#################################################################
#@   Return the display string for a list item.
#@     Does any necessary translation.

_UIT_ListSimple instproc getItemDspStr {item} {
    lindex $item 0
}


#################################################################
#@   Return a list items user data.

_UIT_ListSimple instproc getItemUserData {item} {
    lindex $item 1
}


#################################################################
#@ return a list of user data tags associated with each selected list item.

_UIT_ListSimple instproc getSelUserData {} {

    set ud ""
    foreach item [$self getCurSelection] {
	lappend ud [$self getItemUserData $item]
    }
    set ud
}


#################################################################
#@ Return an index to an element in the listbox.  ndx can be a numerical
#@ index, end, or a pattern to search for in the listbox contents.  All
#@ indexes for other commands are passed through this routine, so it is not
#@ necessary to call this routine first.

# @@@ shouldn't this be private?

_UIT_ListSimple instproc indexDspStr {ndx} {
   upvar #0 [$self set _valuePtr] lst
   
   set len [llength $lst]
   
   switch -regexp -- $ndx {
      ^[0-9]+$ {
	 if {$ndx >= $len} { return $len }
	 if {$ndx < 0}    { return 0 }
	 return $ndx
      }
      end {
	 return [expr [llength $lst] - 1]
      }
      
      default {
	 return [lsearch -glob $lst $ndx]
      }
   }
}


#################################################################
#@ Insert entries into the listbox.  Insert can be passed multiple elements 
#@  to add to the listbox.

_UIT_ListSimple instproc insertDspStr {index recs} {
    $self instvar _dspStrUdPairs

    # do append if possible because it's quicker than insert
   if {[$self set autoSort] || [cequal "end" $index]} {
       eval lappend _dspStrUdPairs $recs
   } else {
       set _dspStrUdPairs [eval {linsert $_dspStrUdPairs $index} $recs]
   }

   if {[$self set autoSort]} {
       $self _sort
   } else {
       $self _resetDspStrs
   }
}


# ---------------------------------------
#@ A list is not associated with a single data attribute, so this
#@   always returns 0 (false).  Need this to override superwiget method.

_UIT_ListSimple instproc isChanged {} {
    return 0
}


#################################################################
#@ Modify the listbox entry.  Pass rec as a list contructed with setListItem.
#@  Can only do one entry at a time.

_UIT_ListSimple instproc modifyDspStr {index rec} {
    $self instvar _dspStrUdPairs

    set _dspStrUdPairs [lreplace $_dspStrUdPairs $index $index [lindex $rec 0]]

   # resort if necessary and redisplay
   if {[cequal "1" [$self set autoSort]]} {
       $self _sort
   } else {
       $self _resetDspStrs
   }
}


#################################################################
#@   Create a item in the specified value list.
#@     Developers that may have duplicate display strings must use
#@     the user data or some other means to distinguish them.

_UIT_ListSimple instproc setListItem {lstValsPtr dspStr userData} {
    upvar $lstValsPtr lstVals

    lappend lstVals [list $dspStr $userData]
}


#################################################################
#@ Scroll a listbox so the specified item is within its viewport.
#@ If 'selected' is specified, scroll to first selected item.

_UIT_ListSimple instproc setViewable {n} {
   if [cequal $n "selected"] {
      $self instvar _selectedItems
      if ![cequal $_selectedItems {}] {
	 $self set _viewableItem [lindex $_selectedItems 0]
      }
   } else {
      $self set _viewableItem [$self indexDspStr $n]
   }
}

#################################################################
#@   select items described by the index values in args.  Also
#@   update the _selectedItems list.

_UIT_ListSimple instproc setSelection {args} {
   # UI specific routine must allow this routine to update _selectedItems
   $self instvar _selectedItems selection
   
   set _selectedItems {}
   while {$args != {}} {
      set ndx [$self indexDspStr [lvarpop args]]
      if { $ndx >= 0 } {
	  lappend _selectedItems $ndx
      }
      if {$selection == "single"} {
	 set args {}
      }
   }
}


#################################################################
#@ Replace the contents of the listbox with the display strings from
#@   specified list.  The list must be created by calls to setListItem.
#@ If autoSort is enabled, then sort the list before placing it in the listbox.

_UIT_ListSimple instproc setVal {pairs} {
    $self instvar _dspStrUdPairs

    # check that the pairs are valid
    foreach item $pairs {
	if {[llength $item] != 2} {
	    set    msg "_UIT_ListSimple::setVal ERROR: value not formated"
	    append msg " properly.  Value must be created by calls to"
	    append msg " setListItem."
	    error $msg
	}
    }

    set _dspStrUdPairs $pairs
    if {[cequal [$self set autoSort] "1"]} {
	$self _sort
    } else {
        $self _resetDspStrs
    }
}


#################################################################
#@ Return the number of elements in the listbox.

_UIT_ListSimple instproc sizeOfList {} {
   upvar #0 [$self set _valuePtr] lst
   return [llength $lst]
}


#################################################################
#@ Don't do anything, and do not branch up the display path.

_UIT_ListSimple instproc updateData {} {;}


#################################################################
#@ Make write a no-op for lists.
#@   Lists need to do an add, modify or delete; write is too indefinite.

_UIT_ListSimple instproc write {} {
    # has to have something or Otcl deletes method
    ;
}



###############################################
# Private procs

# ------------------------------------------------
#@ Look for the specified user data and return it's index.
#@ If not found, return "".  'posIdx' is the index where this
#@ item was and possibly still is.

_UIT_ListSimple instproc _findUD {targetUD posIdx} {
    $self instvar _dspStrUdPairs

    # see if item still where it was
    set item [lindex $_dspStrUdPairs $posIdx]
    set ud   [lindex $item 1]
    if {[cequal $ud $targetUD]} {
	return $posIdx
    }

    # check each item for desired item
    set idx 0
    foreach pair $_dspStrUdPairs {
	set item [lindex $_dspStrUdPairs $idx]
	set ud   [lindex $item 1]
	if {[cequal $ud $targetUD]} {
	    return $idx
	}
	incr idx
    }

    # if not found...
    return ""
}


# ------------------------------------------------
#@ Reset the display strings from the data.

_UIT_ListSimple instproc _resetDspStrs {} {
    upvar #0 [$self set _valuePtr] lst
    $self instvar _dspStrUdPairs

    set dspStrs ""
    foreach item $_dspStrUdPairs {
	lappend dspStrs [lindex $item 0]
    }

    set lst $dspStrs
}


# ------------------------------------------------
#@ Resort the userData and redisplay the display strings.

_UIT_ListSimple instproc _sort {} {
    $self instvar _dspStrUdPairs

    set _dspStrUdPairs [lsort -command "$self compareCB" $_dspStrUdPairs]
    $self _resetDspStrs
}



###############################################
# These are UI specific routine place holders.
#

#@ Return a list of positional indecies for all the current selection(s).
#@   The first element is zero.  An empty list is returned if nothing
#@   is selected.

_UIT_ListSimple instproc curSelection {} {
   error "UI needs a definition for curselection"
}


#@ Return the number of items selected.

_UIT_ListSimple instproc selectedItemCount {} {
   error "UI needs a definition for selecteditemcount"
}

###############################################
