# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: listweb.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:07:25  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:40:35  William_Athanasiou]
#
# Revision 1.1.2.11  1997/05/01  19:34:09  William_Athanasiou
# 	Fixed getCurSelection to be consistent with GUI/CUI
# 	[1997/05/01  19:26:24  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/17  22:18:53  Deepa_Bachu
# 	Put in the nowrap option for the cell that contains
# 	the listbox.
# 	[1997/03/17  21:49:48  Deepa_Bachu]
# 
# 	Added the CENTER tag to center the listbox and its buttons
# 	within the cell.
# 	[1997/03/17  20:15:35  Deepa_Bachu]
# 
# Revision 1.1.2.9  1997/03/14  20:57:36  Deepa_Bachu
# 	Made changes to accomodate geometry management of
# 	listbox buttons.
# 	[1997/03/14  20:55:35  Deepa_Bachu]
# 
# Revision 1.1.2.8  1997/02/13  18:33:00  Deepa_Bachu
# 	Added fixed font within the listbox elements.
# 	[1997/02/13  15:18:04  Deepa_Bachu]
# 
# Revision 1.1.2.7  1997/01/21  13:51:49  William_Athanasiou
# 	Changed names of curselection, getcurselection and selecteditemcount
# 	[1997/01/21  13:43:12  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/16  14:15:41  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:03  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/12/23  20:50:26  Deepa_Bachu
# 	Modified the getcurselection method to return
# 	a string if only one element is selected.
# 	[1996/12/23  20:49:56  Deepa_Bachu]
# 
# 	Used &nbsp to be able to be able to display
# 	" " in the WEB.
# 	[1996/12/19  17:06:52  Deepa_Bachu]
# 
# 	Modified the _addSel method, to take care of the extra spaces
# 	in the display string.
# 	[1996/12/16  21:26:14  Deepa_Bachu]
# 
# Revision 1.1.2.4  1996/12/09  19:47:38  Deepa_Bachu
# 	Added '$self next' in the display proc to
# 	cause read to occur.
# 	[1996/12/09  19:46:35  Deepa_Bachu]
# 
# Revision 1.1.2.3  1996/11/15  15:51:46  Deepa_Bachu
# 	Added code tp be able to specify _selectedItems.
# 	[1996/11/15  15:50:53  Deepa_Bachu]
# 
# 	_UIT_ListWEB class file.
# 	[1996/11/14  20:05:01  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: listweb.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_ListWEB -superclass _UIT_ListGeneric


_UIT_ListWEB instproc init {args} {

    global _UIT_g_main


    eval $self next $args             ;# do parents init

    # forcing the buttons to be kids of the listbox instead of the window.
    $_UIT_g_main set currParent $self

    set _leaf     [lindex [split $self .] 1]

    foreach button [$self set buttons] {
	lappend buffer [Button $_leaf.$button]
    }
    $_UIT_g_main set currParent [$self set _parent]


    # variables required to hold list properties for the WEB implementation.

    $self set _curselection ""
    $self set _getcurselection ""
}


_UIT_ListWEB instproc display {} {

    global _UIT_g_main _UIT_g_wdgtVals

    $self next
    set list [$self getVal]

    puts "[[$self set _parent] geoTag]"
    puts " <TD COLSPAN=2 valign=top nowrap> [$self set _lbl] 
    <BR>
    <FONT SIZE=6 FACE=\"FIXED\">
    <CENTER>
    <select name=$self size=[$self set height] width=[$self set width] [$self set selection]>"

    foreach entry $list {
	set idx [lsearch [$self set _selectedItems] $entry]
	if {$idx == 0} {
		set sel "SELECTED"
	} else {
		set sel ""
	}
        regsub -all { } $entry {\&nbsp} entry
	puts "<OPTION $sel> $entry "
    }

    puts "</FONT>"
    puts "</select>"
    puts "<BR>"

    # have to force the kids of the listbox to be displayed.
    foreach k [$self set _kids] {
        $k display
    }
    puts "</TD>"
    puts "</CENTER>"
    puts "<BR>"

    $self next  
}


##################################################
# WEB specific procs
##################################################

_UIT_ListWEB instproc _addSel {Sel} {

    regsub -all {%A0} $Sel { } Sel
    set Sel [translit + " " $Sel]
    $self instvar _getcurselection _curselection

    set lst [set _getcurselection]
    lappend lst $Sel
    set _getcurselection $lst

    set lst [set _curselection]
    set idx [lsearch -glob [$self getVal] $Sel]
    lappend lst $idx
    set _curselection $lst
 
}



###################################################
# Generic procs that differ in UI implementation
###################################################

_UIT_ListWEB instproc MakeLstBox {wdgt lbl} {
}

_UIT_ListWEB instproc _updateListBox {var dummy op} {
}

_UIT_ListWEB instproc activateBtns {btns} {
}

_UIT_ListWEB instproc deactivateBtns {btns} {
}

_UIT_ListWEB instproc curSelection {} {
    return [$self set _curselection]
}

_UIT_ListWEB instproc selectedItemCount {} {
    return [llength [$self set _curselection]]
}

_UIT_ListWEB instproc getCurSelection {} {
   return [$self set _getcurselection]
}
