#
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: menumgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/09/06  19:34:35  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.13  2000/08/22  20:34:01  Ramnath_Ravindran
# 	Fixed the appearance of multienum widgets by making the scrollbars dynamic instead of static
#
# Revision 1.1.2.12  1998/05/27  19:57:56  William_Athanasiou
# 	Remove leftover debug puts
# 	[1998/05/27  19:17:14  William_Athanasiou]
#
# Revision 1.1.2.11  1998/04/10  13:35:21  William_Athanasiou
# 	Fix enable/disable algorithim
# 	[1998/04/10  13:34:33  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/04/10  02:33:48  William_Athanasiou
# 	correct _setState method
# 	[1998/04/10  02:23:54  William_Athanasiou]
# 
# Revision 1.1.2.9  1998/04/09  14:09:29  William_Athanasiou
# 	Correct font setting and fix enable/disable problem
# 	[1998/04/09  14:09:03  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/03/16  20:09:19  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:56  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/02/26  21:35:43  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:29:59  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/02/11  18:44:09  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:42  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/08/18  17:11:15  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:40  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/05/13  18:50:16  Deepa_Bachu
# 	Put a catch around "unset displaylist" since it could
# 	be null if valueList is not specified.
# 	[1997/05/13  18:49:48  Deepa_Bachu]
# 
# Revision 1.1.2.3  1997/05/13  18:21:56  Deepa_Bachu
# 	Updated _updateWidget to select only if idx >= 0.
# 	Addded methods setValueList and updateDispList to
# 	allow setting valueList at runtime.
# 	[1997/05/13  18:20:50  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/04/22  20:43:16  Deepa_Bachu
# 	Initial multi enum Class.
# 	[1997/04/22  15:50:22  Deepa_Bachu]
# 
# $EndLog$
#
# @(#)$RCSfile: menumgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
#

Class _UIT_MEnumGUI -superclass _UIT_MEnumGeneric

_UIT_MEnumGUI instproc init {args} {
   eval $self next $args
}

_UIT_MEnumGUI instproc display {} {
   $self instvar _displayedOnce 
   
   if {!$_displayedOnce} {
      global _UIT_g_main _UIT_g_wdgtVals
      $self instvar valueList height width displayList \
	  _UIrep _valuePtr _lbl _parent _isAlignable _window \
	  _lstbox _enabledState
      
      incr _displayedOnce
      set dlen [llength $valueList]
      
      if {$dlen <= 4} {
	 #
	 # Check buttons
	 #
	 set leaf      [lindex [split $self .] 1]
	 set container [$_parent set containWdgt]
	 set _UIrep [labeledwidget $container.$leaf -labeltext $_lbl]
	 
	 set Frm [$_UIrep childsite]
	 $_window _registerUImap $_UIrep $self
	 $_UIrep config -labelpos nw
	 $Frm config -relief groove
	 set i 0
	 set maxWidth 0
	 
	 foreach v $valueList {
	    checkbutton $Frm.r$i -variable _UIT_g_wdgtVals(${self}_$v) \
		-onvalue 1 -anchor w \
		-text $displayList($v) -highlightthickness 2 \
		-command " $self setValPtr"
	    pack $Frm.r$i -anchor w -padx 10p -pady 0
	    
	    if {[set idx [lsearch [$self getVal] $v]] >=0} {
	       set _UIT_g_wdgtVals(${self}_$v) 1
	       $Frm.r$i select
	    }
	    
	    $_window _registerUImap $Frm.r$i $self.$v
	    $_window _registerHelp $self.$v [$_UIT_g_main catget ${self}.${v} hlp]
	    incr i
	 }
	 # pack the checkbuttons
	 if {[string match {_UIT_Across*} $_parent]} {
	    set side left
	 } else {
	    set side top
	 }
	 pack $_UIrep -fill x -anchor nw -padx 0 -side $side
      } else {
	 #
	 # Multiple selection listbox
	 #
	 
	 set leaf [lindex [split $self .] end]
	 set container [$_parent set containWdgt]
	 set _UIrep [frame $container.$leaf]
	 set _lstbox [$self _makeLstBox $_UIrep.lst $_lbl]
	 $_lstbox configure -visibleitems ${width}x${height} \
	     -selectmode {multiple} 
	 foreach v $valueList {
	    $_lstbox insert end $displayList($v)
	 }
	 
	 # bind $_lstbox <Configure> "$_lstbox constrainSize"
	 $_window _registerUImap $_UIrep.lst $self
	 
	 # pack listbox
	 pack $_lstbox -side top -fill both -expand 1
	 if {[string match {_UIT_Across*} $_parent]} {
	    pack $_UIrep -fill both  -expand 1 -side left -anchor nw
	 } else {
	    pack $_UIrep -fill both  -expand 1 -anchor nw
	 }
	 
	 # set the items that were selected
	 $self _updateWidget [$self getVal]
      }
      $self _setState $_enabledState
   } else {
      $self _updateWidget [$self getVal]
   }
   $self next
}

##################
# Internal methods
##################
_UIT_MEnumGUI instproc bindButton1 {} {
        $self instvar _lstbox valueList
   
        set valList ""
	foreach idx [$_lstbox curselection] {
		lappend valList [lindex $valueList $idx]
	}
        $self setVal $valList
} 

_UIT_MEnumGUI instproc _setState {val} {
   $self instvar _lstbox _UIrep valueList
   if {[llength $valueList] <= 4} {
      # check buttons
      $_UIrep configure -labelstate $val
      set i 0
      set Frm [$_UIrep childsite]
      foreach n $valueList {
	 $Frm.r$i configure -state $val
	 incr i
      }
   } else {
      $_lstbox configure -labelstate $val
   }
}

_UIT_MEnumGUI instproc setLabel {s} {
   $self instvar _lbl _displayedOnce valueList _UIrep _lstbox
   set _lbl $s
   if $_displayedOnce {
      if {[llength $valueList] <= 4} {
	 $_UIrep configure -labeltext $s
      } else {
	 $_lstbox configure -labeltext $s
      }
   }
}

#################################
# Create a scrolledlistbox widget
#################################
_UIT_MEnumGUI instproc _makeLstBox {wdgt lbl} {
   global _UIT_DisplayAttr
   set lst [scrolledlistbox $wdgt -labeltext $lbl -exportselection 0\
		-labelpos nw -labelmargin 0 -vscrollmode static \
		-hscrollmode dynamic -textfont $_UIT_DisplayAttr(EntryFont) \
		-selectioncommand "$self bindButton1"]
   return $lst
}


###################################
# Override setVal if packed earlier
###################################
_UIT_MEnumGUI instproc setVal {val} {
  $self instvar _displayedOnce _valuePtr valueList
  
   if {$_displayedOnce} {
	$self _updateWidget $val
   } 
   $self next $val
}


#############################################
# Set _valuePtr from selected boolean widgets
#############################################
_UIT_MEnumGUI instproc setValPtr {} {
  global _UIT_g_wdgtVals

  $self instvar _valuePtr valueList
  
  set valList ""
  foreach v $valueList {
	if [cequal $_UIT_g_wdgtVals(${self}_$v) 1] {
		lappend valList $v
	}
  }
  $self setVal $valList
}
		

#########################
# Set widget as alignable
#########################
_UIT_MEnumGUI instproc _alignableWidget {} {
   return [$self set _UIrep]
}

################################################
# Method that modifies the valueList at run-time
################################################
_UIT_MEnumGUI instproc setValueList {valList} {
   $self instvar valueList displayList

   $self set valueList $valList
   $self updateDispList
   if {[array get displayList [$self getVal]] == {}} {
      $self setVal [lindex valList 0]
   }
}

###################################################
# Method that updates the displayList of the widget
# with the new valueList.
###################################################
_UIT_MEnumGUI instproc updateDispList {} {
   global _UIT_g_main
   $self instvar valueList displayList

#  get the displayList array indexed by valueList elements
   catch {unset displayList}
   foreach i $valueList {
      set displayList($i) [$_UIT_g_main catget $self $i $i]
   }
}


#########################
# Update widget selection
#########################
_UIT_MEnumGUI instproc _updateWidget {val} {
   global _UIT_g_wdgtVals

   $self instvar _valuePtr valueList _lstbox
   set dlen [llength $valueList]

   if {$dlen <= 4} {
         # clear previous selections
	 foreach v $valueList {
		set _UIT_g_wdgtVals(${self}_$v) 0
	 }
        
         # set current selections
	 foreach v $val {
		if {[set idx [lsearch -exact $valueList $v]] >= 0} {
	    		set _UIT_g_wdgtVals(${self}_$v) 1
               	} 
	 }
   } else {
        # clear perviously selected items
        $_lstbox selection clear 0 end

      	# set the items that were selected
      	foreach i $val {
	  	set idx [lsearch -exact $valueList $i]
                if {$idx >= 0} {
	    	    $_lstbox selection set $idx
		}
      	}
   }
}
