#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: menumjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:37  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.8  1998/03/26  20:01:07  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:04:01  Anthony_Hoffman]
#
# Revision 1.1.2.12  1998/03/16  20:09:20  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:05:59  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/02/13  22:27:57  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:23:15  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/12/31  18:28:08  Richard_Taft
# 	Changes due to first implementation of Java widget
# 	[1997/12/31  18:26:58  Richard_Taft]
# 
# Revision 1.1.2.9  1997/11/06  19:58:28  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:46  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/08/20  13:00:48  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.6 **
# 		** Merge revision:	1.1.2.7 **
# 	 	** End **
# 	Call resetVal from display to set _javaKnowsMe and sync
# 	up values between java & suit.
# 	[1997/07/24  19:44:30  Richard_Taft]
# 
# Revision 1.1.2.7  1997/08/18  17:11:16  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:42  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/07/22  21:42:28  Richard_Taft
# 	Added getVal and setVal
# 	[1997/07/22  21:38:09  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/18  19:54:51  Richard_Taft
# 	changed puts to putJava
# 	[1997/07/18  19:53:28  Richard_Taft]
# 
# Revision 1.1.2.4  1997/07/09  20:12:22  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:10:41  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/07/02  19:01:18  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:56:55  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/23  15:44:28  Deepa_Bachu
# 	Initial _UIT_MEnumJAVA class file.
# 	[1997/06/23  15:43:12  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: menumjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:37 $
# 

Class _UIT_MEnumJAVA -superclass _UIT_MEnumGeneric

# _UIT_MEnumJAVA instproc init {args} { eval $self next $args }

_UIT_MEnumJAVA instproc display {} {

   $self instvar _displayedOnce

    if { ! $_displayedOnce } {
       $self instvar valueIndex displayList valueList \
	   _lbl _helpTag _enabledState
       
	$self updateDispList
	set dList ""
	set dString ""
	foreach val $valueList {
	    # dString is used to send to JAVA
	    append dString "[safeXferString $displayList($val)] "

	    # dList is used in the search below
	    lappend dList [safeXferString $displayList($val)]
	}

	# Create list of indexes of the selected items
	set val [$self getVal]
	set idxLst ""
	foreach str $val {
	    set searchString [safeXferString $displayList($str)]
	    set idx [lsearch -exact $dList $searchString]
	    if {$idx >= 0} {
		lappend idxLst $idx
	    }
	}

	putJava "_UIT_MultiEnum $self [safeXferString $_lbl] \
	       $_enabledState [safeXferString $_helpTag] \
              \{ $dString \} \{ $idxLst \}"
	incr _displayedOnce
    } 
}

#############################################
# Set _valuePtr from selected boolean widgets
#############################################
_UIT_MEnumJAVA instproc setValPtr {} {
  global _UIT_g_wdgtVals

  $self instvar _valuePtr valueList

}

################################################
# Method that modifies the valueList at run-time
################################################
_UIT_MEnumJAVA instproc setValueList {valList} {
   $self instvar valueList displayList

   $self set valueList $valList
   $self updateDispList
}


_UIT_MEnumJAVA instproc setVal {val} {
    $self instvar _displayedOnce valueList displayList

    if { $_displayedOnce } {
 	set idx 0
 	foreach v $valueList {
 	    set foundIndex [lsearch -exact $val $v]
 	    putJava "$self setVal $idx [expr $foundIndex >= 0]"
 	    incr idx
 	}
	return $val
    } else {
	return [$self next $val]
    }
}



_UIT_MEnumJAVA instproc getVal {} {
    $self instvar _displayedOnce valueList displayList

    if { $_displayedOnce } {

	# Query java for the values of each item.
	putJava "$self getVal"

	# Java returns a list of indexes of selected items
	if { [ getJava selectedList ] < 0 } {
	    logMsg "Java Applet closed?"
	    error "Java Applet closed?"
	    return ""
	} else {
	    # Create a list of values of the selected items
	    set selValList {}
	    foreach idx $selectedList {
		lappend selValList [lindex $valueList $idx]
	    }

	    return $selValList
	}

    } else {
	# Java doesn't know the value,
	# we do!
	return [$self next]
    }
}


###################################################
# Method that updates the displayList of the widget
# with the new valueList.
###################################################
_UIT_MEnumJAVA instproc updateDispList {} {
   global _UIT_g_main
   $self instvar valueList displayList

   # get the displayList array indexed by valueList elements
   catch {unset displayList}
   foreach i $valueList {
      set displayList($i) [$_UIT_g_main catget $self $i $i]
   }
}

_UIT_MEnumJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}
