# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: numcur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:52  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.18  1999/10/13  20:12:53  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
#
# Revision 1.1.2.17  1998/03/16  20:09:21  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:02  William_Athanasiou]
#
# Revision 1.1.2.16  1998/02/26  21:35:49  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:08  William_Athanasiou]
# 
# Revision 1.1.2.15  1998/02/11  18:44:10  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:44  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/12/09  22:19:28  Todd_Moyer
# 	Added comments for the design doc.
# 	[1997/12/09  22:17:56  Todd_Moyer]
# 
# Revision 1.1.2.13  1997/09/02  17:48:33  Richard_Taft
# 	Made sure default value is set.
# 	[1997/09/02  17:45:03  Richard_Taft]
# 
# Revision 1.1.2.12  1997/08/28  13:49:19  Richard_Taft
# 	Changed the default validation from simply "numeric", which
# 	allowed only digits, to "real", which allows anything matching
# 	the regexp: {^\-?[0-9]*\.?[0-9]*$}
# 	[1997/08/28  13:47:08  Richard_Taft]
# 
# Revision 1.1.2.11  1997/08/18  17:11:16  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:44  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/07/22  18:05:39  William_Athanasiou
# 	Replaced length with width
# 	[1997/07/22  18:02:39  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/03/28  16:46:44  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:20  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/03/21  15:55:28  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:43  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/03/13  17:45:07  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:56  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/16  20:37:45  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:24  William_Athanasiou]
# 
# Revision 1.1.2.5  1997/01/16  14:15:43  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:10  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/12/09  16:16:36  William_Athanasiou
# 	added 'self next' to display to get read of widget data
# 	[1996/12/09  16:02:31  William_Athanasiou]
# 
# Revision 1.1.2.3  1996/10/01  13:31:39  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:29:05  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/09/24  19:58:05  William_Athanasiou
# 	initial version of implementation
# 	[1996/09/24  19:55:40  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: numcur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 

Class _UIT_NumberCURSES -superclass _UIT_NumberGeneric

_UIT_NumberCURSES instproc init {args} {
   eval $self next $args             ;# do parents init
   $self instvar _valuePtr min
   global _UIT_g_wdgtVals

   set $_valuePtr $min
}


#-------------------------------------------------
#@ Display CTK widgets.

_UIT_NumberCURSES instproc display {} {
   $self instvar _displayedOnce
   if {!$_displayedOnce} {
      incr _displayedOnce 

      $self instvar _valuePtr _parent _lbl width \
	    _UIrep _displayedOnce _isAlignable _window _enabledState
      global _UIT_g_wdgtVals
      
      set leaf      [lindex [split $self .] end]
      set container [$_parent set containWdgt]

      set _UIrep [entryfield $container.$leaf \
	    -labeltext $_lbl \
	    -textvariable $_valuePtr \
	    -validate real -width $width]
      if {[string match {_UIT_Across*} $_parent]} {
	 set side left
      } else {
	 set side top
      }
      pack $_UIrep -fill x -anchor w -padx 0 -side $side
      $self _setState $_enabledState

      set _isAlignable $_UIrep
      $_window _registerUImap $_UIrep $self
   }

   $self next
}

#-------------------------------------------------

_UIT_NumberCURSES instproc _setState {val} {
   [$self set _UIrep] configure -state $val -labelstate $val
}
