#!/usr/bin/otclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: numgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.5  1998/02/05  17:51:06  William_Athanasiou
# 	update from shared sandbox for BL15
# 	[1998/02/02  20:18:44  William_Athanasiou]
#
# Revision 1.1.2.6  1997/12/09  22:19:29  Todd_Moyer
# 	Force value to be an integer between min and max.
# 	[1997/12/09  22:16:56  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/07/22  18:10:44  William_Athanasiou
# 	must also set length=width
# 	[1997/07/22  18:09:34  William_Athanasiou]
# 
# Revision 1.1.2.4  1997/07/22  18:05:38  William_Athanasiou
# 	Check for length for backwards compatability
# 	[1997/07/22  18:04:56  William_Athanasiou]
# 
# 	changed length to width and set to reasonable default value
# 	[1997/07/22  17:59:05  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/01/16  14:15:44  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:15  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/08/30  18:41:06  Deepa_Bachu
# 	This file conatins the common methods of the Number object.
# 	[1996/08/30  17:35:15  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: numgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 


Class _UIT_NumberGeneric -superclass _UIT_SuperWdgt


#-------------------------------------------------

_UIT_NumberGeneric instproc init {args} {

   global  _UIT_g_wdgtVals
   
   # set defaults
   $self set min        1
   $self set max       10
   $self set increment  1
   $self set width     15
   
   eval $self next $args             ;# do parents init
   
   $self instvar width length
   if {[info exists length]} {
      set width $length
   } else {
      set length $width
   }
   set [$self set _valuePtr] [$self set min]
}


#-------------------------------------------------
#@ Set the widgets value, but make sure it's valid.
#@ If it's non-numeric or less than min, set it to min.
#@ If it's greater than max, set it to max.

_UIT_NumberGeneric instproc setVal {val} {
    $self instvar min max

    # if not integer, use min
    if {! [regexp {^[-+]?[0-9]+$} $val]} {
	return [$self next $min]
    }

    # if less than min, use min
    if {$val < $min} {
	return [$self next $min]
    }

    # if greater than max, use max
    if {$val > $max} {
	return [$self next $max]
    }

    return [$self next $val]
}

#-------------------------------------------------
