#!/usr/bin/owish
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: numgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:53  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.27  1999/10/13  20:12:55  Richard_Taft
# 	When calculating leaf, use end, not 1.  The tabbed widget requires
# 	more levels.
# 	[1999/10/12  14:36:17  Richard_Taft]
#
# 	Call _parent's packSide proc to find out the side (top or left)
# 	to pack from.  Don't check the parent's name, it may not tell
# 	[1999/10/11  20:03:38  Richard_Taft]
#
# Revision 1.1.2.26  1998/04/10  02:33:47  William_Athanasiou
# 	use display attr array
# 	[1998/04/10  02:26:41  William_Athanasiou]
#
# Revision 1.1.2.25  1998/03/16  20:09:22  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:07  William_Athanasiou]
# 
# Revision 1.1.2.24  1998/02/26  21:35:50  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:13  William_Athanasiou]
# 
# Revision 1.1.2.23  1998/02/11  18:44:11  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:47  William_Athanasiou]
# 
# Revision 1.1.2.22  1997/12/09  22:19:31  Todd_Moyer
# 	Added comments for the design doc.
# 	[1997/12/09  22:17:59  Todd_Moyer]
# 
# Revision 1.1.2.21  1997/09/15  20:05:37  Richard_Taft
# 	Changed algorithm that computes width of scale's label.
# 	It now takes negative numbers into account.
# 	[1997/09/15  20:01:08  Richard_Taft]
# 
# Revision 1.1.2.20  1997/08/28  13:49:18  Richard_Taft
# 	Changed the default validation from simply "numeric", which
# 	allowed only digits, to "real", which allows anything matching
# 	the regexp: {^\-?[0-9]*\.?[0-9]*$}
# 	[1997/08/28  13:47:59  Richard_Taft]
# 
# Revision 1.1.2.19  1997/08/19  20:28:54  William_Athanasiou
# 	setVal of number now works correctly when widget is a slider
# 	[1997/08/19  20:27:14  William_Athanasiou]
# 
# Revision 1.1.2.18  1997/08/18  17:11:17  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:46  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/07/22  18:05:39  William_Athanasiou
# 	Replaced length with width
# 	[1997/07/22  18:02:41  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/04/10  17:49:48  William_Athanasiou
# 	Change look of slider to facilitate layout issues
# 	[1997/04/10  17:43:34  William_Athanasiou]
# 
# Revision 1.1.2.15  1997/03/31  18:49:33  William_Athanasiou
# 	Add pad to bottom of scale widget, highlightthickness=2
# 	[1997/03/31  18:43:33  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/03/28  19:27:35  William_Athanasiou
# 	postpone UI creation until window display for performance reasons
# 	[1997/03/28  19:27:12  William_Athanasiou]
# 
# Revision 1.1.2.13  1997/03/28  16:46:45  William_Athanasiou
# 	Postpone UI creation until first display for performance reasons
# 	[1997/03/28  16:28:23  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/03/21  15:55:29  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:45  William_Athanasiou]
# 
# Revision 1.1.2.11  1997/03/13  17:45:08  William_Athanasiou
# 	Correct expansion of window behavior and packing
# 	[1997/03/13  17:43:58  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/03/07  19:08:09  William_Athanasiou
# 	Added geometry management for GUI
# 	[1997/03/07  19:05:42  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/01/16  20:37:42  William_Athanasiou
# 	Only pack the UIrep once
# 	[1997/01/16  20:30:29  William_Athanasiou]
# 
# Revision 1.1.2.8  1997/01/16  14:15:45  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:18  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/12/02  23:00:52  Todd_Moyer
# 	In display method call $self next to cause a read to occur.
# 	[1996/12/02  22:50:56  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/10/01  13:31:40  William_Athanasiou
# 	Fixed slight formatting problems
# 	[1996/10/01  13:29:12  William_Athanasiou]
# 
# Revision 1.1.2.5  1996/09/25  18:26:53  William_Athanasiou
# 	fixed rep of scale so label is not cut off
# 	[1996/09/25  18:25:51  William_Athanasiou]
# 
# Revision 1.1.2.4  1996/09/06  18:41:19  Todd_Moyer
# 	Use tree and call _UIT_g_main methods.
# 	[1996/09/06  18:30:45  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/03  20:22:53  Todd_Moyer
# 	Use _lbl instead of _lblTag.
# 	[1996/09/03  18:25:59  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:41:08  Deepa_Bachu
# 	This file conatins the GUI methods of the Number object.
# 	[1996/08/30  17:35:59  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: numgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 

Class _UIT_NumberGUI -superclass _UIT_NumberGeneric



_UIT_NumberGUI instproc init {args} {
   eval $self next $args             ;# do parents init
}


#-------------------------------------------------
#@ Display TK widgets.

_UIT_NumberGUI instproc display {} {
   $self instvar _displayedOnce

   if {!$_displayedOnce} {
      $self instvar min max increment width \
	  _valuePtr _lbl _UIrep _isAlignable _window _parent \
	  _numTicks _UIlbl _enabledState
      
      incr _displayedOnce
      set leaf      [lindex [split $self .] end]
      set container [[$self set _parent] set containWdgt]
        
      set _numTicks [expr ($max - $min) / $increment]
      if {$_numTicks > 100} {
	 set _UIrep [entryfield $container.$leaf -labeltext $_lbl \
	       -textvariable $_valuePtr -validate real -width $width]
      } else {
	 global _UIT_g_wdgtVals
	 set _UIrep [labeledwidget $container.$leaf -labeltext $_lbl \
	       -labelpos w -labelmargin 1]

	 set len 50
	 set cnt $_numTicks
	 while {$cnt > 0} {
	    incr len 25
	    incr cnt -50
	 }
	 set f [frame [$_UIrep childsite].f]
	 set s [scale $f.sc \
	       -from       $min \
	       -to         $max \
	       -resolution $increment \
	       -variable   $_valuePtr \
	       -command    "$self _showValue" \
	       -length     $len \
	       -showvalue false -orient horizontal \
	       -borderwidth 1 -highlightthickness 2 -relief sunken]

	 $self proc setVal {v} "$self next \$v; $self _showValue \$v"

	 #
	 # Compute the width of the label
	 #
	 if { abs($max) > abs($min) } {
	     set m abs($max)
	     set sign [expr ($max < 0)]
	 } else {
	     set m abs($min)
	     set sign [expr ($min < 0)]
	 }

	 if { $m == 0 } { set m 1 };	# rare case when range is 0-0

	 # c is number of digits + negative sign + 1 extra 
	 # ('cause last digit was still cut off!)
	 set c [ expr int( log10($m) ) + $sign + 1 ]

	 set _UIlbl [label $f.l \
			 -text [format "%-d" [set $_valuePtr]] -width $c]

	 pack $s -side left -fill x -expand 1
	 pack $_UIlbl -side left
	 pack $f -fill x -expand 1
      }
      set _isAlignable $_UIrep
      $_window _registerUImap $_UIrep $self

      pack $_UIrep -fill x -expand 0 -anchor w \
	  -padx 0 -side [$_parent packSide]
      $self _setState $_enabledState
   }

   $self next
}

#@ Only called from the common enable/disable procs in the CommonGUI class.

_UIT_NumberGUI instproc _setState {val} {
   $self instvar _UIrep _numTicks _UIlbl

   $_UIrep configure -labelstate $val
   if {$_numTicks > 100} {
      $_UIrep configure -state $val
   } else {
      global _UIT_DisplayAttr
      [$_UIrep childsite].f.sc configure -state $val
      $_UIlbl configure -foreground $_UIT_DisplayAttr($val)
   }
}

#-------------------------------------------------
#@ Display the current slider value.

_UIT_NumberGUI instproc _showValue {v} {
   $self instvar min _valuePtr
   upvar #0 $_valuePtr gval

   if {$v < $min} {
      set v $min
      set gval $min
   }

   [$self set _UIlbl] config -text [format "%-d" $v]
}

#-------------------------------------------------
