#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: numjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.8  1998/03/26  20:01:10  Anthony_Hoffman
# 	BL 16 shared sandbox submit
# 	[1998/03/25  19:04:09  Anthony_Hoffman]
#
# Revision 1.1.2.14  1998/03/16  20:09:23  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:11  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/02/13  22:27:58  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:23:18  William_Athanasiou]
# 
# Revision 1.1.2.12  1997/12/09  22:19:32  Todd_Moyer
# 	Added comments for the design doc.
# 	[1997/12/09  22:18:02  Todd_Moyer]
# 
# Revision 1.1.2.11  1997/11/06  19:58:27  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:49  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/08/22  18:46:19  William_Athanasiou
# 	Remove resetval call and correct display logic
# 	[1997/08/22  18:28:46  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/08/20  13:00:49  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Call resetVal from display to set _javaKnowsMe and sync
# 	up values between java & suit.
# 	[1997/07/24  19:42:33  Richard_Taft]
# 
# Revision 1.1.2.8  1997/08/18  17:11:18  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:48  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/07/21  18:19:03  Richard_Taft
# 	Fixed bug in setVal
# 	[1997/07/21  18:17:42  Richard_Taft]
# 
# Revision 1.1.2.6  1997/07/10  19:26:34  Richard_Taft
# 	Added getVal and setVal.
# 	Modified display to output creation information if _javaKnowsMe
# 	is false; display statement otherwise.
# 	[1997/07/10  18:47:20  Richard_Taft]
# 
# Revision 1.1.2.5  1997/07/09  20:12:23  Todd_Moyer
# 	Moved value to the end if display method.
# 	[1997/07/09  20:11:08  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/07/02  19:01:19  Deepa_Bachu
# 	Modified the creation code being sent to the applet.
# 	[1997/07/02  18:56:58  Deepa_Bachu]
# 
# Revision 1.1.2.3  1997/06/23  12:58:25  Deepa_Bachu
# 	Made modifications to the Tcl->Java communication.
# 	[1997/06/23  12:57:36  Deepa_Bachu]
# 
# Revision 1.1.2.2  1997/06/19  15:26:55  Deepa_Bachu
# 	Initial NumberJAVA class.
# 	[1997/06/19  15:25:37  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: numjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 


Class _UIT_NumberJAVA -superclass _UIT_NumberGeneric


#-------------------------------------------------

_UIT_NumberJAVA instproc init {args} {
    eval $self next $args             ;# do parents init
}


#-------------------------------------------------
#@ Tell the applet to display the widgets.

_UIT_NumberJAVA instproc display {} {
    $self instvar _displayedOnce _enabledState
    if { ! $_displayedOnce } {
	$self instvar length min max _lbl _helpTag increment _valuePtr
	upvar #0 $_valuePtr val
	
       putJava "_UIT_Number $self [safeXferString $_lbl] \
                 $_enabledState [safeXferString $_helpTag] \
                $length $min $max $increment $val" 
       incr _displayedOnce
    }
}


#-------------------------------------------------
#@ Get the current widget value from the applet.

_UIT_NumberJAVA instproc getVal {} {
    $self instvar _displayedOnce

    if { $_displayedOnce } {
	# Query java for the value
	putJava "$self getVal"
	if { [ getJava val ] < 0 } {
	    logMsg "Java Applet closed?"
	    error "Java Applet closed?"
	    return ""
	} else {
	    return $val
	}

    } else {
	# Java doesn't know the value,
	# we do!
	return [$self next]
    }
}

#-------------------------------------------------
#@ Set the current widget value in the applet.

_UIT_NumberJAVA instproc setVal {val} {
   set val [$self next $val]
   if { [$self set _displayedOnce] } {
      putJava "$self setVal $val"
   }
   return $val
}

#-------------------------------------------------
#@ enable/disable the widget
_UIT_NumberJAVA instproc _setState {val} { 
   if [cequal $val "disabled"] { 
      putJava "$self disable" 
   } else {
      putJava "$self enable"
   }
}
