# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: qtree.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/07/29  16:48:44  Chip_Maurer
# 	Code drop for sysconfig for baselevel Pre-BL12
# 	[1997/07/28  16:22:53  Chip_Maurer]
#
# Revision 1.1.2.4  1997/06/11  14:54:55  Richard_Taft
# 	Added optional argument to setVal.  If 1 will call setVal for nodes progeny
# 	as well.  Default is 0, only setVal for this node.
# 	[1997/06/11  14:47:52  Richard_Taft]
# 
# Revision 1.1.2.3  1997/06/03  16:16:14  Richard_Taft
# 	Added findNode
# 	[1997/06/03  15:51:20  Richard_Taft]
# 
# Revision 1.1.2.2  1997/04/28  17:58:42  Todd_Moyer
# 	  Create
# 	[1997/04/25  20:07:08  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: qtree.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 


# Like a _UIT_Tree except all contained in one object instead of one object
#   per node.  As a result, this one will be quicker but less flexible and
#   attributes must be the same for each node.

Class _UIT_QuikTree



# ====================== constructor/destructor =============================

# Create a tree with only a root node and return the root's ID.
# Each att can be a list pair with second value being default value.
#  ex:  {name {citizenship US} age}
#  If not specified, default values will be {}.

_UIT_QuikTree instproc init {attList} {
    $self instvar _atts _links _nextID _numNodes _root _vals

    # store default values for attributes
    foreach a $attList {
        if {[llength $a] > 1} {
            set att   [lindex $a 0]
            set deflt [lindex $a 1]
            set _atts($att) $deflt
        } else {
            set _atts($a) ""
        }
    }

    set     _root       0
    $self   reset
    return $_root
}


# ====================== public methods =============================

# Add the specified number of child nodes to the spcified node at the
#   specified position with the default attribute values.
# Returns the IDs of the kids added.

_UIT_QuikTree instproc addKids {nodeID {number 1} {at end}} {
    $self instvar _atts _links _nextID _numNodes _root _vals

    incr _numNodes $number
    
    set names ""
    for {} {$number >=1} {incr number -1} {
        set _links($_nextID,par)   $nodeID
        set _links($_nextID,kids)  ""
	lappend names $_nextID
        foreach a [array names _atts] {
            set _vals($_nextID,$a) $_atts($a)
        }
        incr _nextID
    }
    # @@@ puts "names |$names|"
    # @@@ puts "eval linsert \$_links($nodeID,kids) $at $names|"
    # @@@ puts "[eval linsert \$_links($nodeID,kids) $at $names]|"
    # if {[cequal $_links($nodeID,kids) ""]} {
	# set _links($nodeID,kids) $names
    # } else {
	set _links($nodeID,kids) \
		[eval linsert \$_links($nodeID,kids) $at $names]
    # }
    return $names
}


# ---------------------------------------------------

# Delete specified node and all its children.

_UIT_QuikTree instproc deleteBranch {nodeID} {
    $self instvar _links _nextID _numNodes _root _vals

    if {$nodeID == $_root} {
        set msg "_UIT_QuikTree::deleteBranch Cann't delete root.\n"
        append msg "If you want to delete whole tree, use destroy."
        error $msg
    }

    # remove node from parent's kid list
    set par     $_links($nodeID,par)
    set parKids $_links($par,kids)
    set idx [lsearch -exact $parKids $nodeID]
    if {$idx < 0} {
        set msg "_UIT_QuikTree::deleteBranch Cann't find node in "
        append msg "parent's kid list."
        error $msg
    }
    set _links($par,kids) [lreplace $parKids $idx $idx]

    $self _deleteBranch $nodeID
}


# ---------------------------------------------------

_UIT_QuikTree instproc dump {{nodeID ""} {indent ""}} {
    $self instvar _root

    if {[cequal $nodeID ""]} {
	set nodeID $_root
    }
    $self _dumpNode $nodeID "$indent"
    foreach k [$self set _links($nodeID,kids)] {
	$self dump $k "$indent   "
    }
    if {$nodeID == $_root} {
	puts "\n"
    }
}


# ---------------------------------------------------
# Do a depth-first search starting at the specified node for a node
#   matching the specified att-vals.
# Returns the first one found or -1 if not found.

_UIT_QuikTree instproc findNode {nodeID targetAttValLst} {
    $self instvar _root

    if {[cequal $nodeID ""]} {
	set nodeID $_root
    }

    set found 1
    foreach a $targetAttValLst {
	set att   [lindex $a 0]
	set val [lindex $a 1]
	set curVal [$self getVal $nodeID $att]

	if { ![ cequal $curVal $val ] } {
	    set found 0
	}
    }


    if { ! $found } {
	foreach kid [$self set _links($nodeID,kids)] {
	    set node [$self findNode $kid $targetAttValLst]
	    if { $node != -1 } {
		return $node
	    }
	}
    } else {
	return $nodeID
    }

    return -1

#    foreach k [$self set _kids] {
#        if {[cequal [$k set $att] $val]} {
#	    return $k
#	}
#    }
#    return ""
}


# ---------------------------------------------------

# Get a list of the IDs of the specified node's children.

_UIT_QuikTree instproc getKids {nodeID} {
    $self set _links($nodeID,kids)
}


# ---------------------------------------------------

# Get the ID of the specified node's parent.  Will be {} for the root.

_UIT_QuikTree instproc getParent {nodeID} {
    $self set _links($nodeID,par)
}


# ---------------------------------------------------

# Get the root ID.

_UIT_QuikTree instproc getRoot {} {
    $self set _root
}


# ---------------------------------------------------

# Get the specified attribute value for the specified node.

_UIT_QuikTree instproc getVal {nodeID att} {
    $self instvar _vals

    if {! [info exists _vals($nodeID,$att)]} {
	set msg "_UIT_QuikTree::getVal there either isn't a node $nodeID "
	append msg "or it doesn't have a $att attribute."
	error $msg
    }
    set _vals($nodeID,$att)
}


# ---------------------------------------------------
# Reset this tree back to where it only has a root with default values.

_UIT_QuikTree instproc reset {} {
    $self instvar _atts _links _nextID _numNodes _root _vals

    set _nextID     1
    set _numNodes   1
    catch {unset _links}
    catch {unset _vals}
    set _links($_root,par)  ""
    set _links($_root,kids) ""

    # set the root's attribute values to default values
    foreach a [array names _atts] {
        set _vals($_root,$a) $_atts($a)
    }
}


# ---------------------------------------------------
# Set the specified attribute value for the specified node.

_UIT_QuikTree instproc setVal {nodeID att val {recursive 0}} {
    $self instvar _vals

    if {! [info exists _vals($nodeID,$att)]} {
	set msg "_UIT_QuikTree::setVal there either isn't a node $nodeID "
	append msg "or it doesn't have a $att attribute."
	puts "=========================== ERROR ==========================="
	puts "$self setVal '$nodeID' '$att' '$val'"
	$self _dump
	puts "=========================== END ==========================="
	error $msg
    }
    set _vals($nodeID,$att) $val

    if {$recursive} {
	set kids [$self getKids $nodeID]
	foreach kid $kids {
	    $self setVal $kid $att $val 1
	}
    }
}


# ---------------------------------------------------
# Set the specified attribute value for the specified node and all its
#  children.

_UIT_QuikTree instproc setValBranch {nodeID att val} {
    foreach k [$self set _links($nodeID,kids)] {
        $self setValBranch $k $att $val
    }
    $self set _vals($nodeID,$att) $val
}



# ====================== private methods =============================

# Delete specified node and all its children, but don't worry about
#  resetting it's parent's kid list.  That will get cleared in caller.

_UIT_QuikTree instproc _deleteBranch {nodeID} {
    $self instvar _atts _links _numNodes _vals

    foreach k [$self set _links($nodeID,kids)] {
        $self _deleteBranch $k
    }
    unset _links($nodeID,par)
    unset _links($nodeID,kids)
    foreach a [array names _atts] {
        unset _vals($nodeID,$a)
    }
    incr _numNodes -1
}

# ---------------------------------------------------

_UIT_QuikTree instproc _dump {{nodeID ""} {indent ""}} {
    $self instvar _root _links

    if {[cequal $nodeID ""]} {
	set nodeID $_root
    }
    if {$nodeID == $_root} {
	puts "\n$indent$self"
	foreach v [lsort [$self info vars]] {
	    if {[cequal $v _vals]} {
		continue
	    }
	    $self instvar $v
	    if {[array exists $v]} {
		puts "$indent   $v\t array..."
		foreach key [lsort [array names $v]] {
		    puts "$indent     $key\t    [set ${v}($key)]"
		}
	    } else {
		puts "$indent   $v\t [set $v]"
	    }
	}
    }
    $self _dumpNode $nodeID "$indent"
    foreach k $_links($nodeID,kids) {
	$self _dump $k "$indent   "
    }
    if {$nodeID == $_root} {
	puts "\n"
    }
}


# ---------------------------------------------------

_UIT_QuikTree instproc _dumpNode {nodeID {indent ""}} {
    $self instvar _atts _vals

    puts "\n$indent$nodeID"

    # dump all values
    foreach att [lsort [array names _atts]] {
	puts "$indent$att\t$_vals($nodeID,$att)"
    }
}


# ---------------------------------------------------

# unit test methods.
# do:
#         _UIT_QuikTree quikTreeTest {name {fate save} level}
#         quikTreeTest _unitTest
# output should be:

_UIT_QuikTree instproc _unitTest {} {

    # create tree
    # Root
    #   L1
    #     L1a
    #     L1b
    #     L1c
    #   R1
    #     R1x
    #     R1y

    puts "AAA"
    $self _dump

    set rt [$self getRoot]
    $self setVal $rt name Root
    set newKids [$self addKids $rt 2]

    puts "BBB"
    $self _dump

    set L1 [lindex $newKids 0]
    set R1 [lindex $newKids 1]
    $self setVal $L1 name L1
    $self setVal $R1 name R1
    foreach k $newKids {
	$self setVal $k level 1
    }

    puts "CCC"
    $self _dump

    set L2c [$self addKids $L1]
    set L2a [$self addKids $L1 1 0]
    set L2b [$self addKids $L1 1 1]
    $self setVal $L2a name  L2a
    $self setVal $L2a level 2
    $self setVal $L2b name  L2b
    $self setVal $L2b level 2
    $self setVal $L2c name  L2c
    $self setVal $L2c level 2
    set newKids [$self addKids $R1 2]
    set R2x [lindex $newKids 0]
    set R2y [lindex $newKids 1]
    $self setVal $R2x name R2x
    $self setVal $R2y name R2y
    foreach k $newKids {
	$self setVal $k level 2
    }
    $self setValBranch $R1 fate cut

    # print various info
    puts "DDD"
    $self dump
    puts "L1 parent [$self getParent $L1]"
    puts "L1 kids   [$self getKids   $L1]"
    puts "L1 fate   [$self getVal    $L1 fate]"
    puts "R2y parent [$self getParent $R2y]"
    puts "R2y kids   [$self getKids   $R2y]"
    puts "R2y fate   [$self getVal    $R2y fate]"


    # trim right branch and print all
    $self deleteBranch $R1
    $self _dump [$self getRoot]

    puts "everything's OK"
}

# ====================== end =============================

