# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: rec.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:36  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.7  1998/07/16  17:47:46  Sai_Akkapeddi
# 	Code Drop for baselevel BL17
# 	[1998/07/15  17:20:31  Sai_Akkapeddi]
#
# Revision 1.1.2.17  1998/06/26  21:41:09  Todd_Moyer
# 	Added a _dump method to help with debugging.
# 	[1998/06/26  20:57:16  Todd_Moyer]
# 
# Revision 1.1.2.16  1997/12/31  19:55:04  Todd_Moyer
# 	Fixed cache and recall methods.
# 	[1997/12/31  19:53:38  Todd_Moyer]
# 
# Revision 1.1.2.15  1997/08/19  18:33:21  Todd_Moyer
# 	Added cacheCurrRec and recallCurrRec methods.
# 	[1997/08/19  18:21:00  Todd_Moyer]
# 
# Revision 1.1.2.14  1997/03/26  19:56:07  Todd_Moyer
# 	Delete write method - rsrc now pulls data from rec.
# 	Added error checking to getVal, getVals, setVal and unsetVal.
# 	getVals now returns values in array-get format.
# 	Read method subsumed reset method.
# 	[1997/03/26  19:05:51  Todd_Moyer]
# 
# Revision 1.1.2.13  1997/01/30  22:48:08  Todd_Moyer
# 	Simplified save and restore methods.
# 	[1997/01/30  22:47:22  Todd_Moyer]
# 
# Revision 1.1.2.12  1997/01/30  21:18:00  Todd_Moyer
# 	Changed calls to getTempID and getPermID to getNumRecID and getDataRecID.
# 	[1997/01/30  20:27:26  Todd_Moyer]
# 
# Revision 1.1.2.11  1997/01/27  22:54:36  Deepa_Bachu
# 	registered the Rec object with State.
# 	[1997/01/27  22:51:05  Deepa_Bachu]
# 
# Revision 1.1.2.10  1997/01/22  22:41:41  Todd_Moyer
# 	Change save method back to returning a list.
# 	[1997/01/22  22:39:55  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/01/20  20:08:07  Todd_Moyer
# 	Register object with $main so it's state is saved.
# 	Method save now returns a command that calls it's own restore method.
# 	[1997/01/20  20:07:26  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/01/16  21:26:43  Todd_Moyer
# 	Added getRecID method.
# 	[1997/01/16  21:26:11  Todd_Moyer]
# 
# Revision 1.1.2.7  1997/01/16  14:15:49  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:29  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/06  22:14:28  Todd_Moyer
# 	Added save and restore methods.
# 	[1997/01/06  21:26:09  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/12/04  19:20:33  Todd_Moyer
# 	Return record ID from write.
# 	[1996/12/04  19:19:53  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/12/02  23:00:53  Todd_Moyer
# 	Fixed bug in write.
# 	[1996/12/02  22:58:21  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/11/27  23:22:48  Todd_Moyer
# 	Rewrote much of this class.
# 	[1996/11/27  23:05:48  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/11/11  20:57:33  Todd_Moyer
# 	This class holds a copy of a resource's record in a more accessable form
# 	  than it is in the resource.  This class is intended for use only
# 	  for records that are actively being worked on.  Creating an object has
# 	  overhead that makes large numbers of objects too inefficient to be
# 	  practical.
# 	[1996/11/11  20:56:26  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: rec.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:36 $
# 


# An expanded record holds a copy of a table record or the group record.
#   It also has a pointer back to the resource and row ID.


Class _UIT_Rec



# ---------------------------------------------------
# Create a buffer to hold a resource's record so it can be worked on
#   conveniently .
# This record must be "reset" before it can be operated on.

_UIT_Rec instproc init {rsrc} {
    global        _UIT_g_main
    $self instvar _cache _data

    $self set _rsrc  $rsrc
    $self set _recID "uninit"
    array set _cache ""
    array set _data  ""
}


# ---------------------------------------------------
# Remember the current record values.

_UIT_Rec instproc cacheCurrRec {} {
    $self instvar _cache _data

    array set _cache [array get _data]
}


# ---------------------------------------------------
# Get the ID to indicate which record this is an expansion of.

_UIT_Rec instproc getRecID {} {
    $self set _recID
}


# ---------------------------------------------------
# Get the list of tags.  For fixed tags, such as in tables and groups, can get
#   these from the resource.

_UIT_Rec instproc getTags {} {
    $self instvar _data

    array names _data
}


# ---------------------------------------------------
# Fetch the specified value.

_UIT_Rec instproc getVal {tag} {
    $self instvar _data

    if {! [info exists _data($tag)]} {
	set msg "_UIT_Rec::getVal  Error trying to read nonexistent attribute "
	append msg "$tag from record $self.\n"
	append msg "Valid attributes are [array names _data].\n"
	error $msg
    }
    set _data($tag)
}


# ---------------------------------------------------
# Return the current tags and values in array-get format.

_UIT_Rec instproc getVals {} {
    $self instvar _data

    if {[cequal [$self set _recID] uninit]} {
	set msg "_UIT_Rec::getVals  Trying get values from an "
	append msg "uninitialized record.\n"
	error $msg
    }
    array get _data
}


# ---------------------------------------------------
# Set or reset this record's values from the specified resource record.
# Also keep track of the record ID.  If the ID is non-numeric,
# this will be considered a new record without a corresponding record
# in the resource.

_UIT_Rec instproc read {recID} {
    $self instvar _rsrc
    $self instvar _recID
    $self instvar _data

    $self set _recID $recID
    # setting an array doesn't clear out values of other indecies
    if {[array exists _data]} {
	unset _data
    }
    $_rsrc getRec $_recID _data
}


# ---------------------------------------------------
# Reset the current record's values from a previously cached state.

_UIT_Rec instproc recallCurrRec {} {
    $self instvar _cache _data

    array set _data [array get _cache]
}


# ---------------------------------------------------
# Set the state of this object from a list that was previously
# generated in a call to the "save" method.
# Return restored record ID.

_UIT_Rec instproc restore {savedLst} {
    $self instvar _data
    $self instvar _recID
    $self instvar _rsrc

    lassign $savedLst recID data

    # ask resource if it wants to convert the ID
    set _recID [$_rsrc getRestoreRecID $recID]

    # fetch data saved in array-get format
    array set _data $data
    set _recID
}


# ---------------------------------------------------
# Return a list that represents the current state of this record.
# This list can be given to the retore method to restore this state.
# This is intended for the web (CGI) where the state is lost between
# pages.

_UIT_Rec instproc save {} {
    $self instvar _data

    # ask resource if it wants to convert the ID
    set lst [[$self set _rsrc] getSaveRecID [$self set _recID]]

    # save data in array-get format
    lappend lst [array get _data]
    # @@@ puts "saved |$lst|"
    set lst
}


# ---------------------------------------------------
# Set the ID to indicate which record this is an expansion of.
# This is particularly useful when assigning an ID to a record
# that is about to be added.

_UIT_Rec instproc setRecID {recID} {
    $self set _recID $recID
}


# ---------------------------------------------------
# Set the specified value.

_UIT_Rec instproc setVal {tag val} {
    $self instvar _data

    if {! [info exists _data($tag)]} {
	set msg "_UIT_Rec::setVal  Error trying to set nonexistent attribute "
	append msg "$tag in record $self.\n"
	append msg "Valid attributes are [array names _data].\n"
	error $msg
    }
    set _data($tag) $val
}


# ---------------------------------------------------
# Delete the specified value.

_UIT_Rec instproc unsetVal {tag} {
    $self instvar _data

    if {! [info exists _data($tag)]} {
	set msg "_UIT_Rec::unsetVal  Error trying to unset nonexistent "
	append msg "attribute $tag in record $self.\n"
	append msg "Valid attributes are [array names _data].\n"
	error $msg
    }
    unset _data($tag)
}


# =================== private methods ===============

# Dump current state to stdout.

_UIT_Rec instproc _dump {{indent ""}} {
    $self instvar _data _cache

    puts "\n$indent$self"
    puts "$indent  _recID  [$self set _recID]"
    puts "$indent  _data   [array get _data]"
    puts "$indent  _cache  [array get _cache]"
    puts ""
}

# ===================================================
