# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: restree.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:38  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.10.1  2000/09/06  19:34:36  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.17  2000/07/31  17:45:21  Todd_Moyer
# 	Removed obsolete code: findResrcAtt and write.
#
# Revision 1.1.2.16  1999/12/15  14:33:46  Todd_Moyer
# 	Moved 'initFetch' arg from 'read' to 'init'.
#
# Revision 1.1.2.15  1999/11/04  21:16:07  Omar_Ortiz
# 	Made changes to the "_UIT_ResrcTree instproc addResrc"
# 	and "_UIT_ResrcTree instproc read" to handle the
# 	"initFetch" argument.
#
# Revision 1.1.2.14  1997/09/25  15:47:25  William_Athanasiou
# 	Remove n*n algorithim and replace with array lookup
# 	[1997/09/25  15:47:02  William_Athanasiou]
#
# Revision 1.1.2.13  1997/08/19  18:33:23  Todd_Moyer
# 	Report read errors instead of flagging them as system errors.
# 	Commented out obsolete write method.
# 	[1997/08/19  18:27:42  Todd_Moyer]
# 
# Revision 1.1.2.12  1997/03/26  19:56:08  Todd_Moyer
# 	Always return the resource when doing an addResrc.
# 	Used to return rec buf most of the time, but now
# 	we're hiding the rec buf inside the resource.
# 	[1997/03/26  19:09:18  Todd_Moyer]
# 
# Revision 1.1.2.11  1997/01/30  16:08:06  William_Athanasiou
# 	Removed all reference to 'main' and replaced w/ _UIT_g_main
# 	[1997/01/30  16:06:07  William_Athanasiou]
# 
# Revision 1.1.2.10  1997/01/16  14:38:07  William_Athanasiou
# 	Fixed namespace issues by adding _UIT_ to classes and globals
# 	[1997/01/16  14:37:19  William_Athanasiou]
# 
# Revision 1.1.2.9  1997/01/15  19:27:30  Todd_Moyer
# 	Create resource objects with a known name instead of a generated one.
# 	[1997/01/15  19:25:57  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/01/10  16:20:55  Deepa_Bachu
# 	Used "gensym" instead of "make".
# 	[1997/01/10  16:18:59  Deepa_Bachu]
# 
# Revision 1.1.2.7  1996/12/02  23:00:55  Todd_Moyer
# 	Fixed small bug.
# 	[1996/12/02  22:59:34  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/11/27  23:22:50  Todd_Moyer
# 	addRsrc now takes a type (Group or _UIT_Table) in addition to a name.
# 	  It also returns a pointer to the resource if no attribute is given,
# 	  or the resource's buffer if one is.
# 	GetRecs and setRecs changed to read and write and made to be
# 	  not file-specific.
# 	[1996/11/27  23:20:03  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/10/23  14:40:05  Todd_Moyer
# 	Added a check to make sure the resource has at least one record.
# 	Change file dataID to allow for Unix file specifiers.
# 	[1996/10/23  14:38:03  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/24  21:03:33  Todd_Moyer
# 	Added setRecs method.
# 	[1996/09/24  20:53:05  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/09  19:15:53  Todd_Moyer
# 	Added findResrcAtt method.
# 	[1996/09/09  19:14:26  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/09/06  18:41:41  Todd_Moyer
# 	Created resource tree for communications with the data layer.
# 	[1996/09/06  18:31:01  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: restree.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:38 $
# 

# Resource tree for communications with the data layer.
Class _UIT_ResrcTree -superclass _UIT_Tree


# ---------------------------------------------------
_UIT_ResrcTree instproc init {{impArg ""}} {
    $self next
    $self set _imp $impArg
}


# ---------------------------------------------------
# Check if the specified resource is in this tree and add it if not.
# The resID must contain a type (must be "Table" or "Group"), resource name,
# and optionally, an attribute name.
# If the resID has an attribute name, return the resource's record buffer.
# Otherwise, return the resource itself.

_UIT_ResrcTree instproc addResrc {resID} {
   _UIT_ResrcTree instvar _resTreeLst
   global _UIT_g_main

    lassign $resID type res attr initFetch
    # Makes sure there is a default value the first time.
    #   If not, default to reading initial values.
    if { ! [cequal $initFetch "0"]} {
        set initFetch 1
    }
 
    if {! ([cequal $type "Table"] || [cequal $type "Group"])} {
	set msg "Error - _UIT_ResrcTree::addResrc the type must be _UIT_Table "
	append msg "or _UIT_Group (case sensitive).\n  $type was given."
	error $msg
    }

    # look to see if the resource is already there
    if [info exists _resTreeLst($res,$type)] {
       return $_resTreeLst($res,$type)
    }

    # the resource isn't here; add it
    set rsrcObj [_UIT_${type}[$self set _imp] ${_UIT_g_main}.$res $res \
		     $initFetch]
    $self addSubtree $rsrcObj
    set _resTreeLst($res,$type) $rsrcObj
    
    return $rsrcObj
}


# ---------------------------------------------------
# Fetch the records for the resources.

_UIT_ResrcTree instproc read {} {
    set stat {}
    foreach k [$self set _kids] {
	set s [$k read]
	if {! [cequal $s ""]} {
	    lappend stat $s
	}
    }
    return $stat
}


# ==================================================
