# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: rsrc.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.6  1998/12/02  14:08:29  Omar_Ortiz
# 	Code drop for baselevel 21
# 	[1998/12/01  21:11:50  Omar_Ortiz]
#
# Revision 1.1.2.14  1998/11/30  21:52:10  Todd_Moyer
# 	Allow for manual override on error reporting.
# 	[1998/11/30  21:51:11  Todd_Moyer]
# 
# Revision 1.1.2.13  1997/08/19  18:33:24  Todd_Moyer
# 	Added a validate record method.
# 	Added call throughs to the recbufs cacheCurrRec, recallCurrRec and
# 	validateAtt methods.
# 	[1997/08/19  18:18:55  Todd_Moyer]
# 
# Revision 1.1.2.12  1997/03/26  19:56:10  Todd_Moyer
# 	Make modify method virtual.
# 	Get rid of setRec and write methods.
# 	Make validate method protected and rename _validate.
# 	Get rid of getRecBuf method as part of effort to make rec buf
# 	internal to resource.
# 	Added _cvtArr2Lst and _cvtLst2Arr private methods to convert
# 	between records in list and array form.
# 	[1997/03/26  18:54:19  Todd_Moyer]
# 
# Revision 1.1.2.11  1997/01/30  22:48:09  Todd_Moyer
# 	Added default getSaveRecID and getRestoreRecID methods.
# 	[1997/01/30  22:42:25  Todd_Moyer]
# 
# Revision 1.1.2.10  1997/01/30  21:18:02  Todd_Moyer
# 	Moved getTempID and getPermID to Table and changed names to
# 	  getNumRecID and getDataRecID.
# 	[1997/01/30  20:29:38  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/01/16  15:55:34  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.7 **
# 		** Merge revision:	1.1.2.8 **
# 	 	** End **
# 	Fixed minor bug.
# 	[1997/01/16  15:48:13  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/01/16  15:45:25  William_Athanasiou
# 	update namespace changes
# 	[1997/01/16  15:44:57  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/16  14:31:39  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.5 **
# 		** Merge revision:	1.1.2.6 **
# 	 	** End **
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:33  William_Athanasiou]
# 
# Revision 1.1.2.6  1997/01/15  21:03:27  Todd_Moyer
# 	Added getVal and setVal methods.
# 	[1997/01/15  21:02:54  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/01/06  22:14:29  Todd_Moyer
# 	Added getParmID and getTempID methods.
# 	[1997/01/06  21:28:26  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/11/27  23:22:51  Todd_Moyer
# 	Created the Table and Group subclasses and move a lot of
# 	functionality there.
# 	[1996/11/27  23:06:58  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/11/22  22:35:03  William_Athanasiou
# 	Updated
# 	[1996/11/22  22:34:35  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/11/11  20:57:36  Todd_Moyer
# 	This class holds the data of a one record group or an N record table
# 	  in an efficient manor.  To actually read or write the values of the
# 	  records, though, the row being worked on should be moved into a "rec"
# 	  object.
# 	This class is abstract; individual implementations of the namespace API
# 	  need to subclass it.
# 	[1996/11/11  20:55:07  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: rsrc.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


# A resource is either a _UIT_Table or _UIT_Group.


Class _UIT_Rsrc -superclass _UIT_Tree

# ---------------------------------------------------

_UIT_Rsrc instproc init {type dataID} {
    eval $self next
    $self set _type          $type
    $self set _dataID        $dataID
    $self set _dispError 1
    # need to set atts during read
    $self set _atts {}
    $self set _recBuf [_UIT_Rec gensym $self]
}


# ---------------------------------------------------

_UIT_Rsrc instproc destroy {} {
    [$self set _recBuf] destroy
    $self next
}


# ===================================================
# Abstract methods.

# ---------------------------------------------------
# Set the rec buffer to a given record's values.

_UIT_Rsrc instproc buffer {id} {
    error "each subclass of _UIT_Rsrc needs an implementation of buffer method."
}

# ---------------------------------------------------
# Load the given record into the given array.

_UIT_Rsrc instproc getRec {id arrName} {
    error "each subclass of _UIT_Rsrc needs an implementation of getRec method."
}

# ---------------------------------------------------
# Validate the recBuf values, and if OK, write them into this object and the
#   data layer.
#   If any step fails, display an error msg and return a list of error codes.
#   If everything is OK, return "".

_UIT_Rsrc instproc modify {} {
    error "each subclass of _UIT_Rsrc needs an implementation of modify method."
}

# ---------------------------------------------------
# Read the data from the data layer.

_UIT_Rsrc instproc read {} {
    error "each subclass of _UIT_Rsrc needs an implementation of read method."
}


# ===================================================
# public methods.

# ---------------------------------------------------
# Remember the current record.

_UIT_Rsrc instproc cacheCurrRec {} {
    [$self set _recBuf] cacheCurrRec
}


# ---------------------------------------------------
# Get the ID of this resource.

_UIT_Rsrc instproc getDataID {} {
    $self set _dataID
}


# ---------------------------------------------------
# As a default, assume the record ID doesn't need to be converted.
#   Used by UIT_Rec's save/restore methods.

_UIT_Rsrc instproc getRestoreRecID {recID} {
    set recID
}


# ---------------------------------------------------
# As a default, assume the record ID doesn't need to be converted.
#   Used by UIT_Rec's save/restore methods.

_UIT_Rsrc instproc getSaveRecID {recID} {
    set recID
}


# ---------------------------------------------------
# Get Table, Group or any type added later.

_UIT_Rsrc instproc getType {} {
    $self set _type
}


# ---------------------------------------------------
# Get the specified attribute value for the current record.

_UIT_Rsrc instproc getVal {tag} {
    [$self set _recBuf] getVal $tag
}


# ---------------------------------------------------
# Reset the current record's values from a previously cached state.

_UIT_Rsrc instproc recallCurrRec {} {
    [$self set _recBuf] recallCurrRec
}


# ---------------------------------------------------
# Should errors be displayed automatically in an infoMsg?
#   Parameter must be 1 (yes) or 0 (no).

_UIT_Rsrc instproc displayErrors {setting} {
    $self instvar _dispError

    if {[cequal $setting 0]} {
	set _dispError 0
    } else {
	set _dispError 1
    }
}


# ---------------------------------------------------
# Set the specified attribute value for the current record.

_UIT_Rsrc instproc setVal {tag val} {
    [$self set _recBuf] setVal $tag $val
}


# ---------------------------------------------------
# Validate the specified attribute value in the context of the current record.

_UIT_Rsrc instproc validateVal {tag val} {
    $self instvar _recBuf

    # save old value from record buffer
    set oldVal [$_recBuf getVal $tag]

    # set new value in record buffer
    $_recBuf setVal $tag $val

    # do validation
    set stat [$self validate]

    # restore old value
    $_recBuf setVal $tag $oldVal

    return $stat
}


# ===================================================
# protected methods.

# ---------------------------------------------------
# Convert a record in array form to one in list form.

_UIT_Rsrc instproc _cvtArr2Lst {arrName lstName} {
    upvar $arrName  arr
    upvar $lstName  lst
    $self instvar   _atts

    set lst ""
    foreach att $_atts {
	if {[info exists arr($att)]} {
	    lappend lst $arr($att)
	} else {
	    set msg "_UIT_Rsrc::_cvtArr2Lst The record does not have a "
	    append msg "$_atts attribute.\n"
	    append msg "It's tags and values are:  [array get arr]."
	    error $msg
	}
    }
}



# ---------------------------------------------------
# Convert a record in list form to one in array form.

_UIT_Rsrc instproc _cvtLst2Arr {lstName arrName} {
    upvar $arrName  arr
    upvar $lstName  lst
    $self instvar   _atts

    if {[llength $_atts] != [llength $lst]} {
	set msg "_UIT_Rsrc::_cvtLst2Arr there are [llength $_atts] attributes "
	append msg "and [llength $lst] values.\n"
	append msg "There needs to be the same number of each."
	append msg "Check that your data and data definition match."
	error $msg
    }
    set i 0
    foreach att $_atts {
	set arr($att) [lindex $lst $i]
	incr i
    }
}



# ======================= Pure Virtual Procs ============================

_UIT_Rsrc instproc validate {} {
    pureVirtual _UIT_Rsrc validate
}

# ===================================================

