#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: scriptor.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  2001/09/24  17:33:23  Richard_Taft
# 	Fix for QAR 85112
#
# Revision 1.1.4.2  2000/09/21  19:50:33  Peter_Wolfe
# 	QAFFA code drop for yankee bl2
#
# Revision 1.1.2.7  2000/09/12  19:51:04  Todd_Moyer
# 	Added checks around sourcing playback file.
#
# Revision 1.1.2.6  2000/09/08  19:19:49  Todd_Moyer
# 	Override bgerror in script playback to avoid loss of control.
#
# Revision 1.1.2.5  2000/06/07  20:00:11  Todd_Moyer
# 	Moved ExitCB to end.
#
# Revision 1.1.2.4  2000/05/31  20:49:43  Todd_Moyer
# 	Added exit checking hook.
#
# Revision 1.1.2.3  2000/04/20  21:13:32  Todd_Moyer
# 	Minor fix for script recording.
#
# Revision 1.1.2.2  2000/04/18  14:12:51  Todd_Moyer
# 	Added _wait call for playback.
#
# Revision 1.1.2.1  2000/04/12  18:41:49  Todd_Moyer
# 	Created, primarily to automate testing.
# 	[2000/04/12  18:38:18  Todd_Moyer]
#
# $EndLog$
# 
# @(#)$RCSfile: scriptor.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


# Orchestrates the recording or playing of a suitlet's execution.

Class _UIT_Scriptor


# Need this switch and proc to figure if ready to begin playback.

_UIT_Scriptor  set                _sysReady          0
Main           regForStartNotify  "_UIT_Scriptor"


_UIT_Scriptor proc sysReadyCB {} {

    _UIT_Scriptor set _sysReady 1
    foreach scriptor [_UIT_Scriptor info instances] {
	$scriptor _start
    }
}



# ------------------------------------------------

_UIT_Scriptor instproc init {args} {

    # for recording
    $self instvar _file
    # "play" "record" or "" (off)
    $self instvar _mode
    # to slow down playback
    $self instvar _pauseSecs
    # list of steps to execute for playback
    $self instvar _stepList
    # step number to assist the user
    $self instvar _stepNum

    set _mode       ""
    set _pauseSecs  0
    set _stepNum    1

    eval $self next $args
}


# ------------------------------------------------
# If recording, finish writing and close file.
#   If playing back, do callback to allow for final checking.

_UIT_Scriptor instproc destroy {} {
    $self instvar _file _mode

    switch $_mode {

	"record" {
	    puts  $_file  "\}"

	    puts  $_file  "\n\n\# Called when InfoMsg dialogs are displayed. "
	    puts  $_file  "$self proc infoMsgCB \{infoMsgObj\} \{"
	    puts  $_file  "\n    \#\#\#\# YOUR CODE CAN GO IN HERE \#\#\#\#\n"
	    puts  $_file  "    \#set severity \[\$infoMsgObj severity\]"
	    puts  $_file  "    \#set messageText \[\$infoMsgObj messageText\]\n"
	    puts  $_file  "\}"

	    puts  $_file  "\n\n\# Final checking. Called after last step. "
	    puts  $_file  "$self proc exitCB \{\} \{"
	    puts  $_file  "\n    \#\#\#\# YOUR CODE CAN GO IN HERE \#\#\#\#\n"
	    puts  $_file  "\}"

	    close $_file
	}

	"play" {
	    if {[catch "$self exitCB" msg]} {
		puts "exitCB had the following error:\n$msg"
	    }
	}
    }
}



# ======================== parameter setting procs ======================

#@ Set parameter to slow down playback.
#@   args:
#@      secs  seconds to pause between steps.

_UIT_Scriptor instproc pause {secs} {
    $self set _pauseSecs $secs
}


# ------------------------------------------------
#@ Go into "play" mode using commands from the specified file.
#@   args:
#@      fileName  script recorded with -recordFile.

_UIT_Scriptor instproc playFile {fileName} {

    # Turn off waiting when replaying script.
    _UIT_InfoMsgGeneric isWaitAllowed 0

    # need to override default because it keeps control.
    proc bgerror {msg} {
	global errorInfo
	set str "\nError! $errorInfo\n"
	puts stderr $str
	exit 1
    }

    # Play the playback file checking that it's readbable and bug-free.
    $self set _mode "play"
    if { ! [file readable $fileName]} {
	puts stderr "Playback file $fileName is non-existant or non-readable."
	exit 1
    }
    if {[catch {source $fileName} stat]} {
	puts stderr "Playback file broken.\n$stat"
	exit 1
    }
    $self _start
}


# ------------------------------------------------
#@ Record execution to the specified file.
#@   args:
#@      fileName  name of file to save execution script.

_UIT_Scriptor instproc recordFile {fileName} {
    $self instvar _file
    global _UIT_g_main

    $self set _mode "record"
    if {[catch "open $fileName w" stat]} {
	puts $stat
	exit
    }

    set   _file  $stat

    set  now [clock format [clock seconds]]
    puts $_file  "\# This file generated by SUIT's scriptor $now."
    puts $_file  "\# For use with $_UIT_g_main suitlet."
    puts $_file  "\n\# Scripting boot strapping code."
    puts $_file  "$self load \{\n\n"
}


# ======================== callback methods  ======================

#@ If playing, execute next step.
#@   args:  none

_UIT_Scriptor instproc idleCB {} {
    $self instvar _stepList

    $self _wait
    set cmd [lvarpop _stepList]
    eval $cmd

    # set up callback for next step
    after idle "$self idleCB"
}


# ------------------------------------------------
#@ If recording, capture window values and note button press.
#@   args:
#@      trigger  Name of object that was triggered a script operation.
#@               Usually a push button.

_UIT_Scriptor instproc scriptOperCB {trigger} {
    $self instvar _file _mode _stepNum

    if {[cequal $_mode "record"]} {
	set win [$trigger getWin]
	puts $_file "\t\{"
	puts $_file "\t    \#\#\#\# STEP $_stepNum \#\#\#\#\n"
	puts $_file "\t    \#\# Set window state"
	foreach state [$win getState] {
	    puts $_file "\t    $state"
	}
	puts $_file "\n\t    \#\# Pause if -pause was given on command line"
	puts $_file "\t    $self _wait"
	puts $_file "\n\t    \#\# Perform error checking"
	puts $_file "\t    eval \{"
	puts $_file "\n\t\t\#\#\#\# YOUR CODE CAN GO IN HERE \#\#\#\#"
	puts $_file "\n\t    \}\n"
	puts $_file "\t    \#\# Process data"
	puts $_file "\t    [$trigger getActCmd]"
	puts $_file "\t\}\n\n"

	incr _stepNum
    }
}


# ------------------------------------------------
#@ In play mode, remove the InfoMsg box once it is displayed.
#@   Also give the script a chance to do its own checks by filling
#@   in code in infoMsgCB in the script.
#@   args:
#@      infoMsgObj - the info message object

_UIT_Scriptor instproc infoMsgHandler { infoMsgObj } {

    $self instvar _mode

    if {[cequal $_mode "play"]} {
	$self _wait

	# perform any user defined actions/checks
	$self infoMsgCB $infoMsgObj

	# close the InfoMsg
	eval [$infoMsgObj getActCmd]
    }
}



# ======================== public methods  ======================

#@ Means for the recorded script file to bootstrap itself.
#@   Contains a list of steps to be executed.
#@   Can't just source it cause may want to pause between steps.
#@   args:
#@      stepList  list of tasks to be played back, each representing
#@                one push button press.

_UIT_Scriptor instproc load {stepList} {
    $self set _stepList $stepList
}


# ======================== private methods  ======================

#@ Start playback if Suit initialized and scriptor in "play" mode.
#@   args:  none

_UIT_Scriptor instproc _start {} {
    $self instvar _mode

    if {[_UIT_Scriptor set _sysReady] &&
	[cequal $_mode "play"]} {
	after idle "$self idleCB"
    }
}


# ------------------------------------------------
#@ Pause the specified time period.
#@   Used in play mode to slow down execution so a person can
#@   see what's going on.

_UIT_Scriptor instproc _wait {} {

    # Give system a chance to catch up
    update

    sleep [$self set _pauseSecs]
}

# ================================================================
