#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: suitletcur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.11  1999/06/03  17:59:09  William_Athanasiou
# 	Ignore SIGINT in parent so child is only one to handle it
# 	[1999/05/24  13:54:06  William_Athanasiou]
#
# Revision 1.1.4.10  1999/03/22  21:08:24  Peter_Wolfe
# 	Code drop for bl23
# 	[1999/03/22  19:52:33  Peter_Wolfe]
# 
# Revision 1.1.2.10  1999/02/09  15:27:57  William_Athanasiou
# 	remove debugging puts
# 	[1999/02/09  15:26:36  William_Athanasiou]
# 
# Revision 1.1.2.9  1998/12/03  22:32:19  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:18  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/06/17  21:20:16  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.6 **
# 		** Merge revision:	1.1.2.7 **
# 	 	** End **
# 	Added "dop" support
# 	Updates to support dop/actions
# 	[1998/06/17  21:14:48  Fred_Cassirer]
# 
# Revision 1.1.2.7  1998/06/03  18:13:58  William_Athanasiou
# 	Execl doesn't need to use eval to expand args
# 	[1998/06/03  18:13:12  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/04/08  21:17:29  Fred_Cassirer
# 	Added support for new Suitlet SIGCHLD handler.
# 	Added death of a child callback support for 'Suitlet' command
# 	[1998/04/08  20:58:43  Fred_Cassirer]
# 
# Revision 1.1.2.5  1998/03/11  14:38:19  Fred_Cassirer
# 	Changed to exactly mirror what is done for the gui case except that here
# 	we wait for the child process to complete as only one curses app at a time
# 	can control the console.  This also fixes a wierd behavior of the previously
# 	used 'exec' command which sometimes seems to loose screen output.
# 	[1998/03/11  14:33:46  Fred_Cassirer]
# 
# Revision 1.1.2.4  1998/01/22  18:26:04  Richard_Taft
# 	Args were passsed to _run as list of list, needed join & eval
# 	to unlistify.
# 	Fred said we need the catch around because the exec was
# 	returning non-zero status.
# 	[1998/01/13  15:02:57  Richard_Taft]
# 
# 	added strategic eval so that exec receives multiple
# 	arguments rather than one big lis.
# 	[1998/01/12  18:55:54  Richard_Taft]
# 
# Revision 1.1.2.3  1997/11/20  23:06:24  Todd_Moyer
# 	Renamed run to _run.
# 	[1997/11/20  22:54:41  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/10/21  14:57:43  Richard_Taft
# 	New file to implement Suitlet classes
# 	[1997/10/17  20:27:48  Richard_Taft]
# 
# $EndLog$
# 
# @(#)$RCSfile: suitletcur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

#@ The Curses version of the Suitlet class
#@ runs suitlets as independent processes.

Class _UIT_SuitletCURSES -superclass _UIT_SuitletGeneric

_UIT_SuitletCURSES instproc start {args} {
   global _UIT_Processes
   $self instvar _task _ackWait _wait _pid _after _callback
   eval {$self next} $args

   catch {ctk_endwin}
   set sig [signal get SIGINT]
   signal trap SIGINT {return ""}
   lassign [$self _run] _pid _err
   set _UIT_Processes($self,Pid) $_pid

   set _val {}
   global errorCode
   while 1 {
      catch {set _val [wait $_pid]} output
      if [cequal $errorCode {POSIX ECHILD {no children}}] {
	 if [lempty $_val] {
	    set _val [list $_pid $output 1]
	 }
	 break;
      }
   }
   signal set $sig
   lassign [set _UIT_Processes($self,Status) $_val] \
       _cpid _txt _status
   catch {ctk_refresh}
   
   # Check for error status and error msg!
   if {$_status != 0} {
      # some error has occurred
      set _UIT_Processes($self,Error) {}
      while ![lempty [lindex [select $_err {} {} 0.0] 0]] {
      	 if {[gets $_err line] > 0} {
	    append _UIT_Processes($self,Error) $line \n
	 } else {
	    break
	 }
      }
      if [lempty $_UIT_Processes($self,Error)] {
	 set _UIT_Processes($self,Error) \
	     "$_task failed with status {$_txt $_status}"
      }
   }
   catch {close $_err}
   
   if {$_wait} {
      return $_UIT_Processes($self,Status)
   } elseif ![lempty $_callback] {
      set _after [after idle \
		      "catch {eval $_callback $self}"]
   } elseif {$_status != 0} {
      set _after [after idle \
		      "InfoMsg error [list $_UIT_Processes($self,Error)] \
		          \"Application Error: $_task\""]
   }
   return {}
}

_UIT_SuitletCURSES instproc _run {} {
   $self instvar _task _args

   # set up a pipe for any errors.
   pipe myErr childErr
   fconfigure $myErr    -buffering none
   fconfigure $childErr -buffering none

   # spawn the child process.

   if {[set pid [fork]] == 0} {
      # dup the stderr channel and close extraneous fds
      dup $childErr stderr; close $childErr; close $myErr
      
      if { $_task == "event_viewer" } {
          catch {execl /usr/share/sysman/menu/tasks/evmviewer/evmviewer $_args } msg
      } else {
          catch {execl /usr/sbin/dop \
		 [concat "-N $_task " $_args] } msg
      }
      

      # if we end up here, then the execl failed.
      puts stderr $msg
      exit 1
   }
   
   # close unused child pipe.
   close $childErr
   
   return [list $pid $myErr]
}

_UIT_SuitletCURSES instproc stop {} {
   global _UIT_Processes
   set _UIT_Processes($self,Status) {Stopped}
   set _UIT_Processes($self,Error) "$_task aborted!"
}

_UIT_SuitletCURSES instproc wait {} {
   global _UIT_Processes
   $self instvar _after
   if [info exists _after] {catch {after cancel $_after}}
   return $_UIT_Processes($self,Status)
}

_UIT_SuitletCURSES instproc _checkForError {} {
   global _UIT_Processes
   InfoMsg error $_UIT_Processes($self,Error) \
       "Execution Failure: [$self set _task]"
}
   
