#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: suitletgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.9  1999/04/23  15:21:50  William_Athanasiou
# 	Fixed problem of missing error messages when task fails to start
# 	[1999/04/22  18:53:44  William_Athanasiou]
#
# Revision 1.1.4.8  1999/02/03  18:45:59  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:50  Sandip_Savalia]
# 
# Revision 1.1.2.9  1999/01/22  19:37:13  William_Athanasiou
# 	Add still waiting window if suitlet takes a long time to start
# 	[1999/01/22  19:36:44  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/12/03  22:32:19  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:21  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/10/01  19:59:49  William_Athanasiou
# 	Only wait on suitlet pids
# 	[1998/09/29  15:20:33  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/07/06  17:24:55  Fred_Cassirer
# 	Added set of _callback_complete in SIGCHLD handler to insure
# 	any parent waiting on this suitlet to start is duely notified.
# 	[1998/07/06  17:24:11  Fred_Cassirer]
# 
# Revision 1.1.2.5  1998/05/27  20:20:45  William_Athanasiou
# 	Fixed use of args as regular parameter
# 	[1998/05/27  20:18:48  William_Athanasiou]
# 
# Revision 1.1.2.4  1998/04/08  21:17:28  Fred_Cassirer
# 	Added death of a child callback support for 'Suitlet' command
# 	[1998/04/08  20:58:46  Fred_Cassirer]
# 
# Revision 1.1.2.3  1997/11/20  23:06:25  Todd_Moyer
# 	Made _run a pure virtual method.
# 	Added getPid method to indicate success of launch.
# 	[1997/11/20  22:57:42  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/10/21  14:57:54  Richard_Taft
# 	New file to implement Suitlet classes
# 	[1997/10/17  18:36:21  Richard_Taft]
# 
# $EndLog$
# 
# @(#)$RCSfile: suitletgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

#@ The suitlet class is used to fork off and run other
#@ suitlets as independent processes.  You do not
#@ declare an object of type suitlet; rather you call
#@ "Suitelet task ?args?".  Task is the full path name
#@ of the suitlet to be run.  Args are optional arguments.

Class _UIT_SuitletGeneric

# ---------------------------------------------------

_UIT_SuitletGeneric instproc init {task args} {
   $self instvar _task _args _realName

   set _task $task
   set _realName $task
   set _args $args
   
   $self _cleanUp
}

_UIT_SuitletGeneric instproc _cleanUp {} {
   $self instvar _ackWait _killSignal _wait _callback _pid
   
   set _pid {}
   set _callback {}
   set _ackWait 30
   set _wait 0
   set _killSignal SIGKILL
   
   global _UIT_Processes
   set _UIT_Processes($self,Status) {}   ;# Hold status of cmd
   set _UIT_Processes($self,Ack)    {}   ;# Hold suitlet ack
   set _UIT_Processes($self,Output) {}   ;# Hold output of cmd
   set _UIT_Processes($self,Error)  {}   ;# Hold error output of cmd
   set _UIT_Processes($self,Pid)    -1   ;# Hold the pid of CMD

   
}
   
#@ Handle process control for the suitlet.  Each subcommand is
#@ different for each of the UI's.

_UIT_SuitletGeneric instproc start {args} {
   # Set up a env variable so that any child process will now 
   # know its a child
   global env
   set env(_SYSMAN_CHILD_PROCESS) 1 
   
   $self instvar _ackWait _killSignal _wait _callback
   foreach {flag val} $args {
      switch -- $flag {
	 -waitforack { set _ackWait $val }
	 -signal { set _killSignal $val }
	 -wait { set _wait $val }
	 -callback { set _callback $val }
	 default {
	    error "Invalid flag in $self _start: $flag"
	 }
      }
   }
}
_UIT_SuitletGeneric instproc stop {} {
   pureVirtual _UIT_SuitletGeneric _stop
}
_UIT_SuitletGeneric instproc wait {} {
   pureVirtual _UIT_SuitletGeneric _wait
}
_UIT_SuitletGeneric instproc label {str} {$self set _realName $str}
_UIT_SuitletGeneric instproc pid {args} {
   global _UIT_Processes; return $_UIT_Processes($self,Pid)
}
_UIT_SuitletGeneric instproc status {args} {
   global _UIT_Processes; return $_UIT_Processes($self,Status)
}
_UIT_SuitletGeneric instproc error {args} {
   global _UIT_Processes
   if [lempty $_UIT_Processes($self,Error)] {
      lassign $_UIT_Processes($self,Status) pid str val
      if {$val != 0} {
	 return $_UIT_Processes($self,Output)
      } else {
	 return ""
      }
   } 
   return $_UIT_Processes($self,Error)
}
_UIT_SuitletGeneric instproc output {args} {
   global _UIT_Processes; return $_UIT_Processes($self,Output)
}

