#!/usr/share/sysman/bin/sysmansh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: suitletgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.13  1999/04/23  15:21:51  William_Athanasiou
# 	Fixed problem of missing error messages when task fails to start
# 	[1999/04/22  18:53:46  William_Athanasiou]
#
# Revision 1.1.4.12  1999/03/22  21:08:25  Peter_Wolfe
# 	Code drop for bl23
# 	[1999/03/22  19:52:35  Peter_Wolfe]
# 
# Revision 1.1.2.16  1999/02/09  15:23:31  William_Athanasiou
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.14 **
# 		** Merge revision:	1.1.2.15 **
# 	 	** End **
# 	fix race condition from menu accelerator
# 	[1999/02/09  15:10:47  William_Athanasiou]
# 
# Revision 1.1.2.15  1999/02/05  17:29:59  Peter_Wolfe
# 	Add fixes for sysman menu launching suitlets directly
# 	[1999/02/05  17:29:51  Peter_Wolfe]
# 
# Revision 1.1.2.14  1999/01/22  19:37:13  William_Athanasiou
# 	Add still waiting window if suitlet takes a long time to start
# 	[1999/01/22  19:36:46  William_Athanasiou]
# 
# Revision 1.1.2.13  1998/12/03  22:32:20  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:18:23  William_Athanasiou]
# 
# Revision 1.1.2.12  1998/08/25  12:18:59  Fred_Cassirer
# 	Added an update idletasks to acknowledge_startup loop to insure
# 	expose events are properly processed while waiting for the child to start.
# 	[1998/08/25  12:18:34  Fred_Cassirer]
# 
# Revision 1.1.2.11  1998/07/31  16:46:48  Fred_Cassirer
# 	Fixed a broken return string in an error path
# 	[1998/07/31  16:46:14  Fred_Cassirer]
# 
# Revision 1.1.2.10  1998/07/30  12:18:28  Fred_Cassirer
# 	Added code to allow child SUIT process to override acknowledgeParent callback
# 	and to provide info text for parent to display
# 	[1998/07/30  12:17:57  Fred_Cassirer]
# 
# Revision 1.1.2.9  1998/07/06  17:24:54  Fred_Cassirer
# 	Added check for _callback_complete in case of SIGCHLD when waiting for
# 	 child startup acknowledgement.
# 	[1998/07/06  17:24:16  Fred_Cassirer]
# 
# Revision 1.1.2.8  1998/06/17  21:20:17  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.5 **
# 		** Merge revision:	1.1.2.7 **
# 	 	** End **
# 	Updates to support dop/actions
# 	[1998/06/17  21:14:50  Fred_Cassirer]
# 
# Revision 1.1.2.7  1998/06/03  18:13:58  William_Athanasiou
# 	Execl doesn't need to use eval to expand args
# 	[1998/06/03  18:13:14  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/05/27  20:20:45  William_Athanasiou
# 	Fixed use of args as regular parameter
# 	[1998/05/27  20:18:52  William_Athanasiou]
# 
# Revision 1.1.2.5  1998/04/08  21:17:30  Fred_Cassirer
# 	Added death of a child callback support for 'Suitlet' command
# 	[1998/04/08  20:58:49  Fred_Cassirer]
# 
# Revision 1.1.2.4  1998/01/22  18:26:06  Richard_Taft
# 	Obj for instproc _run changed from _UIT_SuitletGENERIC to GUI
# 	[1998/01/13  15:00:24  Richard_Taft]
# 
# 	Added strategic eval so that args get passed to
# 	eval individually instead of as one big list.
# 	[1998/01/12  18:57:07  Richard_Taft]
# 
# Revision 1.1.2.3  1997/11/20  23:06:26  Todd_Moyer
# 	Changed run to _run and return process ID to indicate success.
# 	[1997/11/20  22:59:04  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/10/21  14:57:56  Richard_Taft
# 	New file to implement Suitlet classes
# 	[1997/10/17  18:36:23  Richard_Taft]
# 
# $EndLog$
# 
# @(#)$RCSfile: suitletgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

#@ The GUI version of the Suitlet class
#@ runs suitlets as independent processes.

Class _UIT_SuitletGUI -superclass _UIT_SuitletGeneric

# ---------------------------------------------------
#@ Fork off a new suitlet process given the absolute path name.
#@ In the creating process, return the PID (>= 1) if successful or
#@ -1 for failure.  In the created process, returns zero.
# Unscrupulously stolen from sysman menu

_UIT_SuitletGUI instproc start {args} {
   global _UIT_Processes _UIT_g_main env
   $self instvar _pid _window _task _args _ackWait _killSignal \
       _wait _after _callback

   if ![lempty $_pid] {
      if ![lempty $_UIT_Processes($self,Status)] {
	 $self _cleanUp
      } else {
	 return {} ;# cannot restart
      }
   }
   
   eval {$self next} $args  ;# parse arguments to this command
   set env(_SYSMAN_CHILD_PROCESS) 1
   if {[info exists env(_SUIT_SPLASH_SCREEN)] && \
	   [cequal $env(_SUIT_SPLASH_SCREEN) "1"]} {
      set _ackWait 0
   }
   
   if { $_task == "event_viewer" } {
      set retval [ catch {
	set _pid \
          [eval {bgexec _UIT_Processes($self,Status) \
                 -onoutput "$self _getOutput" \
                 -onerror "$self _getError" \
             /usr/share/sysman/menu/tasks/evmviewer/evmviewer} $_args &]} msg]
   } else {
      set retval [ catch {
	set _pid \
          [eval {bgexec _UIT_Processes($self,Status) \
                 -onoutput "$self _getOutput" \
                 -onerror "$self _getError" \
                 /usr/sbin/dop -N $_task} $_args &]} msg]
   }
     

   if { $retval == 0} {
      if {[catch {set _window [$_UIT_g_main getTopWin]}] != 0 \
	      || [lempty $_window]} {
	 set _window _UIT_dummyWindow
      }

      $_window _makeBusy
      set _UIT_Processes($self,Pid) $_pid
      if {$_wait} {
	 if [lempty $_UIT_Processes($self,Status)] {
	    vwait _UIT_Processes($self,Status)
	 }
	 return $_UIT_Processes($self,Status)
      }
      trace variable _UIT_Processes($self,Status) w "$self _done"
      if {$_ackWait} {
	 if [lempty $_UIT_Processes($self,Ack)] {
	    # [pjw] Change from from 3 seconds to 30 seconds to 
	    # temporarily work around a problem with tasks are launched
	    # directly from the command line via sysman menu
	    set _after [after [expr $_ackWait * 100] "$self _timedOut"]
	    vwait _UIT_Processes($self,Ack)
	 }
      }
      $_window _makeNotBusy
      
      return {}
   }
   if {$_wait} {
      return $msg
   } else {
      InfoMsg error $msg "Execution Failure: $_task" wait
   }
   return {}
}

_UIT_SuitletGUI instproc wait {} {
   $self instvar _pid _window
   if ![lempty $_pid] {
      global _UIT_Processes 
      if [lempty $_UIT_Processes($self,Status)] {
	 $_window _makeBusy
	 vwait _UIT_Processes($self,Status)
	 $_window _makeNotBusy
      }
   }
   return $_UIT_Processes($self,Status)
}

_UIT_SuitletGUI instproc stop {args} {
   global _UIT_Processes
   set _UIT_Processes($self,Status) {Stopped} ;# stops job.
   set _UIT_Processes($self,Error) "$_task aborted!"
}

# ---------------------------------------------------------------#
# Support routines.

_UIT_SuitletGUI instproc _getOutput {msg} {
    global _UIT_Processes
    append _UIT_Processes($self,Output) $msg
    puts $msg
}

_UIT_SuitletGUI instproc _getError {msg} {
   global _UIT_Processes
   if [cequal [crange $msg 0 1] ""] {
      $self instvar _after
      if [info exists _after] {
	  after cancel $_after
      } else {
	 if [$self _isWaiting] {
	    # set msg to notify user that application has started
	    #_UIT_SuitletGUI instvar _waitLabel
	    #$_waitLabel configure -text "Application has started"
	    after 3000 "$self _hideWaitWindow"
	 }
      }
      lvarpop msg
      lvarpop msg
   }
   set _UIT_Processes($self,Ack) 1
   if ![lempty $msg] {
      append _UIT_Processes($self,Error) $msg
   }
}

_UIT_SuitletGUI instproc _done {args} {
   # called when status set for process
   global _UIT_Processes
   set _UIT_Processes($self,Ack) 1
   lassign $_UIT_Processes($self,Status) txt pid val msg
   if [cequal $txt "EXITED"] {set txt EXIT}
   set _UIT_Processes($self,Status) [list $pid $txt $val]
   
   $self instvar _after _callback _task
   if [info exists _after] { 
      catch {after cancel $_after} msg 
   } else {
       $self _hideWaitWindow
   }
   
   $self _handleAnyErrors
}

_UIT_SuitletGUI instproc _timedOut {} {
   global _UIT_Processes
   $self instvar _wait _task _args _after

   # If an application launch has taken too long, then we need to
   # warn the user that its taking a long time with a msg window, and then
   # allow the menu to continue.

    $self _showWaitWindow

   # free up the menu.
   set _UIT_Processes($self,Ack) 1         ;# Free up the menu.

   # remove the timeout holder
   unset _after
}

_UIT_SuitletGUI instproc _setWaitMsg {str} {
    _UIT_SuitletGUI instvar _waitLabel
    $_waitLabel configure -text $str
}

_UIT_SuitletGUI instproc _showWaitWindow {} {
    global _UIT_g_main
    _UIT_SuitletGUI instvar _waitWindow _waitLabel

    if ![info exists _waitWindow] {
       global _UIT_InformationImage env
       if [lempty [info commands _UIT_Dialogshell]] {
	  # Must source in these files by hand, since they're not
	  # available to use at this point.  The only place this will
	  # happen is from the menu, so I'm not worried about cham.tcl
	  # sourceing these files as well.
	  puts stderr "error: _SUIT_ has not been initialized"
	  exit 1
       }
       set _waitWindow [_UIT_Dialogshell .t${self} -separator off -title "Please wait"]
       $_waitWindow addTkButton close -text Close \
	   -command "$self _hideWaitWindow"
       #	$_waitWindow addTkButton cancel -text Cancel -command "$self _quitTask"
       $_waitWindow default close
       set _waitLabel [label [$_waitWindow childsite].txt]
       auto_load _UIT_needbitmaps
       set _waitImage [label [$_waitWindow childsite].lbl \
			   -image _UIT_InformationImage]
       pack $_waitImage -anchor w -side left -padx 10
       pack $_waitLabel -anchor w 
    }

    $_waitLabel configure -text "[$self set _realName] is starting..."

    set parent [$_UIT_g_main getTopWin]
    if {! [cequal $parent $self] && ! [cequal $parent {}]} {
	wm group $_waitWindow .$parent
	wm transient $_waitWindow .$parent
	$_waitWindow center .$parent
    } else {
	wm group $_waitWindow .
	wm transient $_waitWindow
	$_waitWindow center
    }
    $_waitWindow activate
    update idletasks
}

_UIT_SuitletGUI instproc _hideWaitWindow {} {
   global _Processes
   _UIT_SuitletGUI instvar _waitWindow
   if [$self _isWaiting] {
      $_waitWindow deactivate
      update idletasks
   }
   set _UIT_Processes($self,Ack) 1
}

_UIT_SuitletGUI instproc _isWaiting {} {
   _UIT_SuitletGUI instvar _waitWindow
   if {[info exists _waitWindow] && [winfo ismapped $_waitWindow]} {
      return 1
   }
   return 0
}

_UIT_SuitletGUI instproc _quitTask {} {
    global _UIT_Processes
    $self instvar _task _args
    
    set _UIT_Processes($self,Status) {TimedOut}
    trace vdelete _UIT_Processes($self,Status) w "$self _done"

    $self _hideWaitWindow
}

_UIT_SuitletGUI instproc _handleAnyErrors {} {
   global _UIT_Processes
   $self instvar _callback _task _wait
  
   if ![lempty $_callback] {
      $_callback $self
   } elseif {!$_wait} {
      set err $_UIT_Processes($self,Error)
      if ![lempty $err] {
	 # we're not waiting for this job to finish somewhere
	 # so report the error
	 InfoMsg error $err "Execution Failure: $_task"
      }
   }
}

proc _UIT_dummyWindow {args} {
   # this process handles suitlet actions that might be done before
   # the suitlet actually starts
   return
}
