#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: suitletjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.9  1999/02/03  18:46:00  Sandip_Savalia
# 	Code drop for baselevel 22
# 	[1999/02/03  16:41:54  Sandip_Savalia]
#
# Revision 1.1.2.12  1998/12/03  22:37:37  William_Athanasiou
# 	Fix global grab and refresh
# 	[1998/12/03  22:36:40  William_Athanasiou]
# 
# Revision 1.1.2.11  1998/07/22  19:14:06  William_Athanasiou
# 	Fix problem exec'ing programs without args
# 	[1998/07/22  19:13:00  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/06/17  21:20:18  Fred_Cassirer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.5 **
# 		** Merge revision:	1.1.2.9 **
# 	 	** End **
# 	Updated to support actions instead of paths
# 	Merged Will's changes from 1.1.2.9 & 1.1.2.8
# 	Updates to support dop/actions
# 	[1998/06/17  21:14:52  Fred_Cassirer]
# 
# Revision 1.1.2.5  1998/03/19  21:54:55  Richard_Taft
# 	Added -splash arg processing for java
# 	[1998/03/18  14:17:36  Richard_Taft]
# 
# Revision 1.1.2.4  1997/11/20  23:06:27  Todd_Moyer
# 	Changed run to _run and return process ID to indicate success.
# 	Check that app is in proper directory and just send relative
# 	portion to Java.
# 	Also check that path doesn't try to back up the hierarchy.
# 	[1997/11/20  23:03:08  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/11/06  19:58:26  William_Athanasiou
# 	Replace all quoted strings with a call to safeXferString
# 	[1997/11/06  19:56:53  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/10/21  14:57:58  Richard_Taft
# 	New file to implement Suitlet classes
# 	[1997/10/17  18:36:27  Richard_Taft]
# 
# $EndLog$
# 
# @(#)$RCSfile: suitletjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

#@ The Java version of the Suitlet class
#@ runs suitlets as independent processes.

Class _UIT_SuitletJAVA -superclass _UIT_SuitletGeneric

# ---------------------------------------------------
#@ Fork off a new suitlet process given the absolute path name.
#@ Because java has special security considerations, the path must
#@ begin with the menu directory and not attempt to back up (have ../).
#@ Returns 1 if the path is OK and -1 if not.

_UIT_SuitletJAVA instproc start { args } {
   global SysmanDir _UIT_Processes _UIT_g_main env
   $self instvar _pid _window _task _args _ackWait _killSignal \
       _wait _after _callback
   
   eval {$self next} $args
   
   # extract -splash, if present
   set splashOpt [lsearch -exact $_args "-splash"]
   if { $splashOpt >= 0 } {
      
      set argNum [expr $splashOpt + 1]
	
	# Find value
	set splashArg [lindex $_args $argNum]
	if { ! [ctype digit $splashArg] } {
	   # not a number => defaults to 1
	   set splashArg 1
	 }
	
	# Remove -splash and arg from args list and 
	# put it back in args
	set _args [list [lreplace $_args $splashOpt $argNum]]
	
     } else {
       # no -splash given => defaults to 1
       set splashArg 1
     }
   
   if [lempty $_args] {
       set _args ""
    }
   putJava "_UIT_Suitlet [safeXferString $_task] $splashArg [safeXferString $_args]"
   
   return 1
}

_UIT_SuitletJAVA instproc wait {} {
   # not implemented yet!
   return
}

_UIT_SuitletJAVA instproc stop {} {
   # not implemented yet!
}

_UIT_SuitletJAVA instproc status {} {
   # not implemented yet!
   return "-1 EXIT 0"
}
