# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: super.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  2000/09/06  19:34:43  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.33  2000/06/07  20:00:19  Todd_Moyer
# 	Fixed quoting issue in getState.
#
# Revision 1.1.2.32  2000/04/12  18:41:54  Todd_Moyer
# 	Added hooks and procs to generate and play automated execution scripts.
#
# Revision 1.1.2.31  1998/06/09  19:14:23  Fred_Cassirer
# 	Added setHelp method for all widgets to update the pointer focus help text
# 	dynamically
# 	[1998/06/09  19:11:42  Fred_Cassirer]
#
# Revision 1.1.2.30  1998/05/08  15:45:06  Todd_Moyer
# 	Added isChanged method.
# 	[1998/05/08  15:43:54  Todd_Moyer]
# 
# Revision 1.1.2.29  1998/04/15  16:19:01  William_Athanasiou
# 	Add -required functionality
# 	[1998/04/15  16:18:37  William_Athanasiou]
# 
# Revision 1.1.2.28  1998/03/16  20:09:24  William_Athanasiou
# 	Add setLabel functionality to allow window and widget labels to be dynamically set
# 	[1998/03/16  20:06:15  William_Athanasiou]
# 
# Revision 1.1.2.27  1998/02/13  22:27:58  William_Athanasiou
# 	Added enable/disable and changeCB funtionality
# 	[1998/02/13  22:23:20  William_Athanasiou]
# 
# Revision 1.1.2.26  1998/02/11  18:44:12  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:55  William_Athanasiou]
# 
# Revision 1.1.2.25  1998/01/29  20:02:51  Todd_Moyer
# 	Added optimize flag to read to speed up list reads.
# 	[1998/01/29  19:44:26  Todd_Moyer]
# 
# Revision 1.1.2.24  1997/12/09  22:19:34  Todd_Moyer
# 	Added comments for the design doc.
# 	[1997/12/09  22:18:06  Todd_Moyer]
# 
# Revision 1.1.2.23  1997/08/22  18:46:21  William_Athanasiou
# 	Update display logic for java compatibility
# 	[1997/08/22  18:35:31  William_Athanasiou]
# 
# Revision 1.1.2.22  1997/08/20  13:00:50  Richard_Taft
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.20 **
# 		** Merge revision:	1.1.2.21 **
# 	 	** End **
# 	Added resetVal instproc to send values to Java prior to display
# 	[1997/07/24  19:38:54  Richard_Taft]
# 
# Revision 1.1.2.21  1997/08/18  17:11:19  William_Athanasiou
# 	Postpone lookup of catalog strings until first display
# 	[1997/08/18  16:55:23  William_Athanasiou]
# 
# Revision 1.1.2.20  1997/07/10  19:26:35  Richard_Taft
# 	Initialize new instvar _javaKnowsMe to false (0).
# 	This variable is set to true as soon as the widget is sent
# 	to java for the very first time.
# 	[1997/07/10  18:49:49  Richard_Taft]
# 
# Revision 1.1.2.19  1997/03/26  19:56:12  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.17 **
# 		** Merge revision:	1.1.2.18 **
# 	 	** End **
# 	_dataNode always points to resource now, cause rec buf hidden inside.
# 	[1997/03/26  19:17:24  Todd_Moyer]
# 
# Revision 1.1.2.18  1997/03/21  15:55:30  William_Athanasiou
# 	Added pointer focus help/creation of _helpStrs catalog
# 	[1997/03/21  15:44:49  William_Athanasiou]
# 
# Revision 1.1.2.17  1997/03/07  20:51:40  William_Athanasiou
# 	Added capability to align labels in chamwdgts
# 	[1997/03/07  20:50:32  William_Athanasiou]
# 
# Revision 1.1.2.16  1997/01/27  16:52:33  Todd_Moyer
# 	 	** Merge Information **
# 		** Command used:	bsubmit **
# 		** Ancestor revision:	1.1.2.14 **
# 		** Merge revision:	1.1.2.15 **
# 	 	** End **
# 	Trim leading and trailing white space from any value before writing it.
# 	White space was confusing the system because it gets trimmed when looking
# 	up list elements.
# 	[1997/01/23  16:27:23  Todd_Moyer]
# 
# Revision 1.1.2.15  1997/01/23  19:29:01  William_Athanasiou
# 	Added displayCB functionality/removed read from display function
# 	[1997/01/23  19:23:14  William_Athanasiou]
# 
# Revision 1.1.2.14  1997/01/16  14:15:51  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:49  William_Athanasiou]
# 
# Revision 1.1.2.13  1996/12/12  16:48:46  William_Athanasiou
# 	Fixed empty function definitions
# 	[1996/12/12  16:41:18  William_Athanasiou]
# 
# Revision 1.1.2.12  1996/12/02  23:00:56  Todd_Moyer
# 	Added display method.
# 	Changed setWdgtFromData and setDataFromWdgt to read and write.
# 	Put methods into alphabetical order.
# 	[1996/12/02  22:54:59  Todd_Moyer]
# 
# Revision 1.1.2.11  1996/11/27  23:22:52  Todd_Moyer
# 	Keep pointer to data in _dataNode.  Get rid of assoRec and assoRsrc.
# 	[1996/11/27  22:58:21  Todd_Moyer]
# 
# Revision 1.1.2.10  1996/11/26  22:10:17  Todd_Moyer
# 	Add resources to the main Cham obj, not the window.
# 	[1996/11/26  22:07:01  Todd_Moyer]
# 
# Revision 1.1.2.9  1996/11/21  16:01:25  Todd_Moyer
# 	Added assoRsrc and assoRec methods.
# 	[1996/11/21  16:00:22  Todd_Moyer]
# 
# Revision 1.1.2.8  1996/10/24  18:45:12  William_Athanasiou
# 	no changes
# 	[1996/10/24  18:44:35  William_Athanasiou]
# 
# Revision 1.1.2.7  1996/09/25  22:18:09  Todd_Moyer
# 	Use getVal and setVal instead of writing directly to _valuePtr.
# 	[1996/09/25  22:15:51  Todd_Moyer]
# 
# Revision 1.1.2.6  1996/09/24  21:03:34  Todd_Moyer
# 	Minor bug fix.
# 	[1996/09/24  20:54:16  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/09/09  19:15:54  Todd_Moyer
# 	Change dump to _dump and output widget and data values in it.
# 	Added findData, setDataFromWdgt and setWdgtFromData methods.
# 	[1996/09/09  19:07:13  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/06  18:41:45  Todd_Moyer
# 	Use tree class and _UIT_g_main object.
# 	[1996/09/06  18:32:09  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/03  20:22:55  Todd_Moyer
# 	Dont need to registerKid anymore because _UIT_Tree takes care of it.
# 	[1996/09/03  20:19:31  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  18:41:13  Deepa_Bachu
# 	Created this file to contain the _UIT_SuperWdgt class file.
# 	[1996/08/30  17:37:02  Deepa_Bachu]
# 
# $EndLog$
# 
# @(#)$RCSfile: super.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


Class _UIT_SuperWdgt -superclass _UIT_ChamWdgt


#-------------------------------------------------

_UIT_SuperWdgt instproc init {args} {
   global _UIT_g_main
   global _UIT_g_wdgtVals
   $self instvar dataID _dataNode _helpTag _lbl _valuePtr \
	 _window _displayedOnce _enabledState required
   
   # set defaults
   set _enabledState normal
   set _UIT_g_wdgtVals($self) ""
   set _valuePtr  _UIT_g_wdgtVals($self)
   set _lbl       [$_UIT_g_main catget $self lbl]

   set _window    [$_UIT_g_main set currWin]
   set _helpTag   [$_UIT_g_main catget $self hlp]
   $_window _registerHelp $self $_helpTag

   set _dataNode  ""     ;# points to resource
   set dataID     ""
   set _displayedOnce 0
   set required 0
   
   eval $self next $args

   if {$required == 1} {
      # add '*' to end of label if one is not there already.
      switch -exact [cindex $_lbl end] {
	 : {
	    set len [expr [clength $_lbl] -1]
	    set lenMinus [expr $len -1]
	    if ![cequal [cindex $_lbl $lenMinus] "*"] {
	       set _lbl [crange $_lbl 0 $lenMinus]
	       append _lbl "*:"
	    }
	 }
	 * {
	 }
	 default {
	    append _lbl "*"
	 }
      }
   }
   
   if {! [cequal $dataID ""]} {
      set _dataNode [$_UIT_g_main addResrc $dataID]
   }
}

#-------------------------------------------------
#@  If this widget has a dataID, look for the resource in the resource tree.
#@  see resTree instproc addResrc
#@   @@@ obsolete?

_UIT_SuperWdgt instproc findData {dataTree} {
    set resID [$self set dataID]
    if {[cequal $att ""]} {
	return
    }
    set res [$dataTree findResrc $res]
    # if resource not found...
    if {[cequal $res ""]} {
	$dataTree dump
        error "Error: resource \"$resID\" not found in resource tree."
    }
    $self set _dataNode $res
}


#-------------------------------------------------
#@ Return a command that can executed later to set the widget's value to its
#@   current value.  Intended for recording execution for automated testing.

_UIT_SuperWdgt instproc getState {} {

    # Need this weird stuff in case string has unmatched braces.
    set     val ""
    lappend val [$self getVal]
    return "\{$self setVal $val\}"
}


#-------------------------------------------------
#@ Get the current widget value.

_UIT_SuperWdgt instproc getVal {} {
    global _UIT_g_wdgtVals
    set [$self set _valuePtr]
}


#-------------------------------------------------
#@ Get the name of the suit window this widget is in.

_UIT_SuperWdgt instproc getWin {} {
    return [$self set _window]
}


#-------------------------------------------------
#@ If the widget has an associated data resource, check if the widget's value
#@   matches the data attribute's value.  If different, return 1 (true).
#@   Otherwise, return 0 (false).

_UIT_SuperWdgt instproc isChanged {} {

    $self instvar _dataNode

    if {[cequal $_dataNode ""]} {
	return 0
    }

    set attr [lindex [$self set dataID] 2]
    if {[cequal [$_dataNode getVal $attr] [$self getVal]]} {
	return 0
    }
    return 1
}


#-------------------------------------------------
#@ Read the widget's value from the associated data resource (if there is one).
#@   Args:  {optimize 0}
#@   The "optimize" arg not used here in the general case, but is used by
#@   some widgets that override this method (and so must be here to
#@   have the same parameter signature).

_UIT_SuperWdgt instproc read {{optimize 0}} {

    $self instvar _dataNode

    if {[cequal $_dataNode ""]} {
	return
    }

    set attr [lindex [$self set dataID] 2]
    $self setVal [$_dataNode getVal $attr]
    # @@@ $self setVal [$_dataNode set value]
}


#-------------------------------------------------
#@ For Java:  make sure DU and applet values are in sync.

_UIT_SuperWdgt instproc resetVal {} {
    $self instvar _displayedOnce

    if { [info exists _displayedOnce] && $_displayedOnce } {
	set tmp $_displayedOnce

	set _displayedOnce 1
	set val [$self getVal]
	set _displayedOnce $tmp

	$self setVal $val
    } else {
	set _displayedOnce 1
    }
}

#-------------------------------------------------
#@ Set the current widget's label value

_UIT_SuperWdgt instproc setLabel {str} {
   $self instvar _lbl _displayedOnce _UIrep
   set _lbl $str
   if $_displayedOnce {
      global _UIT_g_main
      set ui [$_UIT_g_main getUI]
      switch $ui {
	 GUI -
	 CURSES {
	    $_UIrep configure -labeltext $str
	    set parent [$self set _parent]
	    if [string match "_UIT_Down*" [$parent info class]] {
	       $parent _realignWdgts
	    }
	 }
	 JAVA { 
	    putJava "$self setLabel [safeXferString $str]" 
	 }
      }
   }
}

#-------------------------------------------------
#@ Set the current widget's pointer focus help value

_UIT_SuperWdgt instproc setPFH {str} {
   $self instvar _helpTag _displayedOnce _UIrep _window
   set _helpTag $str
   $_window _registerHelp $self $_helpTag
   global _UIT_g_main
   set ui [$_UIT_g_main getUI]
   switch $ui {
     GUI    {}
     CURSES {}
     JAVA   {
        # Force a redisplay for Java
	putJava "$self setPFH [safeXferString $str]" 
     }
   }
}


#-------------------------------------------------
#@ Set the current widget value.

_UIT_SuperWdgt instproc setVal {val} {
    global _UIT_g_wdgtVals
    set [$self set _valuePtr] $val
}


#-------------------------------------------------
#@ Re-read the widget's value from the associated data resource.

_UIT_SuperWdgt instproc updateData {} {
   $self read
}


#-------------------------------------------------
#@ Write the widget's value to the associated data resource
#@ (if there is one).

_UIT_SuperWdgt instproc write {} {

    $self instvar _dataNode

    if {[cequal $_dataNode ""]} {
	return
    }

    set attr [lindex [$self set dataID] 2]
    $_dataNode setVal $attr [string trim [$self getVal]]
}

#-------------------------------------------------
#@ Print the widget's value to standard out, and the associated
#@ data resource's value (if there is one).

_UIT_SuperWdgt instproc _dump {{indent ""}} {
    global _UIT_g_wdgtVals

    $self next $indent

    $self instvar _dataNode
    puts "$indent   wdgt value\t [$self getVal]"
    if {! [cequal $_dataNode ""]} {
	puts "$indent   data value\t [$_dataNode set value]"
    }
}


#-------------------------------------------------
#@ The default is to do nothing.

_UIT_SuperWdgt instproc initCB   {} {;}

#-------------------------------------------------
#@ No-op.  Defined in subclasses.

_UIT_SuperWdgt instproc display {} {;}


#-------------------------------------------------
#@ 
#@ Functions to handle enable/disable widget calls.  Both enable/disable
#@ procs call _setState which must be defined for each widget.  The _setState
#@ instproc is responsible for changing the state of the widget.

_UIT_SuperWdgt instproc enable {} {
   $self instvar _displayedOnce _enabledState
   if {$_displayedOnce} {
      if ![cequal $_enabledState "normal"] {
	 $self _setState normal
      }
   }
   set _enabledState normal
}

_UIT_SuperWdgt instproc disable {} {
   $self instvar _displayedOnce _enabledState
   if {$_displayedOnce} {
      if ![cequal $_enabledState "disabled"] {
	 $self _setState disabled
      }
   }
   set _enabledState disabled
}

#@ Placeholder.  Not currently used.
_UIT_SuperWdgt instproc changeCB {} {;}

#@ Placeholder.  Not currently used.
_UIT_SuperWdgt instproc focus    {} {;}

#@ Placeholder.  Not currently used.
_UIT_SuperWdgt instproc _enterCB {} {;}

#@ Placeholder.  Not currently used.
_UIT_SuperWdgt instproc _leaveCB {} {;}

#-------------------------------------------------
