#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tabgen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.2  2000/05/02  17:58:36  Jie_Luo
# 	break code in the init function to be several functions such that we can override them in Java Mode
#
# Revision 1.1.5.1  2000/04/25  21:59:46  Jie_Luo
# *** Initial Branch Revision ***
#
# Revision 1.1.2.1  1999/10/13  20:12:59  Richard_Taft
# 	In the message catalog, we want to base the tag for the tab button
# 	label on the name of the geomanager.
# 	[1999/10/13  19:08:58  Richard_Taft]
#
# 	Created tabbed widgets!  A tabbed widget is one that has two areas.
# 	At the top is a group of tabs (buttons).  There is one tab for each
# 	page.  Only one page is visible at a time.  Clicking on a tab brings
# 	it's page forward.
# 	The tab pages are Across or Down widgets containing other widgets.
# 	(Note: pages cannot yet be any other kind of widget until I make
# 	hide procs for each of them.)
# 	[1999/10/11  20:25:04  Richard_Taft]
#
# $EndLog$
# 
# @(#)$RCSfile: tabgen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

Class _UIT_TabbedGeneric -superclass _UIT_Container

_UIT_TabbedGeneric instproc init {contents args} {
   
   $self instvar padTop padLeft
   $self instvar _curtab _buttonHolder _tabButtons _tabPages _kids _pageHolder
   global _UIT_g_main

   set padTop 0
   set padLeft 0

   eval {$self next} $args

   # The tab widget will be a Down widget that holds the tab buttons
   # (in an unnamed Across widget) and all the tabbed pages (contents, 
   # also in an unnamed Across widget or a Card Widget if in Java mode).
   # Start off with an empty list of tab buttons.  We will create
   # them later.
   set contents [$self layout $contents]

   # Create the widget tree
   $self fillContents $contents

   ## Now let's make the buttons ##

   $self createTabs

   # Create callbacks for each of the buttons
   $self createButtonCB


   # The initial tab to display is the first in the list
     set _curtab [lindex $_tabPages 0]
}

_UIT_TabbedGeneric instproc initCB {} {
   foreach k [$self set _kids] {
      $k initCB
   }

}

_UIT_TabbedGeneric instproc display {} {
    # First shot: display the whole thing, 
    # then hide all tabs but one

    $self next
    $self instvar _tabPages _curtab
    foreach p $_tabPages {
        if { $p != $_curtab } {
            $p hide
        }
    }
    $_curtab display

}

_UIT_TabbedGeneric instproc _makeButtonName {p} {
    # to make the button name from the page name,
    # get rid of the trailing suffix we may have
    # added (see domain.tcl) and get rid of the
    # window name that's attached to the beginning
    # of the page name.  (w.p## => p)

    set pend [string last "\#\#" $p]
    if { $pend > 0 } {
	set pname [string range $p 0 [expr $pend - 1]]
    } else {
	set pname $p
    }
    return [lindex [split $pname .] end]
}

_UIT_TabbedGeneric instproc layout {contents} {
    return "Down { Across \{\} \n\
                        Down {$contents} }"
}

_UIT_TabbedGeneric instproc  createTabs {} {
   $self instvar _curtab _buttonHolder _tabButtons _tabPages _kids _pageHolder

   # Our only kid is the Down widget we made above
   set d [lindex $_kids 0]
   set dkids [$d set _kids]

   # d's first kid is the Across that holds the tabButtons.
   set _buttonHolder [lindex $dkids 0]

   # d's other kid contains the tabPages.
   set _pageHolder [lindex $dkids 1]
   set _tabPages [$_pageHolder set _kids]

   # For each page, create a tab button declaration
   set tabButtonDecls {}
   foreach p $_tabPages {
       append tabButtonDecls "Button [$self _makeButtonName $p]\n"
   }

   # Now create the widgets for the tab buttons
   $_buttonHolder fillContents $tabButtonDecls
   set _tabButtons [$_buttonHolder set _kids]
}

#create callbacks, java mode overrides this function 
_UIT_TabbedGeneric instproc  createButtonCB {} {
   $self instvar _curtab _tabButtons _tabPages 

   # Create callbacks for each of the buttons
   foreach p $_tabPages b $_tabButtons {
       eval [subst -nocommand {
         $b proc invokeCB {} {
             $self instvar _curtab
             set _curtab $p
             $self display
         }
       }
       ]
   }
}
