#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tabgui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/11/09  18:50:43  Susan_Ng
# 	Code drop for Zulu bl6
#
# Revision 1.1.2.1  1999/10/13  20:13:00  Richard_Taft
# 	Need to highlight the tab buttons
# 	[1999/10/13  19:10:08  Richard_Taft]
#
# 	Created tabbed widgets!  A tabbed widget is one that has two areas.
# 	At the top is a group of tabs (buttons).  There is one tab for each
# 	page.  Only one page is visible at a time.  Clicking on a tab brings
# 	it's page forward.
# 	The tab pages are Across or Down widgets containing other widgets.
# 	(Note: pages cannot yet be any other kind of widget until I make
# 	hide procs for each of them.)
# 	[1999/10/11  20:25:00  Richard_Taft]
#
# $EndLog$
# 
# @(#)$RCSfile: tabgui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

Class _UIT_TabbedGUI -superclass _UIT_TabbedGeneric

_UIT_TabbedGUI instproc init {args} {

    eval {$self next} $args
}

_UIT_TabbedGUI instproc display {} {
    $self instvar _displayedOnce _pageHolder _curtab

    if {!$_displayedOnce} {
       $self instvar _parent containWdgt padLeft padTop
       incr _displayedOnce
       set root [$_parent set containWdgt]
      
       # get unique Id from end of instance name.  This Uid was generated
       # when the Across proc created an instance of _UIT_Across using
       # gensym as the name of the instance.
      
       regsub -all {\.} $self {} name
       set _frm [_UIT_PaddedFrame $root.t${name} $padLeft $padTop]
       set containWdgt [$_frm childsite]
       [$_frm set _Wdgt(hullcmd)] configure -borderwidth 1 -relief ridge
	
	pack $_frm -side [$_parent packSide] -anchor nw -fill both -expand 1
   }

   $self next

   $self format
}

_UIT_TabbedGUI instproc format {} {
    $self instvar _pageHolder _tabButtons _tabPages _curtab

    $_pageHolder configure -borderwidth 1 -relief groove

    foreach b [$self set _tabButtons] p [$self set _tabPages] {
	$b configure -borderwidth 1 -defaultringpad 0 \
	    -highlightthickness 2
	if { $p == $_curtab } {
	    $b disable
	} else {
	    $b enable
	}
    }
}

