#!/usr/bin/tclsh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tabjava.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.3.1  2000/05/02  17:59:39  Jie_Luo
# 	Changes for multicolumn list and for tabbed widget
#
# Revision 1.1.1.1  2000/04/26  13:51:43  Jie_Luo
# *** Initial Branch Revision ***
#
# $EndLog$
# 
# @(#)$RCSfile: tabjava.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 
Class _UIT_TabbedJAVA -superclass _UIT_TabbedGeneric

_UIT_TabbedJAVA instproc init {args} {

    eval {$self next} $args ;# do parent init
}

_UIT_TabbedJAVA instproc display {} {
   $self instvar _displayedOnce _tabButtonLabels


   if {!$_displayedOnce} {
      # SuitContainer needs some pad parameters
      # and the name ($self) comes last 
      # (see SuitContainer.java for the reason).

      putJava "_UIT_Tabbed 0 0 $self"
      
      $self next ;# do kids' display

      putJava "\}"
      #send the labels of each page to the java side      
      putJava_noNL  " $_tabButtonLabels "
 
      incr _displayedOnce
  } else {
      $self next ;# do kids' display
  }
}

_UIT_TabbedJAVA instproc layout {contents} {
    return  " $contents  "
}

_UIT_TabbedJAVA instproc  createTabs {} {
   $self instvar   _tabButtonLabels _tabPages _kids 

   global _UIT_g_main

   #a tab_Pages contains several pages
   set _tabPages  $_kids 

   #set the label of each button which belongs to a page
   set _tabButtonLabels " { "

   foreach p $_tabPages {
     #get name of a button
     set buttonname [$self _makeButtonName $p]

     #set label of a button based on the message file 
     append _tabButtonLabels [safeXferString [$_UIT_g_main catget $buttonname \
                              lbl]]
     append _tabButtonLabels " "
   }
   append _tabButtonLabels " } "
}

#don't need this fuction, since the buttons are created on Java Side.
_UIT_TabbedJAVA instproc  createButtonCB {} {
}

_UIT_TabbedJAVA instproc _makeButtonName {p} {
    # to make the button name from the page name,
    # get rid of the trailing suffix we may have
    # added (see domain.tcl) and get rid of the
    # window name that's attached to the beginning
    # of the page name.  (w.p## => p)

    set pend [string last "\#\#" $p]
    if { $pend > 0 } {
        set pname [string range $p 0 [expr $pend - 1]]
    } else {
        set pname $p
    }
    return $pname
}

