# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tagval.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:07:47  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:41:34  William_Athanasiou]
#
# Revision 1.1.2.3  1997/01/16  14:15:53  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:55  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/01/06  22:14:33  Todd_Moyer
# 	Created to hold functionality.  No immediate plans to use, but
# 	  this would be useful for a mostly empty table like printcap.
# 	[1996/12/27  22:10:46  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: tagval.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 



# This is like a table except the columns (attributes) can change from record
#   to record.  For example, an /etc/printcap record could have any of
#   several dozen attributes, but in most cases will only specify a few.
# There are no immediate plans to use this object in Steel, but since it
#   was written as an early version of table I wanted to preserve it for
#   later use.


# a lot of this is redundant with a _UIT_Table and should be removed.  

Class _UIT_TagVal -superclass _UIT_Table

# ---------------------------------------------------

_UIT_TagVal instproc init {dataID} {
    eval $self next _UIT_TagVal $dataID
    $self set _nextId 1
    $self set _numRecs 0
    $self set _order {}
}


# ===================================================
# public methods.

# ---------------------------------------------------
# Add the new record before element "targetId" or at the end if no target
# given.

_UIT_TagVal instproc add { {targetId end} } {
    $self instvar _order

    set id [$self _add]
    if {[cequal $targetId end]} {
	lappend _order $id
    } else {
	set tIdx [lsearch -exact $_order $targetId]
	if {$tIdx < 0} {
	    error "Error: couldn't find targetID $targetId in add."
	}
	set _order [linsert $_order $tIdx $id]
    }
    set id
}


# ---------------------------------------------------
# Add the new record before index "targetIdx" (starting at zero).
# I cann't see how the caller will know the index, but here it is
# just in case.

_UIT_TagVal instproc addAt {targetIdx} {
    $self instvar _order

    set id [$self _add]
    set _order [linsert $_order $targetIdx $id]
    set id
}


# ---------------------------------------------------
# Set the record buffer to the data from the specified record.
# If the record is not specified, it sets the default record values.
# If it is specified, it must be a vlaid ID or "default".

_UIT_TagVal instproc buffer { {id "default"} } {
   [$self set _recBuf] reset $id
}


# ---------------------------------------------------
# Delete the specified record(s).

_UIT_TagVal instproc delete {ids} {
    $self instvar _data
    $self instvar _order
    $self instvar _numRecs

    foreach id $ids {
	set idx [lsearch -exact $_order $id]
	if {$idx < 0} {
	    puts "Error: couldn't find targetID $id in delete."
	    puts "Deleted IDs before but not those after."
	    puts "Aborting!"
	    exit
	}
	unset _data($id)
	set _order [lreplace $_order $idx $idx]
	incr _numRecs -1
    }
}


# ---------------------------------------------------
_UIT_TagVal instproc dump {} {
    puts "\n dump of $self"
    foreach id [$self set _order] {
	puts "$id [$self set _data($id)]"
    }
    puts ""
    $self next
}

# ---------------------------------------------------
# Find the first record with attribute values matching those in the target and
#   return its ID.  "tags" indicates which attributes are to be matched and
#   their order to make the search faster.  All records must have values for
#   the attributes in "tags".
#   Return the ID of the first record that matches, or -1 if none.

_UIT_TagVal instproc findRec {tags targetArrayName} {
    upvar 1 $targetArrayName target

    foreach id [$self set _order] {
	$self getRec $id data
	set found 1
	foreach tag $tags {
	    if {$data($tag) != $target($tag)} {
		set found 0
		break
	    }
	}
	if {$found} {
	    return $id
	}
    }
    return -1
}


# ---------------------------------------------------
# Get the ordered list of record IDs.

_UIT_TagVal instproc getIDs {listName} {
    upvar 1 $listName dest
    set dest [$self set _order]
    set listName
}


# ---------------------------------------------------
# Used by _UIT_Rec to read its values.

_UIT_TagVal instproc getRec {id arrName} {
    upvar 1 $arrName arr

    array set arr [$self set _data($id)]
    set id
}


# ---------------------------------------------------
# Get the number of records.

_UIT_TagVal instproc numRecs {} {
    $self set _numRecs
}


# ---------------------------------------------------
# Set the specified record to the specified array's values.
# Used by _UIT_Rec to write it's values.

_UIT_TagVal instproc setRec {id arrName} {
    upvar 1 $arrName arr

    $self set _data($id) [array get arr]
    set id
}


# ===================================================
# private methods.

# Create an ID for a new record, put it in the recBuf and write the buffer.
# Return the new ID.

_UIT_TagVal instproc _add {} {
    $self instvar _nextId
    $self instvar _numRecs
    $self instvar _recBuf

    set id $_nextId
    incr _nextId
    incr _numRecs
    $_recBuf setRecID $id
    $_recBuf write
    set id
}


# ===================================================
