# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tbldmi.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.2  1999/12/16  20:56:26  William_Athanasiou
# 	sysman bulk submit for BL7
#
# Revision 1.1.2.15  1999/12/15  14:33:48  Todd_Moyer
# 	Added optional 'filter' arg to 'read' method.  Also, moved 'initFetch' arg from 'read' to 'init'.
#
# Revision 1.1.2.14  1999/11/04  21:16:08  Omar_Ortiz
# 	Made changes to the "_UIT_TableDMI instproc read"
# 	to take an optional argument "initFetch".
#
# Revision 1.1.2.13  1999/03/01  21:21:58  Todd_Moyer
# 	Re-read the record after adding or modifying it.  This is
# 	  important for mcls where values may change in the FLUSH.
# 	[1999/03/01  21:20:32  Todd_Moyer]
#
# Revision 1.1.2.12  1998/03/19  17:53:49  Todd_Moyer
# 	Trim debug info off error msgs.
# 	[1998/03/19  17:51:23  Todd_Moyer]
# 
# Revision 1.1.2.11  1998/02/10  22:32:19  Todd_Moyer
# 	If miInit returns an error, display with infoMsg instead of error.
# 	[1998/02/10  22:22:46  Todd_Moyer]
# 
# Revision 1.1.2.10  1998/01/22  21:38:11  Todd_Moyer
# 	Added comments that design doc can parse.
# 	[1998/01/22  21:37:33  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/11/20  23:06:28  Todd_Moyer
# 	Comment out miReadRow call to reset table pointer.
# 	miReadAll takes care of it.
# 	[1997/11/20  23:05:47  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/08/19  18:33:27  Todd_Moyer
# 	Moved most of add, modify and delete into superclass.
# 	Have thin data-layer-specific calls now.
# 	[1997/08/19  18:12:47  Todd_Moyer]
# 
# Revision 1.1.2.7  1997/07/25  12:59:39  Fred_Cassirer
# 	Added support for miReadAll interface
# 	[1997/07/25  12:59:04  Fred_Cassirer]
# 
# Revision 1.1.2.6  1997/04/03  13:22:27  Todd_Moyer
# 	Fixed call to miValidate.
# 	[1997/04/03  13:21:17  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/04/01  20:35:13  Todd_Moyer
# 	Somehow I forgot the _validate routine.  Copied the one in grpdmi.tcl.
# 	[1997/04/01  20:34:33  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/03/31  15:50:05  Todd_Moyer
# 	Added validation and error checking.
# 	[1997/03/28  15:13:59  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/02/12  22:15:06  Todd_Moyer
# 	Discard old data (if any) when doing read method.
# 	[1997/02/12  22:13:55  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/01/22  22:41:43  Todd_Moyer
# 	Created.
# 	[1997/01/22  22:40:41  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: tbldmi.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


#@ This class implements a table via DMI calls.

Class _UIT_TableDMI -superclass _UIT_Table


# ---------------------------------------------------

_UIT_TableDMI instproc init {dataID {initFetch 1} } {

    eval $self next $dataID
    set lst [split $dataID /]
    $self set _comp       [lindex $lst 1]
    $self set _table      [lindex $lst 2]
    $self set _reallyRead $initFetch
    set stat [miInit [$self set _comp]]
    if {! [cequal $stat ""]} {
	InfoMsg error $stat "Initialization Error" 1
	exit
    }
}


# ===================================================
# public methods.

# ---------------------------------------------------
#@ Read the data from the data layer and expand the default record into the
#@ buffer.

_UIT_TableDMI instproc read { {filter ""} } {
    $self instvar _atts _comp _data _table _nextId _numRecs _order _reallyRead
 
    set _nextId 1
    set _numRecs 0
    set _order {}

    # get attribute list
    set stat [miGetKids /$_comp/$_table _atts]
    if {! [cequal $stat ""]} {
	return $stat
    }

    # read default values
    set stat [miGetDefaults $_comp $_table _data(default)]
    if {! [cequal $stat ""]} {
	return $stat
    }

    # If first time and "initFetch" switch was set to off (zero), don't read.
    #   Otherwise, read and add all the records at once.
    if {$_reallyRead} {
        set origNextId $_nextId
        set stat [miReadAll $_comp $_table _data _order _nextId $filter]
        if {! [cequal $stat ""]} {
	    return $stat
        }
        incr    _numRecs [expr $_nextId - $origNextId]
    }
    # But do read after first time no matter what "initFetch" was.
    set _reallyRead 1
     
    # set the record buffer to the default record
    $self buffer

    return ""
}



# ==================== Protected Methods ==============================

#@ Add the record to the data layer.
#@ Return the status: "" if OK or a msg if not.

_UIT_TableDMI instproc _addDL {newRecRef nextRecRef newOrderIdx} {
    $self instvar _comp _table
    upvar $newRecRef  newRec
    upvar $nextRecRef nextRec

    MCL_AddRow $_comp $_table reserved $newRec $nextRec newRec
}



# ---------------------------------------------------
#@ Delete the record from the data layer.
#@ Return the status: "" if OK or a msg if not.

_UIT_TableDMI instproc _deleteDL {recID} {
    $self instvar _comp _data _table

    miDelRow $_comp $_table reserved $_data($recID)
}



# ---------------------------------------------------
#@ Write the record to the data layer.
#@ Return the status: "" if OK or a msg if not.

_UIT_TableDMI instproc _modifyDL {newRecRef recID} {
    $self instvar _comp _data _table
    upvar $newRecRef newRec

    MCL_ModRow $_comp $_table reserved $_data($recID) $newRec newRec
}


# ---------------------------------------------------
#@ Validate the values in the record buffer with the data layer and return
#@ the result.
#@ For an add the recID is ""  For a delete the newRec contains ""
#@ For a modify both contain data.
#@ If everything is OK, "" is returned.
#@ Otherwise an error msg is returned.

_UIT_TableDMI instproc _validateDL {newRecRef recID} {
    upvar $newRecRef newRec
    $self instvar _comp _data _table

    if {[cequal $recID ""]} {
	return [miValidate $_comp $_table reserved "" $newRec]
    }
    miValidate $_comp $_table reserved $_data($recID) $newRec
}


# ==================================================
