# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tblfile.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.3  1997/05/19  18:07:49  William_Athanasiou
# 	Drop for pre-BL11 build
# 	[1997/05/16  17:41:38  William_Athanasiou]
#
# Revision 1.1.2.3  1997/01/16  14:15:55  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:14:58  William_Athanasiou]
# 
# Revision 1.1.2.2  1996/11/27  23:22:57  Todd_Moyer
# 	Created.
# 	[1996/11/27  23:20:53  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: tblfile.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


# This class implements a table as a file in array-get format.
# It assumes the first record are the default values.


Class _UIT_TableFILE -superclass _UIT_Table


# ---------------------------------------------------

_UIT_TableFILE instproc init {dataID} {
    eval $self next $dataID
}


# ---------------------------------------------------
# Read the data from the data layer and expand the default record into the
# buffer.  Assumes the first line contains default values.

_UIT_TableFILE instproc read {} {
    $self instvar _data
    $self instvar _nextId
    $self instvar _numRecs
    $self instvar _order

    set first 1
    for_file line [$self set _dataID] {
	if {$first} {
	    set     _data(default)  $line
	    set     first 0
	} else {
	    set     _data($_nextId) $line
	    lappend _order $_nextId
	    incr    _nextId
	    incr    _numRecs
	}
    }
    $self buffer
}


# ---------------------------------------------------
# Validate the values in the record buffer with the data layer and return
# the result.
# If everything is OK, OK is returned and the tag list is set to "".
# If one or more attributes are bad, BAD_ATTRS is returned and the tag list
# is set to the tags of the bad values.
# If the values are OK individually but two or more clash, ATTR_CLASH is
# returned and the tags of the clashing attributes are put in the
# tag list.

_UIT_TableFILE instproc validate {badAttrsName} {
    upvar $badAttrsName badAttrs

    set badAttrs ""
    return OK
}


# ---------------------------------------------------
# Write the data to the data layer.

_UIT_TableFILE instproc write {} {

    set f [open [$self set _dataID] w] 
    puts $f "[$self set _data(default)]"
    foreach id [$self set _order] {
        puts $f "[$self set _data($id)]"
    }
    close $f
}

# ==================================================
