# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tbltest.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.5  1997/08/26  16:28:56  Peter_Wolfe
# 	Code drop for bl12
# 	[1997/08/25  18:16:36  Peter_Wolfe]
#
# Revision 1.1.2.7  1997/08/19  18:33:29  Todd_Moyer
# 	Moved most of add, modify and delete into superclass.
# 	Have thin data-layer-specific calls now.
# 	[1997/08/19  18:13:47  Todd_Moyer]
# 
# Revision 1.1.2.6  1997/03/31  15:50:06  Todd_Moyer
# 	Fixed typo in addAt
# 	[1997/03/27  21:36:13  Todd_Moyer]
# 
# Revision 1.1.2.5  1997/03/26  19:56:15  Todd_Moyer
# 	Added validation and some checking for developer errors.
# 	[1997/03/26  19:30:24  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/02/12  22:15:07  Todd_Moyer
# 	Discard old data (if any) when doing read method.
# 	[1997/02/12  22:14:21  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/01/16  14:15:56  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:03  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/01/06  22:14:36  Todd_Moyer
# 	Created.
# 	[1997/01/06  21:27:08  Todd_Moyer]
# 
# $EndLog$
# 


# This class implements a table as a file in list format.
# It is intended as a test platform to separate Chameleon from the data layer.
# It is different from a _UIT_TableFILE in that it adds, modifies and deletes
# individual records as oposed to writing the whole file.
# It assumes the first line contains the attribute names and
# the second the default values.


Class _UIT_TableTEST -superclass _UIT_Table


# ---------------------------------------------------

_UIT_TableTEST instproc init {dataID} {
    eval $self next $dataID

    # validation proc needs to be in the same directory as the data with
    #   the name resource-name.val.tcl
    # if file exists, load it.
    set valFile "[$self set _dataID].val.tcl"
    if {[file exists $valFile]} {
	source $valFile
    }
}


# ===================================================
# public methods.

# ---------------------------------------------------
# Read the data from the data layer and expand the default record into the
# buffer.  Assumes the first line contains the attribute names and
# the second default values.

_UIT_TableTEST instproc read {} {
    $self instvar _atts
    $self instvar _data
    $self instvar _nextId
    $self instvar _numRecs
    $self instvar _order

    # discard current data
    set _nextId 1
    set _numRecs 0
    set _order {}

    # read attributes, and default record
    set fileName [$self set _dataID]
    if {! [file readable $fileName]} {
	set    msg "_UIT_TableTEST::read  Cann't open file $fileName for "
	append msg "reading.  Check the pathname and permissions."
	error $msg
    }
    set   f  [open $fileName r]
    gets $f _atts
    gets $f _data(default)

    gets $f line
    while {! [eof $f]} {
        set     _data($_nextId) $line
	lappend _order $_nextId
	incr    _nextId
	incr    _numRecs
	gets $f line
    }
    close $f
    $self buffer
}


# ==================== Protected Methods ==============================

# Add the record to the data layer.
# Return the status: "" if OK or a msg if not.

_UIT_TableTEST instproc _addDL {newRecRef nextRecID newOrderIdx} {
    upvar $newRecRef  newRec
    $self instvar _file _order

    set idx  [$self _writeBegin $newOrderIdx]

    # write new rec
    puts $_file $newRec

    set post [lrange $_order $idx end]
    $self _writeEnd post

    return ""
}



# ---------------------------------------------------
# Delete the record from the data layer.
# Return the status: "" if OK or a msg if not.

_UIT_TableTEST instproc _deleteDL {recID} {
    $self instvar _order

    set idx  [$self _writeBegin $recID]

    # skip del rec
    incr idx

    set post [lrange $_order $idx end]
    $self _writeEnd post

    return ""
}



# ---------------------------------------------------
# Write the record to the data layer.
# Return the status: "" if OK or a msg if not.

_UIT_TableTEST instproc _modifyDL {newRecRef recID} {
    upvar $newRecRef newRec
    $self instvar _file _order

    set idx  [$self _writeBegin $recID]

    # write new and skip old rec
    puts $_file $newRec
    incr idx

    set post [lrange $_order $idx end]
    $self _writeEnd post

    return ""
}



# ---------------------------------------------------
# Validate the values in the record buffer with the data layer and return
# the result.
# If everything is OK, "" is returned.
# Otherwise an error msg is returned.

_UIT_TableTEST instproc _validateDL {newRecRef recID} {
    upvar $newRecRef newRec
    $self instvar _data

    if {[cequal $recID ""]} {
	return [$self validateCB "" $newRec]
    }
    $self validateCB $_data($recID) $newRec
}



# ---------------------------------------------------
# Dummy validation in case no callback defined.

_UIT_TableTEST instproc validateCB {oldRec newRec} {
    return  ""
}


# ---------------------------------------------------
# Start writing data to the file to the ID given.

_UIT_TableTEST instproc _writeBegin {targetID} {
    $self instvar _atts _data _file _order

    set fileName [$self set _dataID]
    if {! [file writable $fileName]} {
	set    msg "_UIT_TableTEST::_write  Cann't open file $fileName for "
	append msg "writing.  Check the pathname and permissions."
	error $msg
    }
    set   _file  [open $fileName w]

    puts $_file $_atts
    puts $_file $_data(default)

    set idx [lsearch -exact $_order $targetID]
    if {$idx < 0} {
	set idx [llength $order]
    }
    foreach id [lrange $_order 0 [expr $idx - 1]] {
        puts $_file $_data($id)
    }
    return $idx
}


# ---------------------------------------------------
# Finish writing data to the file for the IDs given.

_UIT_TableTEST instproc _writeEnd {idsRef} {
    upvar idsRef ids
    $self instvar _data _file

    foreach id $ids {
        puts $_file $_data($id)
    }
    close $_file
}


# ==================================================
