#
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: timer.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.1  1999/11/09  18:50:44  Susan_Ng
# 	Code drop for Zulu bl6
#
# Revision 1.1.2.4  1999/11/01  15:39:35  Richard_Taft
# 	Fixed typo
#
# Revision 1.1.2.3  1999/10/22  14:07:51  Richard_Taft
# 	resetting time to idle will reset recur to 0
#
# Revision 1.1.2.2  1999/10/21  19:02:24  Richard_Taft
# 	Added meat to timer stubs
#
# Revision 1.1.2.1  1999/10/13  13:17:17  Todd_Moyer
# 	Stubbed out routines.
# 	[1999/10/13  13:16:29  Todd_Moyer]
#
# $EndLog$
# 
# @(#)$RCSfile: timer.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


Class Timer -superclass _UIT_Tree

#@ Class to create one-time or recurring "alarm" callbacks after some
#@   time interval.
#@ Timer name -time interval -command command [-recurring recur] 
#@     interval - time in milliseconds until the callback is called
#@                or "idle" to trigger the callback as soon as there are
#@                no pending events. 
#@     command - the command to invoke at the specified time. You can define
#@               methods on the timer object once it has been created, and
#@               call them as "-command {$self methName arg1 arg2 ...}".
#@               If the timer is defined in Suit's GenUID file, the callback
#@               can be defined in the callback file. If the timer isn't
#@               created until a callback, it cannot define methods until
#@               after it is created. 
#@     recur - an optional boolean parameter that will cause the timer to
#@             recur indefinitely after each "interval" time span if set to "1
#@             The default is "0" (zero), meaning that the timer will only
#@             fire once. Note that "idle" timers cannot recur. 

#@ Class variable immediateStart
#@  Set to 1 to indicate that Timers are started by the init proc
#@  Set to 0 to indicate that they will be started elsewhere (see
#@  cham.tcl)
Timer set immediateStart 0

Timer instproc init {args} {
    $self instvar _command _id _interval _recur _state

    # initialize with defaults
    set _command  ""
    set _id       ""
    set _interval 10000
    set _recur    0
    set _state	  off

    eval $self next $args

    # Just in case they tried to make an idle timer recur
    if { [cequal $_interval idle] } {
	set $_recur 0
    }

    # If we are done with initialization, then start the timer
    # right away.
    if { [$class set immediateStart] } {
	$self start
    }
}


#@ Clean up timer "tenticle" before quiting.

Timer instproc destroy {} {
    $self instvar _id _state

    catch "after cancel $_id"
    set _state done

    $self next
}



# ================ Creation parameter initialization ================
# These sevice arguments specified as part of creation, but can also
# be called afterwards.

#@ Creation parameter initialization.
#@   Set the callback procedure including parameters.

Timer instproc command {cmd} {
    $self set _command $cmd
}


#@ Creation parameter initialization.
#@   Set whether this timer should be one-time or recurring.
#@   Will be ignored if an "idle" timer because that can't recur.

Timer instproc recurring {recur} {
    $self instvar _interval _recur

    if { ! [cequal $_interval "idle"]} {
	set _recur  $recur
    }
}



#@ Creation parameter initialization.
#@   Set the time interval, in milliseconds, or "idle".

Timer instproc time {millisecs} {
    $self set _interval $millisecs

    if { [cequal $millisecs "idle"]} {
	$self set _recur 0
    }
}

# ====================== Convenience Methods ======================

#@ state
#@   Returns off if the timer has not been run yet
#@           on if the timer is running
#@           done if the timer is finished

Timer instproc state {} {
    return [$self set _state]
}


#@ start
#@   Starts the timer if it has not already been started.
#@   Returns the state so that you can figure out if it
#@   has been started or if it is done.
#@
#@   Should not be called by programmers, but needed by
#@   cham.tcl (ie, cannot be private).

Timer instproc start {} {
    $self instvar _state _id _interval

    if {[cequal $_state off]} {
	set _id [after $_interval $self _alarmCB]
	set _state on
    }
    set _state
}

# ======================== Private Methods ========================

#@ Callback
#@  Call the user-supplied command and perhaps run the timer again
Timer instproc _alarmCB {} {
    $self instvar _command _id _interval _recur _state

    if { $_command != "" } {
	# Should we catch this?
	eval $_command
    }

    if { $_recur && ![cequal $_interval "idle"] && ![cequal $_state done]} {
	set _id [after $_interval $self _alarmCB]
    } else {
	set _state done
    }
}
