# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: tree.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.7.1  2000/09/06  19:34:47  Peter_Wolfe
# 	Code drop for yankee bl2
#
# Revision 1.1.2.12  2000/07/31  17:45:23  Todd_Moyer
# 	Formalized attributes with get and set methods.
#
# Revision 1.1.2.11  1997/09/16  21:09:30  Todd_Moyer
# 	Changed comments to special comments for Suit
# 	documentation generation.
# 	[1997/09/16  20:55:26  Todd_Moyer]
#
# Revision 1.1.2.10  1997/04/25  14:11:41  Todd_Moyer
# 	Added getKids and getParent methods.
# 	[1997/04/25  14:11:03  Todd_Moyer]
# 
# Revision 1.1.2.9  1997/01/30  14:33:43  Todd_Moyer
# 	Allow addSubtree to take a list of trees instead of just one.
# 	[1997/01/29  21:14:53  Todd_Moyer]
# 
# Revision 1.1.2.8  1997/01/16  14:15:57  William_Athanasiou
# 	Prepend _UIT_ to all classes and globals
# 	[1997/01/15  21:15:06  William_Athanasiou]
# 
# Revision 1.1.2.7  1997/01/10  16:20:56  Deepa_Bachu
# 	Removed the instance of the global "g_maker".
# 	Used "gensym" instead of "g_maker".
# 	[1997/01/10  16:19:02  Deepa_Bachu]
# 
# Revision 1.1.2.6  1996/11/27  23:22:59  Todd_Moyer
# 	Cleaned up display in dump method.
# 	[1996/11/27  22:54:39  Todd_Moyer]
# 
# Revision 1.1.2.5  1996/11/26  22:10:16  Todd_Moyer
# 	loop was off by 1; corrected it.
# 	[1996/11/26  22:09:15  Todd_Moyer]
# 
# 	Made destruction more effecient.
# 	[1996/11/26  19:39:37  Todd_Moyer]
# 
# Revision 1.1.2.4  1996/09/09  19:15:56  Todd_Moyer
# 	Added the findKid method.
# 	[1996/09/09  19:09:55  Todd_Moyer]
# 
# Revision 1.1.2.3  1996/09/06  18:41:48  Todd_Moyer
# 	Create a global maker in g_maker.
# 	[1996/09/06  18:33:48  Todd_Moyer]
# 
# Revision 1.1.2.2  1996/08/30  20:57:32  Todd_Moyer
# 	Created _UIT_Tree class.
# 	[1996/08/30  20:56:39  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: tree.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 


#@ A tree as defined here is an object that is participating in exactly one
#@ directed, acyclic graph.  It's participation must be unique because some
#@ methods destroy children.


Class _UIT_Tree

_UIT_Tree instproc init {args} {
    $self set _parent ""
    $self set _kids   ""
    eval $self next $args
}


#-----------------------------------------------------

_UIT_Tree instproc destroy {} {
    $self instvar _parent

    $self deleteKids
    if {![cequal $_parent ""]} {
	$_parent detatchSubtree $self
    }
}


#-----------------------------------------------------
#@ Add existing tree(s) as children of this tree.

_UIT_Tree instproc addSubtree {subtreeLst} {

    $self instvar _kids

    foreach st $subtreeLst {
	lappend _kids $st
	$st set _parent $self
    }
}


#-----------------------------------------------------
#@ Create new trees and add them as children of this tree.
#@ Returns the names of the kids added.

_UIT_Tree instproc addNewKid {{number 1}} {

    $self instvar _kids

    set names ""
    loop i 0 $number {
	set new [_UIT_Tree gensym]
	$new set _parent $self
	lappend names $new
    }
    eval lappend _kids $names     ;# append kids all at once
    return $names
}


#-----------------------------------------------------
#@ Delete all the children of this tree.

_UIT_Tree instproc deleteKids {} {
    set kids [$self set _kids]
    $self set _kids ""
    foreach k $kids {
	# orphan first cause more efficient to clear child list all at once
	$k set _parent ""
	$k destroy
    }
}


#-----------------------------------------------------
#@ Detatch a child tree from this tree but don't delete it.

_UIT_Tree instproc detatchSubtree {subtree} {

    $self instvar _kids

    set idx [lsearch -exact $_kids $subtree]
    if {$idx >= 0} {
	set _kids [lreplace $_kids $idx $idx]
    }
}


#-----------------------------------------------------
#@ Print the contents of this node, and all it's decendents, to standard out.
#@ Does NOT include private data (such as the tree's links).

_UIT_Tree instproc dump {{indent ""}} {
    $self dumpNode "$indent"
    foreach k [$self set _kids] {
	$k dump "$indent   "
    }
    if {[string compare [$self set _parent] ""] == 0} {   ;# if root...
	puts "\n"
    }
}


#-----------------------------------------------------
#@ Print the contents of this node to standard out.
#@ Does NOT include private data (such as the tree's links).

_UIT_Tree instproc dumpNode {{indent ""}} {
    $self instvar _treeAtts

    puts "\n$indent$self"

    # dump all attributes
    foreach att [lsort [array names _treeAtts]] {
	puts "$indent      $att\t  $_treeAtts($att)"
    }
}



#-----------------------------------------------------
#@ Find the child node with the attribute containing the target value.
#@ Returns "" if not found.

_UIT_Tree instproc findKid {att targetVal} {
    foreach k [$self set _kids] {
	if { ! [catch "set val [$k getAtt $att]"]} {
	    if {[cequal $val $targetVal]} {
		return $k
	    }
	}
    }
    return ""
}


#-----------------------------------------------------
#@ Return the value of the specified attribute.  Returns an error
#@ if the attribute isn't defined.

_UIT_Tree instproc getAtt {tag} {
    return [$self set _treeAtts($tag)]
}


#-----------------------------------------------------
#@ Return a list of the object names for children of this node.

_UIT_Tree instproc getKids {} {
    $self set _kids
}


#-----------------------------------------------------
#@ Return the name of the object that is this node's parent, or "" if none.

_UIT_Tree instproc getParent {} {
    $self set _parent
}


#-----------------------------------------------------
#@ Set the specified attribute to the specified value.

_UIT_Tree instproc setAtt {tag val} {
    $self instvar _treeAtts

    set _treeAtts($tag) $val
}


# =================== private methods =========================

#@ Print the contents of this node, and all it's decendents, to standard out.
#@ Includes private data such as the tree's links.

_UIT_Tree instproc _dump {{indent ""}} {
    $self _dumpNode "$indent"
    foreach k [$self set _kids] {
	$k _dump "$indent   "
    }
    if {[string compare [$self set _parent] ""] == 0} {   ;# if root...
	puts "\n"
    }
}


#-----------------------------------------------------
#@ Print the contents of this node to standard out.
#@ Includes private data such as the tree's links.


_UIT_Tree instproc _dumpNode {{indent ""}} {

    puts "\n$indent$self"

    # dump all instance vars
    foreach v [lsort [$self info vars]] {
	$self instvar $v
	if {[array exists $v]} {
	    puts "$indent   $v\t array..."
	    for_array_keys key $v {
		puts "$indent   $key\t  - [set ${v}($key)]"
	    }
	} else {
	    puts "$indent   $v\t [set $v]"
	}
    }
}

# ===================================================
