# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: treegen.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.8.1  1999/11/05  14:52:56  Peter_Wolfe
# 	Code drop for zulu BL6
#
# Revision 1.1.2.9  1999/07/23  20:10:25  Omar_Ortiz
# 	Added the toggle function. As a result made changes
# 	to "_UIT_TreeGeneric instproc _setTreeState" to
# 	handle the new function.
# 	[1999/07/23  20:09:51  Omar_Ortiz]
#
# Revision 1.1.2.8  1998/05/11  15:22:51  Richard_Taft
# 	The _setState instproc was getting hidden by a proc
# 	of the same name defined in list*.  Changed to
# 	_setTreeState.
# 	[1998/05/11  15:18:40  Richard_Taft]
# 
# Revision 1.1.2.7  1998/01/29  20:02:54  Todd_Moyer
# 	Added comments and optimize flag to treeRead.
# 	[1998/01/29  19:55:48  Todd_Moyer]
# 
# Revision 1.1.2.6  1997/06/11  14:54:54  Richard_Taft
# 	Allow root to be invisible (not displayed) with -invisibileRoot {1|0} option.
# 	Default is 0 (root is displayed).
# 	Added symbols to display of branches:
# 		+ for branch with hidden children (collapsed branch)
# 		- for branch with displayed children (expanded branch)
# 	Added expandAll and collapseAll functions.
# 	Added optional argument to _setTreeState:  If 1 will set the state of the
# 	progeny as well.  Default is 0 (only set state of the current node)
# 	[1997/06/11  14:46:39  Richard_Taft]
# 
# Revision 1.1.2.5  1997/06/09  17:45:32  Richard_Taft
# 	Added treeRead and getSelNodes
# 	[1997/06/09  14:55:16  Richard_Taft]
# 
# Revision 1.1.2.4  1997/06/03  20:24:39  Todd_Moyer
# 	Put Qtree index into list's user data.
# 	[1997/06/03  20:21:57  Todd_Moyer]
# 
# Revision 1.1.2.3  1997/06/03  16:16:13  Richard_Taft
# 	Added fillFromTable and _setupSubtreeFromTable
# 	[1997/06/03  15:50:11  Richard_Taft]
# 
# Revision 1.1.2.2  1997/05/22  18:32:17  Todd_Moyer
# 	  Created.
# 	[1997/05/22  18:30:31  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: treegen.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

#@ Tree widgets are a special kind of list that can expand and
#@ collapse branches.  This generic class is just the tree stuff common
#@ to all UI domains.  The actual UI trees inherit a lot of their functionality
#@ from lists of the same domain.

Class _UIT_TreeGeneric



# ====================== constructor/destructor =============================

_UIT_TreeGeneric instproc init {args} {   
    $self instvar _qTree

    # If user hasn't set invisibleRoot with an option,
    # it defaults to 0
    if { ! [llength [$self info vars invisibleRoot]] } {
	$self set invisibleRoot 0
    }

    $self set _qTree [_UIT_QuikTree gensym {ptr {state collapsed}}]
    $_qTree setVal [$_qTree getRoot] state expanded
}



# ====================== public methods =============================

#@ Collapse any currently selected nodes.

_UIT_TreeGeneric instproc collapse {} {   
    $self _setTreeState "collapsed"
}

#@ Collapse all nodes.

_UIT_TreeGeneric instproc collapseAll {} {   
    $self _setTreeState "collapsed" 1
}


# ---------------------------------------------------
#@ Expand any currently selected nodes.

_UIT_TreeGeneric instproc expand {} {   
    $self _setTreeState "expanded"
}

#@ Expand all nodes.

_UIT_TreeGeneric instproc expandAll {} {   
    $self _setTreeState "expanded" 1
}


# ---------------------------------------------------
#@ Expand selected nodes if they are collapsed and 
#@ collapse selected nodes if they are expanded.

_UIT_TreeGeneric instproc toggle {} {
    $self _setTreeState "toggle"
}

# ---------------------------------------------------
#@ Create pointers into a tree data structure.

_UIT_TreeGeneric instproc fillFromTree {treeObj} {   
    $self instvar _qTree

    # load data from tree
    $_qTree reset
    set rootID [$_qTree getRoot]
    $self _setupSubtree $rootID $treeObj

    # redo display
    $self _resetDisplay
}

# ---------------------------------------------------
#@ Create pointers into a table data structure.
#@ The table must have three fields:
#@	id:	 the name of the node
#@	kids:	 a list of the names of the child nodes
#@	ptr:	 user data, perhaps a pointer to
#@		 another table
#@
#@ fillFromTable takes:
#@	tblRoot: a row in the table
#@	tblObj:  the table itself

_UIT_TreeGeneric instproc fillFromTable {tblRoot tblObj} {
    $self instvar _qTree

    # load data from tree
    $_qTree reset
    set rootID [$_qTree getRoot]
    $self _setupSubtreeFromTable $rootID $tblRoot $tblObj

    # redo display
    $self _resetDisplay
}

# ---------------------------------------------------
# Add a child node

# _UIT_TreeGeneric instproc addKid {} {   
#     $self instvar _qTree

#     set selected [$self getSelUserData]

#     set i 0
#     set rootID [$_qTree getRoot]
#     foreach node $selected {
# 	set oneatt  [concat  ptr $node ]
# 	set attlist [list $oneatt]
# 	set qnode [$_qTree findNode $rootID $attlist]
# 	if { $qnode != -1 } {
# 	    $_qTree addKids $qnode

# # Need to associate node with something....but what?
# #	    $_qTree setVal $qnode ptr <something>
# 	}
#     }
#     $_qTree _dump
#     $self expand
#}


# ---------------------------------------------------
#@ This method fills in the tree listbox.
#@   It is the equivalent of listgen's read method, but
#@   since listgen's read method would hide the treegen's read
#@   in a treegui, treecur or treeweb, we use this tiny hack.
#@   It optionally accepts an optimize flag, but doesn't currently use it.

_UIT_TreeGeneric instproc treeRead {{optimize 0}} {
    $self instvar _dataNode
   
    if {! [cequal $_dataNode ""]} {
	# The root is defined to be the row that
	# has the id "root"
	set tblArr(id) root
	set root [$_dataNode findRec {id} tblArr]
	$self fillFromTable $root $_dataNode
	$self _resetDisplay
    }
}


# ---------------------------------------------------
#@ Return a list of selected elements.
#@   If tree filled from a table, return a list of user data
#@   (see fillFromTable method).  If filled from tree of objects,
#@   return a list of object names.

_UIT_TreeGeneric instproc getSelNodes {} {
    $self instvar _dataNode _qTree

    set nodes {}
    set selected [$self getSelUserData]

    foreach row $selected {
 	set ptr [$_qTree getVal $row ptr]
 	if { $ptr != "" } {

	    if {$_dataNode != ""} {
		# The tree was filled from a table,
		# so return the ptr field of the table
		set tblArr(ptr) $ptr
		$_dataNode getRec $ptr tbl

		lappend nodes $tbl(ptr)

	    } else {
		# The tree was filled from a tree,
		# so just return the object name
		lappend nodes $ptr
	    }
	}
    }
    #puts "$nodes"
    set nodes
}    



# ====================== private methods =============================

#@ Get a list of indented display strings for each node in the tree with an
#@  "expanded" parent.

_UIT_TreeGeneric instproc _getDispStrs {strsPtr nodeID {indent ""}} {
    upvar $strsPtr strs
    $self instvar _qTree

    set data(id)  $nodeID
    set data(ptr) [$_qTree getVal $nodeID ptr]

    set kids [$_qTree getKids $nodeID] 
    set sym "  "

    if {[cequal [$_qTree getVal $nodeID state] "expanded"]} {
	if { [llength $kids] > 0 } {
	    set sym "- "
	}
	$self setListItem strs "$indent$sym[$self formatDisplayStrCB data]" \
		$nodeID

	foreach kid $kids {
	    $self _getDispStrs strs $kid "   $indent"
	}
    } else {				;# collapsed
	if { [llength $kids] > 0 } {
	    set sym "+ "
	}
	$self setListItem strs "$indent$sym[$self formatDisplayStrCB data]" \
		$nodeID
	
    }
}


# ---------------------------------------------------
#@ Reset the display strings from the internal qTree.

_UIT_TreeGeneric instproc _resetDisplay {} {   
    $self instvar _qTree invisibleRoot

    set  strs ""

    if { $invisibleRoot } {
	# if invisible root, call _getDispStrs for each of
	# root's kids

	set kids [$_qTree getKids [$_qTree getRoot]] 
	foreach kid $kids {
	    $self _getDispStrs strs $kid
	}

    } else {
	# root is visible, so just call _getDispStrs
	# once for the root
	$self _getDispStrs strs [$_qTree getRoot]
    }

    # @@@ puts "disp strs $strs"
    $self setVal      $strs
}


# ---------------------------------------------------
#@ Set the state of any currently selected nodes to the specified value,
#@   and recreate display list.

_UIT_TreeGeneric instproc _setTreeState {newVal {recursive 0}} {
    $self instvar _qTree

    # selected is a list of _qtree node IDs
    set selected [$self getSelUserData]

    set toggleVal $newVal

    foreach qnode $selected {

        # Toggles the state of the selected node from collapsed to expanded
        # or vice versa, if the the public method toggle was invoked.
        #
        if { [cequal $toggleVal "toggle"] } {
           set newVal [expr {[cequal [$_qTree getVal $qnode state] "collapsed"]\
           ? "expanded" : "collapsed"}]
        }

	$_qTree setVal $qnode state $newVal $recursive
    }
    $self _resetDisplay
}


# ---------------------------------------------------
#@ Recursively setup pointers into a tree data structure.

_UIT_TreeGeneric instproc _setupSubtree {nodeId nodeObj} {   
    $self instvar _qTree

    $_qTree setVal $nodeId ptr $nodeObj
    set childNodes [$nodeObj getKids]
    set numKids [llength $childNodes]
    if {$numKids >= 1} {
	set kidIds [$_qTree addKids $nodeId $numKids]
	set i 0
	foreach childNode $childNodes {
	    set id [lindex $kidIds $i]
	    $self _setupSubtree $id $childNode
	    incr i
	}
    }
}


# ---------------------------------------------------
#@ Recursively setup pointers into a table data structure.
#@ Arguments:
#@	nodeId:	 the node in the qtree
#@	tblNode: the corresponding node in the table
#@	tblObj:	 the whole table

_UIT_TreeGeneric instproc _setupSubtreeFromTable {nodeId tblNode tblObj} {   
    $self instvar _qTree

    $tblObj getRec $tblNode arr
    $_qTree setVal $nodeId ptr $tblNode

    set childNodes $arr(kids)
    set numKids [llength $childNodes]
    if {$numKids >= 1} {
	set kidIds [$_qTree addKids $nodeId $numKids]
	set i 0
	foreach childNode $childNodes {
	    set kidId [lindex $kidIds $i]

	    set tblArr(id) $childNode
	    set childRec [$tblObj findRec {id} tblArr]

	    $self _setupSubtreeFromTable $kidId $childRec $tblObj
	    incr i
	}
    }
}


# ====================== pure virtual methods =============================
#@ This method is not defined in this abstract class, but must be in the
#@ subclasses that will actually be instantiated.

_UIT_TreeGeneric instproc formatDisplayStrCB {arr} {
   error "Subclasses of TreeGeneric need a definition for formatDisplayStrCB"
}


#@ This method is not defined in this abstract class, but must be in the
#@ subclasses that will actually be instantiated.

_UIT_TreeGeneric instproc getSelUserData {} {
   error "Subclasses of TreeGeneric need a definition for getSelUserData"
}

# ====================== end =============================
