# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: treegui.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.5.4  1998/02/05  17:51:16  William_Athanasiou
# 	update from shared sandbox for BL15
# 	[1998/02/02  20:19:08  William_Athanasiou]
#
# Revision 1.1.2.5  1998/01/29  20:02:55  Todd_Moyer
# 	Added optimize flag to read.
# 	[1998/01/29  19:50:52  Todd_Moyer]
# 
# Revision 1.1.2.4  1997/06/09  17:45:34  Richard_Taft
# 	Override listgen's read method so that treegen's can be called
# 	[1997/06/09  14:54:30  Richard_Taft]
# 
# Revision 1.1.2.3  1997/05/22  18:32:19  Todd_Moyer
# 	Prevent autoSorting.
# 	[1997/05/22  18:29:41  Todd_Moyer]
# 
# Revision 1.1.2.2  1997/04/28  17:58:48  Todd_Moyer
# 	  Created.
# 	[1997/04/28  17:56:03  Todd_Moyer]
# 
# $EndLog$
# 
# @(#)$RCSfile: treegui.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

# Tree widgets in GUI domain. 

Class _UIT_TreeGUI -superclass "_UIT_ListGUI _UIT_TreeGeneric"



# ====================== constructor/destructor =============================

_UIT_TreeGUI instproc init {args} {   

    # override list's default buttons and prevent sorting
    eval \$self next \
	    -buttons \{expand collapse\} \
	    -needSelection \{expand collapse\} \
	    $args \
	    -autoSort 0
}


# ---------------------------------------------------

_UIT_TreeGUI instproc destroy {} {   

    $self next
}


# ---------------------------------------------------

#################################################################
#@ Override the read method for listgen.  This method fills in the
#@ tree by calling treegen's readTree method.  If treegen had it's
#@ own read method, it would get hidden by listgen's.

_UIT_TreeGUI instproc read {{optimize 0}} {   
    $self treeRead $optimize
}

# ====================== end =============================
