#!/usr/bin/sh
# 
# @DEC_COPYRIGHT@
#
# HISTORY
# $Log: txtcur.tcl,v $
# Revision 1.1.1.1  2003/01/23 18:34:39  ajay
# Initial submit to CVS.
#
#
# Revision 1.1.4.9  1999/03/22  21:08:28  Peter_Wolfe
# 	Code drop for bl23
# 	[1999/03/22  19:52:41  Peter_Wolfe]
#
# Revision 1.1.2.13  1999/02/19  19:57:04  Richard_Taft
# 	Put back the asterisks in password fields.
# 	[1999/02/19  19:56:07  Richard_Taft]
# 
# Revision 1.1.2.12  1998/10/26  15:15:23  Richard_Taft
# 	Label state is normal (not enabled) or disabled
# 	[1998/10/23  19:40:30  Richard_Taft]
# 
# Revision 1.1.2.11  1998/04/10  13:35:19  William_Athanasiou
# 	make passwd visible in _setState
# 	[1998/04/10  13:32:51  William_Athanasiou]
# 
# Revision 1.1.2.10  1998/04/10  13:17:00  William_Athanasiou
# 	fix else/if typo
# 	[1998/04/10  13:15:43  William_Athanasiou]
# 
# Revision 1.1.2.9  1998/04/10  02:33:45  William_Athanasiou
# 	Correct uiRep sep. curses/gui uidef
# 	[1998/04/10  02:28:21  William_Athanasiou]
# 
# Revision 1.1.2.8  1998/03/19  21:43:51  William_Athanasiou
# 	Add appendVal method for text widgets
# 	[1998/03/19  21:38:12  William_Athanasiou]
# 
# Revision 1.1.2.7  1998/03/17  18:54:36  William_Athanasiou
# 	Focus should be 0 only when not editable
# 	[1998/03/17  18:53:13  William_Athanasiou]
# 
# Revision 1.1.2.6  1998/03/11  17:50:21  William_Athanasiou
# 	Fixed ui and focus problems
# 	[1998/03/11  17:20:27  William_Athanasiou]
# 
# Revision 1.1.2.5  1998/02/26  21:35:51  William_Athanasiou
# 	Correct initial enable/disable of widget
# 	[1998/02/26  21:30:21  William_Athanasiou]
# 
# Revision 1.1.2.4  1998/02/11  18:44:12  William_Athanasiou
# 	Added disable/enable and change callbacks
# 	[1998/02/11  16:44:58  William_Athanasiou]
# 
# Revision 1.1.2.3  1997/08/18  17:11:20  William_Athanasiou
# 	Postpone catalog lookup until first time widget displayed
# 	[1997/08/18  16:17:50  William_Athanasiou]
# 
# Revision 1.1.2.2  1997/04/11  14:12:13  William_Athanasiou
# 	fixed tab movement/passwd now invisible
# 	[1997/04/11  14:11:22  William_Athanasiou]
# 
# $EndLog$
# 
# @(#)$RCSfile: txtcur.tcl,v $ $Revision: 1.1.1.1 $ (DEC) $Date: 2003/01/23 18:34:39 $
# 

Class _UIT_TextCURSES -superclass _UIT_TextGUI

_UIT_TextCURSES instproc _makeUIrep {parent leaf side} {
   $self instvar _lbl height width _window \
       _labelWdgt editable _isAlignable _valuePtr passwd
   
   if {$editable} {set state normal} {set state disabled}
   
   if {$height == 1} {
      #
      # single line entry
      #
      set uiRep [entryfield $parent.$leaf \
		     -labeltext $_lbl -textvariable $_valuePtr \
		     -width $width -state $state]
      if [cequal $state "disabled"] {
      } elseif {$passwd != 0} {
	 $uiRep config -textvariable {}
	 set ewdgt [$uiRep component entry]
	 $ewdgt configure -show {*}
      }
      pack $uiRep -expand 0 -fill x -anchor nw -padx 0 -side $side
      set _isAlignable $uiRep
      $_window _registerUImap $uiRep $self
      return $uiRep

   } else {
      #
      # multi line entry
      #
      set _labelWdgt [labeledwidget $parent.$leaf -labeltext $_lbl \
			  -labelpos nw]
      set txt [text [$_labelWdgt childsite].txt -height $height -width $width \
		   -wrap word -state $state]
      $txt config -takefocus 1
      pack $txt -fill both -anchor nw -expand 1	 
      pack $_labelWdgt -expand 1 -fill both -anchor nw -padx 0 -side $side
      
      $_window _registerUImap $txt $self
      return $txt
   }
}

_UIT_TextCURSES instproc _updateVal {s pos} {
   $self instvar height _displayedOnce _UIrep editable passwd
   if $_displayedOnce {
      
      if {$height == 1} {
	  $_UIrep icursor $pos
	  if { $passwd } {
	      $_UIrep delete 0 end
	      $_UIrep insert 0 $s
	  }
	  return
      }
      
      if {!$editable} {
	 $_UIrep configure -state normal
	 $_UIrep delete 0.0 end
	 $_UIrep insert 0.0 $s
	 $_UIrep configure -state disabled -takefocus 1
      } else {
	 $_UIrep delete 0.0 end
	 $_UIrep insert 0.0 $s
      }
      if {$pos == 0} {set pos 0.0}
      $_UIrep mark set insert $pos
   }
   
}

_UIT_TextCURSES instproc _setState {val} {
   $self instvar _UIrep editable height _labelWdgt

   set focus 1
   set lstate $val
   if [cequal $val "disabled"] {
      if {$height == 1} {set focus 0}
   } else {
      # labelstate can be either "normal" or "disabled"
      set lstate normal
      if {!$editable} {
	 set val disabled
	 if {$height == 1} {set focus 0}
      }
   }
   if [info exists _labelWdgt] {
      $_labelWdgt configure -labelstate $lstate
      $_UIrep configure -state $val -takefocus $focus
   } else {
      $_UIrep configure -labelstate $lstate -state $val 
      [$_UIrep component entry] configure -takefocus $focus
   }
}  
